package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Rec13.
 * Generated by: EASy-Producer.
 */
public class Rec13Serializer implements Serializer<Rec13> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public Rec13 from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, Rec13Impl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(Rec13 source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Rec13 clone(Rec13 origin) throws IOException {
        return new Rec13Impl(origin);
    }

    @Override
    public Class<Rec13> getType() {
        return Rec13.class;
    }

}
