package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.AvaMqttOutput;

/**
 * Implementation of the application data type AvaMqttOutput.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("AvaMqttOutput")
public class AvaMqttOutputImpl implements AvaMqttOutput {

    @JsonProperty("xaxis")
    @ConfiguredName("xaxis")
    private String xaxis;
    @JsonProperty("yaxis")
    @ConfiguredName("yaxis")
    private String yaxis;
    @JsonProperty("zaxis")
    @ConfiguredName("zaxis")
    private String zaxis;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public AvaMqttOutputImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public AvaMqttOutputImpl(AvaMqttOutput from) {
        this.xaxis = from.getXaxis();
        this.yaxis = from.getYaxis();
        this.zaxis = from.getZaxis();
    }

    @Override
    @JsonIgnore
    public String getXaxis() {
        return xaxis;
    }

    @Override
    @JsonIgnore
    public void setXaxis(String value) {
        this.xaxis = value;
    }

    @Override
    @JsonIgnore
    public String getYaxis() {
        return yaxis;
    }

    @Override
    @JsonIgnore
    public void setYaxis(String value) {
        this.yaxis = value;
    }

    @Override
    @JsonIgnore
    public String getZaxis() {
        return zaxis;
    }

    @Override
    @JsonIgnore
    public void setZaxis(String value) {
        this.zaxis = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += getXaxis() != null ? getXaxis().hashCode() : 0;
        hc += getYaxis() != null ? getYaxis().hashCode() : 0;
        hc += getZaxis() != null ? getZaxis().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof AvaMqttOutput) {
            AvaMqttOutput oth = (AvaMqttOutput) other;
            eq = true;
            eq &= getXaxis() != null ? getXaxis().equals(oth.getXaxis()) : true;
            eq &= getYaxis() != null ? getYaxis().equals(oth.getYaxis()) : true;
            eq &= getZaxis() != null ? getZaxis().equals(oth.getZaxis()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
