package iip.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.iip_aas.ConfiguredName;

import iip.datatypes.MipMqttOutput;

/**
 * Implementation of the application data type MipMqttOutput.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("MipMqttOutput")
public class MipMqttOutputImpl implements MipMqttOutput {

    @JsonProperty("mipcontext")
    @ConfiguredName("mipcontext")
    private String mipcontext;
    @JsonProperty("mipdate")
    @ConfiguredName("mipdate")
    private String mipdate;
    @JsonProperty("mipfrom")
    @ConfiguredName("mipfrom")
    private String mipfrom;
    @JsonProperty("mipid_tag")
    @ConfiguredName("mipid_tag")
    private String mipid_tag;
    @JsonProperty("mipreader")
    @ConfiguredName("mipreader")
    private String mipreader;
    @JsonProperty("mipraw_signal_clock")
    @ConfiguredName("mipraw_signal_clock")
    private String mipraw_signal_clock;
    @JsonProperty("mipraw_signal_data1")
    @ConfiguredName("mipraw_signal_data1")
    private String mipraw_signal_data1;
    @JsonProperty("mipraw_signal_data2")
    @ConfiguredName("mipraw_signal_data2")
    private String mipraw_signal_data2;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public MipMqttOutputImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public MipMqttOutputImpl(MipMqttOutput from) {
        this.mipcontext = from.getMipcontext();
        this.mipdate = from.getMipdate();
        this.mipfrom = from.getMipfrom();
        this.mipid_tag = from.getMipid_tag();
        this.mipreader = from.getMipreader();
        this.mipraw_signal_clock = from.getMipraw_signal_clock();
        this.mipraw_signal_data1 = from.getMipraw_signal_data1();
        this.mipraw_signal_data2 = from.getMipraw_signal_data2();
    }

    @Override
    @JsonIgnore
    public String getMipcontext() {
        return mipcontext;
    }

    @Override
    @JsonIgnore
    public void setMipcontext(String value) {
        this.mipcontext = value;
    }

    @Override
    @JsonIgnore
    public String getMipdate() {
        return mipdate;
    }

    @Override
    @JsonIgnore
    public void setMipdate(String value) {
        this.mipdate = value;
    }

    @Override
    @JsonIgnore
    public String getMipfrom() {
        return mipfrom;
    }

    @Override
    @JsonIgnore
    public void setMipfrom(String value) {
        this.mipfrom = value;
    }

    @Override
    @JsonIgnore
    public String getMipid_tag() {
        return mipid_tag;
    }

    @Override
    @JsonIgnore
    public void setMipid_tag(String value) {
        this.mipid_tag = value;
    }

    @Override
    @JsonIgnore
    public String getMipreader() {
        return mipreader;
    }

    @Override
    @JsonIgnore
    public void setMipreader(String value) {
        this.mipreader = value;
    }

    @Override
    @JsonIgnore
    public String getMipraw_signal_clock() {
        return mipraw_signal_clock;
    }

    @Override
    @JsonIgnore
    public void setMipraw_signal_clock(String value) {
        this.mipraw_signal_clock = value;
    }

    @Override
    @JsonIgnore
    public String getMipraw_signal_data1() {
        return mipraw_signal_data1;
    }

    @Override
    @JsonIgnore
    public void setMipraw_signal_data1(String value) {
        this.mipraw_signal_data1 = value;
    }

    @Override
    @JsonIgnore
    public String getMipraw_signal_data2() {
        return mipraw_signal_data2;
    }

    @Override
    @JsonIgnore
    public void setMipraw_signal_data2(String value) {
        this.mipraw_signal_data2 = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += getMipcontext() != null ? getMipcontext().hashCode() : 0;
        hc += getMipdate() != null ? getMipdate().hashCode() : 0;
        hc += getMipfrom() != null ? getMipfrom().hashCode() : 0;
        hc += getMipid_tag() != null ? getMipid_tag().hashCode() : 0;
        hc += getMipreader() != null ? getMipreader().hashCode() : 0;
        hc += getMipraw_signal_clock() != null ? getMipraw_signal_clock().hashCode() : 0;
        hc += getMipraw_signal_data1() != null ? getMipraw_signal_data1().hashCode() : 0;
        hc += getMipraw_signal_data2() != null ? getMipraw_signal_data2().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof MipMqttOutput) {
            MipMqttOutput oth = (MipMqttOutput) other;
            eq = true;
            eq &= getMipcontext() != null ? getMipcontext().equals(oth.getMipcontext()) : true;
            eq &= getMipdate() != null ? getMipdate().equals(oth.getMipdate()) : true;
            eq &= getMipfrom() != null ? getMipfrom().equals(oth.getMipfrom()) : true;
            eq &= getMipid_tag() != null ? getMipid_tag().equals(oth.getMipid_tag()) : true;
            eq &= getMipreader() != null ? getMipreader().equals(oth.getMipreader()) : true;
            eq &= getMipraw_signal_clock() != null ? getMipraw_signal_clock().equals(oth.getMipraw_signal_clock()) :
                true;
            eq &= getMipraw_signal_data1() != null ? getMipraw_signal_data1().equals(oth.getMipraw_signal_data1()) :
                true;
            eq &= getMipraw_signal_data2() != null ? getMipraw_signal_data2().equals(oth.getMipraw_signal_data2()) :
                true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
