package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for MipMqttInput.
 * Generated by: EASy-Producer.
 */
public class MipMqttInputImplSerializer implements Serializer<MipMqttInputImpl> {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.defineOptionals(MAPPER, MipMqttInputImpl.class, "mipfrom", "mipcommand", "mipbitstream_ai_clock", 
            "mipbitstream_ai_data1", "mipbitstream_ai_data2", "mipreader");
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    @Override
    public MipMqttInputImpl from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, MipMqttInputImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] to(MipMqttInputImpl source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MipMqttInputImpl clone(MipMqttInputImpl origin) throws IOException {
        return new MipMqttInputImpl(origin);
    }

    @Override
    public Class<MipMqttInputImpl> getType() {
        return MipMqttInputImpl.class;
    }

}
