package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for SubmodelElementList.
 * Generated by: EASy-Producer.
 */
public class SubmodelElementListImplSerializer implements Serializer<SubmodelElementListImpl> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public SubmodelElementListImpl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, SubmodelElementListImpl.class);
    }

    @Override
    public byte[] to(SubmodelElementListImpl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public SubmodelElementListImpl clone(SubmodelElementListImpl origin) throws IOException {
        return new SubmodelElementListImpl(origin);
    }

    @Override
    public Class<SubmodelElementListImpl> getType() {
        return SubmodelElementListImpl.class;
    }

}
