package iip.datatypes;

import de.iip_ecosphere.platform.support.ConfiguredName;
import de.iip_ecosphere.platform.support.Ignore;
import de.iip_ecosphere.platform.support.StringUtils;

import iip.datatypes.Rec13;

/**
 * Implementation of the application data type Rec13.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("Rec13")
public class Rec13Impl implements Rec13 {

    @ConfiguredName("intField")
    private int intField;
    @ConfiguredName("stringField")
    private String stringField;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public Rec13Impl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public Rec13Impl(Rec13 from) {
        this.intField = from.getIntField();
        this.stringField = from.getStringField();
    }

    @Override
    @Ignore
    public int getIntField() {
        return intField;
    }

    @Override
    @Ignore
    public void setIntField(int value) {
        this.intField = value;
    }

    @Override
    @Ignore
    public String getStringField() {
        return stringField;
    }

    @Override
    @Ignore
    public void setStringField(String value) {
        this.stringField = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += Integer.hashCode(getIntField());
        hc += getStringField() != null ? getStringField().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof Rec13) {
            Rec13 oth = (Rec13) other;
            eq = true;
            eq &= getIntField() == oth.getIntField();
            eq &= getStringField() != null ? getStringField().equals(oth.getStringField()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
