package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Rec13.
 * Generated by: EASy-Producer.
 */
public class Rec13ImplSerializer implements Serializer<Rec13Impl> {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public Rec13Impl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, Rec13Impl.class);
    }

    @Override
    public byte[] to(Rec13Impl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public Rec13Impl clone(Rec13Impl origin) throws IOException {
        return new Rec13Impl(origin);
    }

    @Override
    public Class<Rec13Impl> getType() {
        return Rec13Impl.class;
    }

}
