package iip.nodes;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.services.environment.DataMapper.BaseDataUnit;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase.NotificationMode;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ConnectorImpl;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;

import iip.datatypes.RoutingCommandImpl;
import iip.datatypes.RoutingConnIn;
import iip.datatypes.RoutingConnInImpl;
import iip.datatypes.RoutingConnOut;
import iip.serializers.AvaMqttOutputImplSerializer;
import iip.serializers.AvaMqttOutputSerializer;
import iip.serializers.MipMqttInputImplSerializer;
import iip.serializers.MipMqttInputSerializer;
import iip.serializers.MipMqttOutputImplSerializer;
import iip.serializers.MipMqttOutputSerializer;
import iip.serializers.RoutingCommandImplSerializer;
import iip.serializers.RoutingCommandSerializer;
import iip.serializers.RoutingConnInImplSerializer;
import iip.serializers.RoutingConnInSerializer;
import iip.serializers.RoutingConnOutImplSerializer;
import iip.serializers.RoutingConnOutSerializer;
import iip.serializers.RoutingTestDataImplSerializer;
import iip.serializers.RoutingTestDataSerializer;
import iip.serializers.SubmodelElementListImplSerializer;
import iip.serializers.SubmodelElementListSerializer;

import org.hamcrest.core.IsAnything;
import org.junit.Test;
import static org.junit.Assert.assertTrue;

/**
 * Implements tests for "MyRoutingConnector". The generated class is meant to be re-usable and extensible, e.g.,
 * regarding the assert predicates. We provide a main method to ease startup.
 * The connector test directly approaches the configured connector, i.e., the addressed device or server must be
 * accessible. The command line parameter {@code --iip.test.samplingTime=t} can specify the time <i>t</i> in ms the
 * connector will do sampling during the test (default <i>t</i>=10000).
 * Generated by: EASy-Producer.
 */
public class MyRoutingConnectorTest {

    private Map<Class<?>, Integer> received = new HashMap<>();
    private static String[] cmdArgs = new String[0];

    /**
     * Represents all potential inputs to the service and the JSON input format.
     */
    public static class DataUnit extends BaseDataUnit {

        private RoutingConnInImpl routingConnIn;
        private RoutingCommandImpl routingCommand;

        /**
         * Returns the value of routingConnIn.
         *
         * @return the value of routingConnIn, may be <b>null</b>
         */
        public RoutingConnInImpl getRoutingConnIn() {
            return routingConnIn;
        }

        /**
         * Changes the value of routingConnIn. [required by Jackson]
         *
         * @param routingConnIn the new value, may be <b>null</b>
         */
        public void setRoutingConnIn(RoutingConnInImpl routingConnIn) {
            this.routingConnIn = routingConnIn;
        }

        /**
         * Returns the value of routingCommand.
         *
         * @return the value of routingCommand, may be <b>null</b>
         */
        public RoutingCommandImpl getRoutingCommand() {
            return routingCommand;
        }

        /**
         * Changes the value of routingCommand. [required by Jackson]
         *
         * @param routingCommand the new value, may be <b>null</b>
         */
        public void setRoutingCommand(RoutingCommandImpl routingCommand) {
            this.routingCommand = routingCommand;
        }

        @Override
        public String toString() {
            return StringUtils.toStringShortStyle(this);
        }

    }

    /**
     * A predicate-based matcher for spring-based output testing. Class generated here, because we do not want to include
     * the testing artifact of services.environment and hamcrest shall not be a major production dependency.
     */
    private class TestMatcher extends IsAnything<Object> {

        private Map<Class<?>, Predicate<?>> predicates = new HashMap<>();

        /**
         * Creates an instance.
         */
        public TestMatcher() {
            super("myRoutingConnector matcher");
        }

        /**
         * Adds a predicate for a given type.
         *
         * @param <T> the type of data to be considered by the predicate
         * @param cls the type to add the predicate for
         * @param pred the predicate
         */
        private <T> void addPredicate(Class<T> cls, Predicate<T> pred) {
            predicates.put(cls, pred);
        }

        @Override
        public boolean matches(Object obj) {
            return test(obj);
        }

        /**
         * Does a typed test against {@link #predicates}.
         *
         * @param <T> the type of data to be considered by the test
         * @param obj the data/object to be tested
         * @return whether {@code obj} matches the condition of a registered predicate or {@code true} if none was
         * registered
         */
        private <T> boolean test(T obj) {
            incrementReceived(obj.getClass());
            printReceivedData(obj);
            @SuppressWarnings("unchecked")
            Predicate<T> pred = (Predicate<T>) predicates.get(obj.getClass());
            return null == pred ? true : pred.test(obj);
        }

    }

    /**
     * Creates an instance and registers the application serializers.
     */
    public MyRoutingConnectorTest() {
        SerializerRegistry.registerSerializer(AvaMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(AvaMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(RoutingCommandImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingCommandSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnInImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnInSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnOutImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnOutSerializer.class);
        SerializerRegistry.registerSerializer(RoutingTestDataImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingTestDataSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListImplSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListSerializer.class);
    }

    /**
     * Tests the connector.
     *
     * @param params the connector parameter to use
     * @param callback the callback to attach to the connector
     *
     * @throws IOException shall not occur
     */
    protected void testConnector(ConnectorParameter params, ReceptionCallback<RoutingConnOut> callback) throws
        IOException {
        // disable AAS connector registration
        ActiveAasBase.setNotificationMode(NotificationMode.NONE);
        ConnectorImpl<RoutingConnOut, RoutingConnIn> conn = new ConnectorImpl<>(MyRoutingConnector.
            createConnectorAdapter());
        conn.connect(params);
        conn.setReceptionCallback(callback);
        conn.request(true);
        // force sampling independent of model
        conn.notificationsChanged(false);
        int samplingTime = CmdLine.getIntArg(cmdArgs, "iip.test.samplingTime", 10000);
        System.out.println("Waiting for sampling... " + samplingTime + " ms until auto-stop");
        TimeUtils.sleep(samplingTime);
        System.out.println("Disconnecting...");
        conn.disconnect();
    }

    /**
     * Returns the connector parameter to be used.
     *
     * @return the connector parameter, by default as configured in the model
     */
    protected ConnectorParameter createConnectorParameter() {
        return MyRoutingConnector.createConnectorParameter();
    }

    /**
     * Increments the received counter for the given data {@code type}.
     *
     * @param type the type to increment the counter for
     */
    private void incrementReceived(Class<?> type) {
        if (received.containsKey(type)) {
            received.put(type, received.get(type) + 1);
        } else {
            received.put(type, 1);
        }
    }

    /**
     * Creates/returns a predicate asserting that the received data of type RoutingConnOut as output of the testing
     * object is ok (or not). Allows for overriding the test behavior with "semantic" expectations.
     *
     * @return the predicate (default: lambda function always returning {@code true})
     */
    protected Predicate<RoutingConnOut> getAssertPredicateRoutingConnOut() {
        return d -> true;
    }

    /**
     * Returns the predicate to assert the counters for received data type instances.
     *
     * @return the predicate (by default, a predicate with constant value {@code true})
     */
    protected Predicate<Map<Class<?>, Integer>> createReceivedCounterAssertPredicate() {
        return m -> true;
    }

    /**
     * Prints the received data. Can be overridden.
     *
     * @param data the received data
     */
    protected void printReceivedData(Object data) {
        System.out.println(data);
    }

    /**
     * Returns the initial period.
     *
     * @return the initial period in ms, no (initial) input delay happens if the value is zero or negative
     */
    protected int getInitialPeriod() {
        return 500;
    }

    /**
     * Tests the connector, here whether the connector (parameterized by {@link #createConnectorParameter()} delivered
     * any data.
     *
     * @throws IOException shall not occur / test failure
     */
    @Test
    public void testConnector() throws IOException {
        MyRoutingConnectorTest test = new MyRoutingConnectorTest();
        AtomicInteger counter = new AtomicInteger(0);
        ReceptionCallback<RoutingConnOut> callback = new ReceptionCallback<RoutingConnOut>() {

            @Override
            public void received(RoutingConnOut data) {
                counter.incrementAndGet();
                printReceivedData(data);
                incrementReceived(RoutingConnOut.class);
            }

            @Override
            public Class<RoutingConnOut> getType() {
                return RoutingConnOut.class;
            }

        };
        test.testConnector(test.createConnectorParameter(), callback);
        assertTrue("Connector does not deliver data", counter.get() > 0);
        assertTrue("Received counters not as expected", createReceivedCounterAssertPredicate().test(Collections.
            unmodifiableMap(received)));
    }

    /**
     * Starts the configured version of this service/connector as main program.
     *
     * @param args command line arguments
     *
     * @throws IOException shall not occur
     */
    public static void main(String[] args) throws IOException {
        cmdArgs = args;
        MyRoutingConnectorTest test = new MyRoutingConnectorTest();
        ReceptionCallback<RoutingConnOut> callback = new ReceptionCallback<RoutingConnOut>() {

            @Override
            public void received(RoutingConnOut data) {
                System.out.println(data);
            }

            @Override
            public Class<RoutingConnOut> getType() {
                return RoutingConnOut.class;
            }

        };
        test.testConnector(test.createConnectorParameter(), callback);
        System.exit(0);
    }

}
