/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingTestData;
import iip.interfaces.ParallelRoutingProcessor3Interface;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.ParallelRoutingProcessor3"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class ParallelRoutingProcessor3
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.ParallelRoutingProcessor3:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private ParallelRoutingProcessor3Interface service = (ParallelRoutingProcessor3Interface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ProcessorP3Impl", ParallelRoutingProcessor3Interface.class, (String)"ParallelRoutingProcessor3", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = ParallelRoutingProcessor3.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_ParallelRoutingProcessor3() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRoutingCommand(data));
        };
    }

    @Bean
    public Function<RoutingTestData, RoutingTestData> transformRoutingTestDataRoutingTestData_ParallelRoutingProcessor3() {
        return data -> this.service.transformRoutingTestData(data);
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Initializing service ParallelRoutingProcessor3: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("ParallelRoutingProcessor3", sId, "RoutingTestApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("ParallelRoutingProcessor3", sId, "RoutingTestApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("ParallelRoutingProcessor3", sId, "RoutingTestApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + this.appInstId, this.processRoutingCommand_ParallelRoutingProcessor3(), RoutingCommand.class, "processRoutingCommand_ParallelRoutingProcessor3-in-0");
        }
    }
}

