/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorFactory;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.events.ConnectorEventUtils;
import de.iip_ecosphere.platform.connectors.events.ConnectorInputHandler;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.MultiConnectorServiceWrapper;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MonitoredTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingConnIn;
import iip.datatypes.RoutingConnOut;
import iip.nodes.MyRoutingConnector;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConditionalOnProperty(value={"iip.service.myRoutingConnector"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class MyRoutingConnector
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.myRoutingConnector:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private MultiConnectorServiceWrapper service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";
    private ConnectorInputHandler<RoutingCommand> routingCommandHandler = ConnectorEventUtils.createInputHandlerInstance((ClassLoader)MyRoutingConnector.class.getClassLoader(), (String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ConnectorCommandEventHandler", RoutingCommand.class);

    public MyRoutingConnector() {
        ConnectorParameter param = MyRoutingConnector.createConnectorParameter();
        YamlArtifact art = YamlArtifact.readFromYamlSafe((InputStream)ResourceLoader.getResourceAsStream((String)"deployment.yml", (ResourceResolver[])new ResourceResolver[0]));
        YamlService serviceData = art.getServiceSafe("myRoutingConnector");
        this.service = new MultiConnectorServiceWrapper(serviceData, () -> param);
        Connector conn0 = ConnectorFactory.createConnector((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ConnectorImpl", () -> param, (ProtocolAdapter[])new TranslatingProtocolAdapter[]{MyRoutingConnector.createConnectorAdapter(() -> this.service.getInPath(""), () -> this.service.getOutPath(""))});
        conn0.setInstanceIdentification("myRoutingConnector");
        conn0.enablePolling(false);
        this.service.addConnector(conn0);
        this.service.setReceptionCallback((ReceptionCallback)new RoutingConnOutReceptionCallback(this));
        this.appInstId = MyRoutingConnector.getAppInstIdSuffix((Service)this.service, (String)"_");
    }

    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter() {
        return MyRoutingConnector.createConnectorAdapter(null, null, null, null);
    }

    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter(Supplier<String> inPathSupplier, Supplier<String> outPathSupplier) {
        return MyRoutingConnector.createConnectorAdapter(null, null, inPathSupplier, outPathSupplier);
    }

    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter(de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider metrics, File log) {
        return MyRoutingConnector.createConnectorAdapter((de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider)metrics, (File)log, null, null);
    }

    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter(de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider metrics, File log, Supplier<String> inPathSupplier, Supplier<String> outPathSupplier) {
        Object adapter = metrics != null ? new MonitoredTranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new RoutingConnOutOutputTranslator(outPathSupplier), (ConnectorInputTypeTranslator)new RoutingConnInInputTranslator(inPathSupplier), metrics, log) : new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new RoutingConnOutOutputTranslator(outPathSupplier), (ConnectorInputTypeTranslator)new RoutingConnInInputTranslator(inPathSupplier));
        return adapter;
    }

    @Bean
    public Consumer<RoutingConnIn> createRoutingConnIn_myRoutingConnector() {
        return data -> {
            MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.send(RoutingConnIn.class, data));
        };
    }

    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_myRoutingConnector() {
        return data -> {
            MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.handleRoutingCommand(data));
        };
    }

    public static ConnectorParameter createConnectorParameter() {
        ManagedServerAddress netKeyMgtAddress;
        YamlArtifact art = YamlArtifact.readFromYamlSafe((InputStream)ResourceLoader.getResourceAsStream((String)"deployment.yml", (ResourceResolver[])new ResourceResolver[0]));
        YamlService yaml = art.getServiceSafe("myRoutingConnector");
        String host = "localhost";
        String hostOverride = null;
        int port = 1234;
        if (null != yaml.getNetMgtKey() && yaml.getNetMgtKey().length() > 0 && null != (netKeyMgtAddress = NetworkManagerFactory.getInstance().getPort(yaml.getNetMgtKey()))) {
            hostOverride = host = netKeyMgtAddress.getHost();
            port = netKeyMgtAddress.getPort();
            System.out.println(host + " " + port);
        }
        return ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)host, (int)port).setApplicationInformation("RoutingTestApp", "").setCacheMode(ConnectorParameter.CacheMode.NONE).setNotificationInterval(500).build();
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(this.getClass()).info("Initializing service myRoutingConnector: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("myRoutingConnector", sId, "RoutingTestApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("myRoutingConnector", sId, "RoutingTestApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("myRoutingConnector", sId, "RoutingTestApp", iId);
            MonitoringService.setUp((Service)this.service, (de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.service.enablePolling(true);
            this.createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + this.appInstId, this.processRoutingCommand_myRoutingConnector(), RoutingCommand.class, "processRoutingCommand_myRoutingConnector-in-0");
        }
    }

    private MultiConnectorServiceWrapper handleRoutingCommand(RoutingCommand data) {
        if (null != this.routingCommandHandler) {
            String newCls = this.routingCommandHandler.getNewConnectorClass((Object)data);
            if (null != newCls && newCls.length() > 0) {
                ConnectorParameter param = MyRoutingConnector.createConnectorParameter();
                try {
                    YamlArtifact art = YamlArtifact.readFromYamlSafe((InputStream)ResourceLoader.getResourceAsStream((String)"deployment.yml", (ResourceResolver[])new ResourceResolver[0]));
                    YamlService serviceData = art.getServiceSafe("myRoutingConnector");
                    MultiConnectorServiceWrapper oldService = this.service;
                    MultiConnectorServiceWrapper newService = new MultiConnectorServiceWrapper(serviceData, () -> param);
                    Connector conn0 = ConnectorFactory.createConnector((String)"newCls", () -> param, (ProtocolAdapter[])new TranslatingProtocolAdapter[]{MyRoutingConnector.createConnectorAdapter(() -> this.service.getInPath(""), () -> this.service.getOutPath(""))});
                    conn0.setInstanceIdentification("myRoutingConnector");
                    conn0.enablePolling(false);
                    newService.addConnector(conn0);
                    newService.setReceptionCallback((ReceptionCallback)new RoutingConnOutReceptionCallback(this));
                    if (!newService.isEmpty()) {
                        newService.setState(ServiceState.STARTING);
                        this.service = newService;
                        oldService.setState(ServiceState.STOPPING);
                        Starter.mapService((Service)this.service);
                    }
                }
                catch (ExecutionException e) {
                    System.out.println("Cannot switch connector: " + e.getMessage());
                }
            }
            this.routingCommandHandler.received((Object)data, this.service.getEventHandlingConnector(RoutingConnIn.class));
        }
        return this.service;
    }
}

