package iip.nodes;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorFactory;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.ConnectorParameter.CacheMode;
import de.iip_ecosphere.platform.connectors.ConnectorParameter.ConnectorParameterBuilder;
import de.iip_ecosphere.platform.connectors.events.ConnectorEventUtils;
import de.iip_ecosphere.platform.connectors.events.ConnectorInputHandler;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.MultiConnectorServiceWrapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MonitoredTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingConnIn;
import iip.datatypes.RoutingConnOut;
import iip.datatypes.RoutingConnOutImpl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'myRoutingConnector'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.myRoutingConnector", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class MyRoutingConnector extends SpringAsyncServiceBase {

    @Value("${iip.service.myRoutingConnector:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private MultiConnectorServiceWrapper service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";
    private ConnectorInputHandler<RoutingCommand> routingCommandHandler = ConnectorEventUtils.createInputHandlerInstance(
        MyRoutingConnector.class.getClassLoader(), 
        "de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ConnectorCommandEventHandler", RoutingCommand.
        class);

    /**
     * Creates an instance.
     */
    public MyRoutingConnector() {
        ConnectorParameter param = createConnectorParameter();
        YamlArtifact art = YamlArtifact.readFromYamlSafe(ResourceLoader.getResourceAsStream("deployment.yml"));
        YamlService serviceData = art.getServiceSafe("myRoutingConnector");
        service = new MultiConnectorServiceWrapper(serviceData, () -> param);
        Connector<Object, Object, RoutingConnOut, RoutingConnIn> conn0 = ConnectorFactory.createConnector(
            "de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ConnectorImpl", () -> param,
            createConnectorAdapter(()->service.getInPath(""), ()->service.getOutPath("")));
        conn0.setInstanceIdentification("myRoutingConnector");
        conn0.enablePolling(false);
        service.addConnector(conn0);
        service.setReceptionCallback(new RoutingConnOutReceptionCallback());
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Creates the default connector adapter without path suppliers. [public for testing]
     *
     * @return the connector adapter
     */
    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter() {
        return createConnectorAdapter(null, null, null, null);
    }

    /**
     * Creates the connector adapter. [public for testing]
     *
     * @param inPathSupplier function returning the actual input base path to use for data accesses, may be <b>null</b>
     * @param outPathSupplier function returning the actual output base path to use for data accesses, may be <b>null</b>
     * @return the connector adapter
     */
    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter(
        Supplier<String> inPathSupplier, Supplier<String> outPathSupplier) {
        return createConnectorAdapter(null, null, inPathSupplier, outPathSupplier);
    }

    /**
     * Creates the connector adapter. [public for testing]
     *
     * @param metrics the metrics provider to use, <b>null</b> for no metric measurements
     * @param log the log file to use to record individual measurements in experiments, <b>null</b> for no logging. Only
     * becomes active if {@code metrics} is not <b>null</b>
     * @return the connector adapter
     */
    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter(de.
        iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider metrics, File log) {
        return createConnectorAdapter(metrics, log, null, null);
    }

    /**
     * Creates the connector adapter. [public for testing]
     *
     * @param metrics the metrics provider to use, <b>null</b> for no metric measurements
     * @param log the log file to use to record individual measurements in experiments, <b>null</b> for no logging. Only
     * becomes active if {@code metrics} is not <b>null</b>
     * @param inPathSupplier function returning the actual input base path to use for data accesses, may be <b>null</b>
     * @param outPathSupplier function returning the actual output base path to use for data accesses, may be <b>null</b>
     * @return the connector adapter
     */
    public static TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> createConnectorAdapter(de.
        iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider metrics, File log,
        Supplier<String> inPathSupplier, Supplier<String> outPathSupplier) {
        TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn> adapter;
        if (metrics != null) {
            adapter = new MonitoredTranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn>(new
                RoutingConnOutOutputTranslator(outPathSupplier), new RoutingConnInInputTranslator(inPathSupplier),
                metrics, log);
        } else {
            adapter = new TranslatingProtocolAdapter<Object, Object, RoutingConnOut, RoutingConnIn>(new
                RoutingConnOutOutputTranslator(outPathSupplier), new RoutingConnInInputTranslator(inPathSupplier));
        }
        return adapter;
    }

    /**
     * Called when data arrived that shall be passed on to the connector.
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingConnIn> createRoutingConnIn_myRoutingConnector() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.send(iip.datatypes.RoutingConnIn.class, data));
        };
    }

    /**
     * Called when data arrived that shall be passed on to the connector.
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_myRoutingConnector() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> handleRoutingCommand(data));
        };
    }

    /**
     * Creates the connector parameter instance. [public for testing]
     *
     * @return the instance to be passed to the connector
     */
    public static ConnectorParameter createConnectorParameter() {
        YamlArtifact art = YamlArtifact.readFromYamlSafe(ResourceLoader.getResourceAsStream("deployment.yml"));
        YamlService yaml = art.getServiceSafe("myRoutingConnector");
        String host = "localhost";
        String hostOverride = null;
        int port = 1234;
        if (null != yaml.getNetMgtKey() && yaml.getNetMgtKey().length() > 0) {
            ServerAddress netKeyMgtAddress = NetworkManagerFactory.getInstance()
                .getPort(yaml.getNetMgtKey());
            if (null != netKeyMgtAddress) {
                host = netKeyMgtAddress.getHost();
                hostOverride = host;
                port = netKeyMgtAddress.getPort();
                System.out.println(host+" "+port);
            }
        }
        return ConnectorParameterBuilder.newBuilder(host, port)
            .setApplicationInformation("RoutingTestApp", "")
            .setCacheMode(CacheMode.NONE)
            .setNotificationInterval(500)
            .build();
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service myRoutingConnector: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("myRoutingConnector", sId, "RoutingTestApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("myRoutingConnector", sId, "RoutingTestApp", iId);
            processingTime = metrics.createServiceProcessingTimer("myRoutingConnector", sId, "RoutingTestApp", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
            // if notifications enabled, enable now also polling as @Autowired is done
            service.enablePolling(true);
            createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + appInstId,
                processRoutingCommand_myRoutingConnector(), RoutingCommand.class, 
                "processRoutingCommand_myRoutingConnector-in-0");
        }
    }

    private static class RoutingConnInInputTranslator extends AbstractConnectorInputTypeTranslator<RoutingConnIn,
        Object> {

        private Supplier<String> pathSupplier;

        private RoutingConnInInputTranslator(Supplier<String> pathSupplier) {
            this.pathSupplier = pathSupplier;
        }

        @Override
        public Object from(RoutingConnIn data) throws IOException {
            ModelAccess access = getModelAccess();
            final ModelInputConverter inConverter = access.getInputConverter();
            final ModelOutputConverter outConverter = access.getOutputConverter();
            final String path = pathSupplier == null ? "" : pathSupplier.get();
            access.set(path + "intField", outConverter.fromInteger(data.getIntField()));
            // done, no instance of pseudo type
            return null;
        }

        @Override
        public Class<? extends Object> getSourceType() {
            return Object.class;
        }

        @Override
        public Class<? extends RoutingConnIn> getTargetType() {
            return RoutingConnIn.class;
        }

    }

    private static class RoutingConnOutOutputTranslator extends AbstractConnectorOutputTypeTranslator<Object,
        RoutingConnOut> {

        private Supplier<String> pathSupplier;

        private RoutingConnOutOutputTranslator(Supplier<String> pathSupplier) {
            this.pathSupplier = pathSupplier;
        }

        @Override
        public RoutingConnOut to(Object source) throws IOException {
            ModelAccess access = getModelAccess();
            final ModelInputConverter inConverter = access.getInputConverter();
            final ModelOutputConverter outConverter = access.getOutputConverter();
            final String path = pathSupplier == null ? "" : pathSupplier.get();
            RoutingConnOut result = new RoutingConnOutImpl();
            result.setSerNr(inConverter.toInteger(access.get(path + "serNr", -1)));
            result.setData(inConverter.toString(access.get(path + "data", -1)));
            return result;
        }

        @Override
        public void initializeModelAccess() throws IOException {
            ModelAccess access = getModelAccess();
            access.useNotifications(false);
        }

        @Override
        public Class<? extends Object> getSourceType() {
            return Object.class;
        }

        @Override
        public Class<? extends RoutingConnOut> getTargetType() {
            return RoutingConnOut.class;
        }

    }

    private class RoutingConnOutReceptionCallback implements ReceptionCallback<RoutingConnOut> {

        {
            // initialize Transport if needed
            Starter.getSetup();
        }

        @Override
        public void received(RoutingConnOut data) {
            MetricsProvider.increaseCounterBy(serviceSent, 1.0);
            Transport.send(c -> c.asyncSend("data_myRoutingConnector_RoutingConnOut_RoutingTestApp" + appInstId, data),
                "myRoutingConnector", "processRoutingConnOut_RoutingProcessor-in-0");
        }

        @Override
        public Class<RoutingConnOut> getType() {
            return RoutingConnOut.class;
        }

    }

    private MultiConnectorServiceWrapper handleRoutingCommand(RoutingCommand data) {
        if (null != routingCommandHandler) {
            String newCls = routingCommandHandler.getNewConnectorClass(data);
            if (null != newCls && newCls.length() > 0) {
                ConnectorParameter param = createConnectorParameter();
                try {
                    // as experiment, simple form, no switching strategy for now
                    YamlArtifact art = YamlArtifact.readFromYamlSafe(ResourceLoader.getResourceAsStream("deployment.yml"
                        ));
                    YamlService serviceData = art.getServiceSafe("myRoutingConnector");
                    MultiConnectorServiceWrapper oldService = service;
                    MultiConnectorServiceWrapper newService = new MultiConnectorServiceWrapper(serviceData, () -> param);
                    Connector<Object, Object, RoutingConnOut, RoutingConnIn> conn0 = ConnectorFactory.createConnector(
                        "newCls", () -> param, createConnectorAdapter(()->service.getInPath(""), ()->service.getOutPath(
                        "")));
                    conn0.setInstanceIdentification("myRoutingConnector");
                    conn0.enablePolling(false);
                    newService.addConnector(conn0);
                    newService.setReceptionCallback(new RoutingConnOutReceptionCallback());
                    if (!newService.isEmpty()) {
                        newService.setState(ServiceState.STARTING);
                        service = newService;
                        oldService.setState(ServiceState.STOPPING);
                        Starter.mapService(service);
                    }
                } catch (ExecutionException e) {
                    System.out.println("Cannot switch connector: " + e.getMessage());
                }
            }
            routingCommandHandler.received(data, service.getEventHandlingConnector(RoutingConnIn.class));
        }
        return service;
    }

}
