package iip.nodes;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingTestData;
import iip.interfaces.MyRoutingSourceInterface;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'myRoutingSource'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.myRoutingSource", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class MyRoutingSource extends SpringAsyncServiceBase {

    @Value("${iip.service.myRoutingSource:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private MyRoutingSourceInterface service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * Creates an instance.
     */
    public MyRoutingSource() {
        service = AbstractService.createInstance("de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.SourceImp"
            + "l", MyRoutingSourceInterface.class, "myRoutingSource", "deployment.yml");
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Called when data arrived that shall be processed (asynchronously).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_myRoutingSource() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.processRoutingCommand(data));
        };
    }

    /**
     * Creates data to be ingested.
     *
     * @return the data supplier functor
     */
    @Bean
    public Supplier<RoutingTestData> createRoutingTestData_myRoutingSource() {
        return () -> {
            MetricsProvider.increaseCounterBy(serviceSent, 1.0);
            return service.produceRoutingTestData();
        };
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service myRoutingSource: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("myRoutingSource", sId, "RoutingTestApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("myRoutingSource", sId, "RoutingTestApp", iId);
            processingTime = metrics.createServiceProcessingTimer("myRoutingSource", sId, "RoutingTestApp", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
            createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + appInstId,
                processRoutingCommand_myRoutingSource(), RoutingCommand.class, 
                "processRoutingCommand_myRoutingSource-in-0");
        }
    }

}
