/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;
import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingConnOut;
import iip.datatypes.RoutingTestData;
import iip.interfaces.RoutingProcessorInterface;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.RoutingProcessor"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class RoutingProcessor
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.RoutingProcessor:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private RoutingProcessorInterface service = (RoutingProcessorInterface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ProcessorImpl", RoutingProcessorInterface.class, (String)"RoutingProcessor", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = RoutingProcessor.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Consumer<RoutingTestData> processRoutingTestData_RoutingProcessor() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRoutingTestData(data));
        };
    }

    @Bean
    public Consumer<RoutingConnOut> processRoutingConnOut_RoutingProcessor() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRoutingConnOut(data));
        };
    }

    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_RoutingProcessor() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRoutingCommand(data));
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(this.getClass()).info("Initializing service RoutingProcessor: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("RoutingProcessor", sId, "RoutingTestApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("RoutingProcessor", sId, "RoutingTestApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("RoutingProcessor", sId, "RoutingTestApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.service.attachRoutingTestDataIngestor(data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                SerializerMessageConverter.serializeAndSend((StreamBridge)this.streamBridge, (String)"transformRoutingTestDataRoutingTestData_ParallelRoutingProcessor3-in-0", (Object)data);
            });
            this.service.attachRoutingTestDataIngestor(data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                Transport.send(c -> c.asyncSend("data_RoutingProcessor_RoutingTestData_RoutingTestApp" + this.appInstId, data), (String)"RoutingProcessor", (String[])new String[]{"processRoutingTestData_ParallelRoutingProcessor1-in-0", "processRoutingTestData_ParallelRoutingProcessor2-in-0"});
            });
            this.createReceptionCallback("data_myRoutingConnector_RoutingConnOut_RoutingTestApp" + this.appInstId, this.processRoutingConnOut_RoutingProcessor(), RoutingConnOut.class, "processRoutingConnOut_RoutingProcessor-in-0");
            this.createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + this.appInstId, this.processRoutingCommand_RoutingProcessor(), RoutingCommand.class, "processRoutingCommand_RoutingProcessor-in-0");
        }
    }
}

