/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.DataMapper;
import de.iip_ecosphere.platform.services.environment.ProcessSpec;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import iip.Starter;
import iip.datatypes.KRec13Anon;
import iip.datatypes.KRec13Impl;
import iip.serializers.AvaMqttOutputImplSerializer;
import iip.serializers.AvaMqttOutputSerializer;
import iip.serializers.KRec13AnonImplSerializer;
import iip.serializers.KRec13AnonSerializer;
import iip.serializers.KRec13ImplSerializer;
import iip.serializers.KRec13RefinedImplSerializer;
import iip.serializers.KRec13RefinedSerializer;
import iip.serializers.KRec13Serializer;
import iip.serializers.MipMqttInputImplSerializer;
import iip.serializers.MipMqttInputSerializer;
import iip.serializers.MipMqttOutputImplSerializer;
import iip.serializers.MipMqttOutputSerializer;
import iip.serializers.SubmodelElementListImplSerializer;
import iip.serializers.SubmodelElementListSerializer;
import iip.serializers.TurnstilePlcOutputImplSerializer;
import iip.serializers.TurnstilePlcOutputSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hamcrest.core.IsAnything;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.binder.test.OutputDestination;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={Starter.class})
@ImportAutoConfiguration(value={TestChannelBinderConfiguration.class})
@TestPropertySource(properties={"spring.cloud.function.definition=processKRec13_Pseudonymizer", "spring.cloud.stream.source=data_createKRec13_SimpleKodexSource_KodexMeshApp;data_processKRec13Anon_Pseudonymizer_KodexMeshApp", "iip.service.KodexPythonService=false", "iip.service.KodexReceiver=false", "iip.service.Pseudonymizer=true", "iip.service.SimpleKodexSource=false"})
@RunWith(value=SpringRunner.class)
public class KodexPseudonymizerTest
extends SpringAsyncServiceBase {
    private TestMatcher matcher = new TestMatcher();
    private Map<Class<?>, Integer> received = new HashMap();
    private static String[] cmdArgs = new String[0];

    public KodexPseudonymizerTest() {
        SerializerRegistry.registerSerializer(AvaMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(AvaMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(KRec13AnonImplSerializer.class);
        SerializerRegistry.registerSerializer(KRec13AnonSerializer.class);
        SerializerRegistry.registerSerializer(KRec13ImplSerializer.class);
        SerializerRegistry.registerSerializer(KRec13RefinedImplSerializer.class);
        SerializerRegistry.registerSerializer(KRec13RefinedSerializer.class);
        SerializerRegistry.registerSerializer(KRec13Serializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListImplSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListSerializer.class);
        SerializerRegistry.registerSerializer(TurnstilePlcOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(TurnstilePlcOutputSerializer.class);
    }

    public void testService(InputStream in) throws IOException {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(TestChannelBinderConfiguration.getCompleteConfiguration((Class[])new Class[0])).web(WebApplicationType.NONE).run(new String[0]);){
            InputDestination source = (InputDestination)context.getBean(InputDestination.class);
            OutputDestination target = (OutputDestination)context.getBean(OutputDestination.class);
            Starter.getSetup();
            DataMapper.BaseMappingConsumer consumer = new DataMapper.BaseMappingConsumer(DataUnit.class, this.getInitialPeriod());
            consumer.addHandler(KRec13Impl.class, d -> {
                Transport.send(c -> c.asyncSend("createKRec13_SimpleKodexSource", d), (String)"SimpleKodexSource", (String[])new String[]{"createKRec13_SimpleKodexSource-in-0"});
                Transport.send(c -> c.asyncSend("data_SimpleKodexSource_KRec13_KodexMeshApp", d), (String)"SimpleKodexSource", (String[])new String[]{"createKRec13_SimpleKodexSource-in-0"});
            });
            this.matcher.addPredicate(KRec13Anon.class, this.getAssertPredicateKRec13Anon());
            DataMapper.mapJsonData((InputStream)in, DataUnit.class, (Consumer)consumer);
            TimeUtils.sleep((int)3000);
            context.close();
            this.detach();
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Test done. Cooling down for 1s");
            TimeUtils.sleep((int)1000);
        }
    }

    @AfterClass
    public static void after() {
        System.exit(0);
    }

    public void testService() throws IOException {
        InputStream in;
        try {
            String fileName = System.getProperty("iip.test.dataFile", "../../src/test/resources/testData-Pseudonymizer.json");
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Opening {}", (Object)fileName);
            in = new FileInputStream(fileName);
        }
        catch (IOException e) {
            in = ResourceLoader.getResourceAsStream((String)"testData-Pseudonymizer.json", (ResourceResolver[])new ResourceResolver[0]);
        }
        if (null != in) {
            this.testService(in);
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("No test data found. Skipping test.");
        }
    }

    private void incrementReceived(Class<?> type) {
        if (this.received.containsKey(type)) {
            this.received.put(type, this.received.get(type) + 1);
        } else {
            this.received.put(type, 1);
        }
    }

    protected Predicate<KRec13Anon> getAssertPredicateKRec13Anon() {
        return d -> true;
    }

    protected Predicate<Map<Class<?>, Integer>> createReceivedCounterAssertPredicate() {
        return m -> true;
    }

    protected void printReceivedData(Object data) {
        System.out.println(data);
    }

    protected int getInitialPeriod() {
        return 500;
    }

    @Test
    public void testPseudonymizerService() throws IOException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        this.testService();
        Assert.assertTrue((String)"Received counters not as expected", (boolean)this.createReceivedCounterAssertPredicate().test(Collections.unmodifiableMap(this.received)));
        Service svc = Starter.getMappedService((String)"Pseudonymizer");
        if (null != svc) {
            try {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Service autostop (test): Pseudonymizer");
                svc.setState(ServiceState.STOPPING);
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Stopping service Pseudonymizer: {}", (Object)e.getMessage());
            }
        }
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    public static void main(String[] args) throws IOException {
        cmdArgs = args;
        Starter.setServiceAutostart((boolean)true);
        Starter.setOnServiceAutostartAttachShutdownHook((boolean)false);
        YamlService yaml = YamlArtifact.readFromYamlSafe((InputStream)ResourceLoader.getResourceAsStream((String)"deployment.yml", (ResourceResolver[])new ResourceResolver[0])).getServiceSafe("Pseudonymizer");
        File f = FileUtils.findFile((File)new File(".."), (String)"SimpleKodexTestingApp-0.1.0-SNAPSHOT-bin.jar");
        if (null != f && null != yaml.getProcess()) {
            Starter.extractProcessArtifacts((String)"Pseudonymizer", (ProcessSpec)yaml.getProcess(), (File)f, null);
        } else {
            LoggerFactory.getLogger(KodexPseudonymizerTest.class).info("Service artifact {} not found in {}", (Object)"SimpleKodexTestingApp-0.1.0-SNAPSHOT-bin.jar", (Object)"..");
        }
        JUnitCore junit = new JUnitCore();
        junit.addListener((RunListener)new TextListener(System.out));
        junit.run(new Class[]{KodexPseudonymizerTest.class});
    }

    private class TestMatcher
    extends IsAnything<Object> {
        private Map<Class<?>, Predicate<?>> predicates;

        public TestMatcher() {
            super("Pseudonymizer matcher");
            this.predicates = new HashMap();
        }

        private <T> void addPredicate(Class<T> cls, Predicate<T> pred) {
            this.predicates.put(cls, pred);
        }

        public boolean matches(Object obj) {
            return this.test(obj);
        }

        private <T> boolean test(T obj) {
            KodexPseudonymizerTest.this.incrementReceived(obj.getClass());
            KodexPseudonymizerTest.this.printReceivedData(obj);
            Predicate<?> pred = this.predicates.get(obj.getClass());
            return null == pred ? true : pred.test(obj);
        }
    }

    public static class DataUnit
    extends DataMapper.BaseDataUnit {
        private KRec13Impl kRec13;

        public KRec13Impl getKRec13() {
            return this.kRec13;
        }

        public void setKRec13(KRec13Impl kRec13) {
            this.kRec13 = kRec13;
        }

        public String toString() {
            return StringUtils.toStringShortStyle((Object)((Object)this));
        }
    }
}

