package iip.nodes;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.PostConstruct;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.PythonAsyncProcessService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;

import iip.datatypes.KRec13Anon;
import iip.datatypes.KRec13AnonImpl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'Kodex Python Service'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.KodexPythonService", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class KodexPythonService extends SpringAsyncServiceBase {

    @Value("${iip.service.KodexPythonService:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private PythonAsyncProcessService service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * In-data JSON type translator.
     */
    private static class KRec13AnonInputTranslator implements TypeTranslator<KRec13Anon, String> {

        @Override
        public KRec13Anon from(String data) throws IOException {
            return null;
        }

        @Override
        public String to(KRec13Anon source) throws IOException {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                return objectMapper.writeValueAsString(source);
            } catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }

    }

    /**
     * Out-data JSON type translator.
     */
    private static class KRec13AnonOutputTranslator implements TypeTranslator<String, KRec13Anon> {

        @Override
        public String from(KRec13Anon data) throws IOException {
            return null;
        }

        @Override
        public KRec13Anon to(String source) throws IOException {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonUtils.handleIipDataClasses(objectMapper);
                return objectMapper.readValue(source, KRec13AnonImpl.class);
            } catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }

    }

    /**
     * Creates an instance.
     */
    public KodexPythonService() {
        service = AbstractService.createInstance(
            "de.iip_ecosphere.platform.services.environment.PythonAsyncProcessService", PythonAsyncProcessService.
            class, "KodexPythonService", "deployment.yml");
        service.registerInputTypeTranslator(KRec13Anon.class, "KRec13Anon", new KRec13AnonInputTranslator());
        service.registerOutputTypeTranslator(KRec13Anon.class, "KRec13Anon", new KRec13AnonOutputTranslator());
        service.addParameterConfigurer(c -> {
            AbstractService.addConfigurer(c, "passThrough", Boolean.class, TypeTranslators.BOOLEAN, v -> {}, null, 
                "iip.app.sc1.passThrough");
            AbstractService.addConfigurer(c, "sParam", String.class, TypeTranslators.JSON_STRING, v -> {}, null);
        });
        HashMap<String, String> paramValues = new HashMap<>();
        ParameterConfigurer<?> cfg;
        cfg = service.getParameterConfigurer("passThrough");
        if (null != cfg) {
            cfg.addValue(paramValues, false);
        }
        cfg = service.getParameterConfigurer("sParam");
        if (null != cfg) {
            cfg.addValue(paramValues, "abc");
        }
        try {
            service.reconfigure(paramValues);
        } catch (ExecutionException e) {
            LoggerFactory.getLogger(getClass())
                .error("Configuring initial parameter: {}", e.getMessage());
        }
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Called when data arrived that shall be processed (synchronously).
     *
     * @return the data transformation functor
     */
    @Bean
    public Function<KRec13Anon, KRec13Anon> transformKRec13AnonKRec13Anon_KodexPythonService() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceSent, 1.0);
            return service.processSyncQuiet("KRec13Anon", data, "KRec13Anon");
        };
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service KodexPythonService: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("KodexPythonService", sId, "KodexMeshApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("KodexPythonService", sId, "KodexMeshApp", iId);
            processingTime = metrics.createServiceProcessingTimer("KodexPythonService", sId, "KodexMeshApp", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
        }
    }

}
