/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import iip.datatypes.KRec13;
import iip.interfaces.SimpleKodexDataSourceInterface;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.SimpleKodexSource"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class SimpleKodexDataSource
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.SimpleKodexSource:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private SimpleKodexDataSourceInterface service = (SimpleKodexDataSourceInterface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleSourceKodexImpl", SimpleKodexDataSourceInterface.class, (String)"SimpleKodexSource", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = SimpleKodexDataSource.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Supplier<KRec13> createKRec13_SimpleKodexSource() {
        return () -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
            return this.service.produceKRec13();
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Initializing service SimpleKodexSource: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("SimpleKodexSource", sId, "KodexMeshApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("SimpleKodexSource", sId, "KodexMeshApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("SimpleKodexSource", sId, "KodexMeshApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
        }
    }
}

