package iip.nodes;

import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.iip_ecosphere.platform.security.services.kodex.KodexService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;

import iip.datatypes.KRec13;
import iip.datatypes.KRec13Anon;
import iip.datatypes.KRec13AnonImpl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'Kodex Pseudonymizer'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.Pseudonymizer", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class KodexPseudonymizer extends SpringAsyncServiceBase {

    @Value("${iip.service.Pseudonymizer:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private KodexService<KRec13, KRec13Anon> serviceKRec13KRec13Anon;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * In-data JSON type translator.
     */
    private static class KRec13InputTranslator implements TypeTranslator<KRec13, String> {

        @Override
        public KRec13 from(String data) throws IOException {
            return null;
        }

        @Override
        public String to(KRec13 source) throws IOException {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                return objectMapper.writeValueAsString(source);
            } catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }

    }

    /**
     * Out-data JSON type translator.
     */
    private static class KRec13AnonOutputTranslator implements TypeTranslator<String, KRec13Anon> {

        @Override
        public String from(KRec13Anon data) throws IOException {
            return null;
        }

        @Override
        public KRec13Anon to(String source) throws IOException {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonUtils.handleIipDataClasses(objectMapper);
                return objectMapper.readValue(source, KRec13AnonImpl.class);
            } catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }

    }

    /**
     * Creates an instance.
     */
    public KodexPseudonymizer() {
        YamlArtifact art = YamlArtifact.readFromYamlSafe(ResourceLoader.getResourceAsStream("deployment.yml"));
        YamlService serviceData = art.getServiceSafe("Pseudonymizer");
        serviceKRec13KRec13Anon = new KodexService(new KRec13InputTranslator(), new KRec13AnonOutputTranslator(), null,
            serviceData);
    }

    /**
     * Called when data arrived that shall be processed (asynchronously).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<KRec13> processKRec13_Pseudonymizer() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> serviceKRec13KRec13Anon.processQuiet(data));
        };
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service Pseudonymizer: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(serviceKRec13KRec13Anon);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("Pseudonymizer", sId, "KodexMeshApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("Pseudonymizer", sId, "KodexMeshApp", iId);
            processingTime = metrics.createServiceProcessingTimer("Pseudonymizer", sId, "KodexMeshApp", iId);
            MonitoringService.setUp(serviceKRec13KRec13Anon, metrics);
            Starter.mapService(serviceKRec13KRec13Anon);
            serviceKRec13KRec13Anon.attachIngestor(KRec13AnonImpl.class, data -> {
                MetricsProvider.increaseCounterBy(serviceSent, 1.0);
                SerializerMessageConverter.serializeAndSend(streamBridge, 
                    "transformKRec13AnonKRec13Anon_KodexPythonService-in-0", data);
            });
            serviceKRec13KRec13Anon.attachIngestor(KRec13Anon.class, data -> {
                MetricsProvider.increaseCounterBy(serviceSent, 1.0);
                SerializerMessageConverter.serializeAndSend(streamBridge, 
                    "transformKRec13AnonKRec13Anon_KodexPythonService-in-0", data);
            });
        }
    }

}
