/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.security.services.kodex.KodexService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;
import iip.datatypes.KRec13;
import iip.datatypes.KRec13Anon;
import iip.datatypes.KRec13AnonImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.Pseudonymizer"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class KodexPseudonymizer
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.Pseudonymizer:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private KodexService<KRec13, KRec13Anon> serviceKRec13KRec13Anon;
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    public KodexPseudonymizer() {
        YamlArtifact art = YamlArtifact.readFromYamlSafe((InputStream)ResourceLoader.getResourceAsStream((String)"deployment.yml", (ResourceResolver[])new ResourceResolver[0]));
        YamlService serviceData = art.getServiceSafe("Pseudonymizer");
        this.serviceKRec13KRec13Anon = new KodexService((TypeTranslator)new KRec13InputTranslator(), (TypeTranslator)new KRec13AnonOutputTranslator(), null, serviceData);
    }

    @Bean
    public Consumer<KRec13> processKRec13_Pseudonymizer() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.serviceKRec13KRec13Anon.processQuiet(data));
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Initializing service Pseudonymizer: {}", (Object)this.activated);
            String sId = Starter.getServiceId(this.serviceKRec13KRec13Anon);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("Pseudonymizer", sId, "KodexMeshApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("Pseudonymizer", sId, "KodexMeshApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("Pseudonymizer", sId, "KodexMeshApp", iId);
            MonitoringService.setUp(this.serviceKRec13KRec13Anon, (MetricsProvider)this.metrics);
            Starter.mapService(this.serviceKRec13KRec13Anon);
            this.serviceKRec13KRec13Anon.attachIngestor(KRec13AnonImpl.class, data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                SerializerMessageConverter.serializeAndSend((StreamBridge)this.streamBridge, (String)"transformKRec13AnonKRec13Anon_KodexPythonService-in-0", (Object)data);
            });
            this.serviceKRec13KRec13Anon.attachIngestor(KRec13Anon.class, data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                SerializerMessageConverter.serializeAndSend((StreamBridge)this.streamBridge, (String)"transformKRec13AnonKRec13Anon_KodexPythonService-in-0", (Object)data);
            });
        }
    }

    private static class KRec13InputTranslator
    implements TypeTranslator<KRec13, String> {
        private KRec13InputTranslator() {
        }

        public KRec13 from(String data) throws IOException {
            return null;
        }

        public String to(KRec13 source) throws IOException {
            Json objectMapper = Json.createInstance4All();
            return objectMapper.writeValueAsString((Object)source);
        }
    }

    private static class KRec13AnonOutputTranslator
    implements TypeTranslator<String, KRec13Anon> {
        private KRec13AnonOutputTranslator() {
        }

        public String from(KRec13Anon data) throws IOException {
            return null;
        }

        public KRec13Anon to(String source) throws IOException {
            Json objectMapper = Json.createInstance4All();
            objectMapper.handleIipDataClasses();
            return (KRec13Anon)objectMapper.readValue(source, KRec13AnonImpl.class);
        }
    }
}

