package iip;

import java.util.List;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;

import iip.serializers.AvaMqttOutputImplSerializer;
import iip.serializers.AvaMqttOutputSerializer;
import iip.serializers.KRec13AnonImplSerializer;
import iip.serializers.KRec13AnonSerializer;
import iip.serializers.KRec13ImplSerializer;
import iip.serializers.KRec13RefinedImplSerializer;
import iip.serializers.KRec13RefinedSerializer;
import iip.serializers.KRec13Serializer;
import iip.serializers.MipMqttInputImplSerializer;
import iip.serializers.MipMqttInputSerializer;
import iip.serializers.MipMqttOutputImplSerializer;
import iip.serializers.MipMqttOutputSerializer;
import iip.serializers.SubmodelElementListImplSerializer;
import iip.serializers.SubmodelElementListSerializer;
import iip.serializers.TurnstilePlcOutputImplSerializer;
import iip.serializers.TurnstilePlcOutputSerializer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.messaging.converter.MessageConverter;

/**
 * Service artifact starter.
 * Generated by: EASy-Producer.
 */
@SpringBootApplication
@ComponentScan({"iip.nodes", "de.iip_ecosphere.platform.services.environment.spring", 
"de.iip_ecosphere.platform.transport.spring"})
public class Starter extends de.iip_ecosphere.platform.services.environment.spring.Starter {

    /**
     * Creates an instance.
     *
     * @param environment the Spring environment
     */
    @Autowired
    public Starter(Environment environment) {
        super(environment);
    }

    @Override
    protected List<Service> createServices(YamlArtifact artifact) {
        return null;
    }

    /**
     * Creates a custom message converter and binds it against "application/iip".
     *
     * @return the custom message converter
     */
    @Bean
    public MessageConverter customMessageConverter() {
        return new SerializerMessageConverter();
    }

    /**
     * Registers required, generated serializers.
     */
    public static void registerSerializers() {
        SerializerRegistry.registerSerializer(AvaMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(AvaMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(KRec13AnonImplSerializer.class);
        SerializerRegistry.registerSerializer(KRec13AnonSerializer.class);
        SerializerRegistry.registerSerializer(KRec13ImplSerializer.class);
        SerializerRegistry.registerSerializer(KRec13RefinedImplSerializer.class);
        SerializerRegistry.registerSerializer(KRec13RefinedSerializer.class);
        SerializerRegistry.registerSerializer(KRec13Serializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListImplSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListSerializer.class);
        SerializerRegistry.registerSerializer(TurnstilePlcOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(TurnstilePlcOutputSerializer.class);
    }

    /**
     * Starts the service chain.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        registerSerializers();
        main(iip.Starter.class, args);
    }

}
