/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.transport.Transport;
import iip.datatypes.Feedback;
import iip.datatypes.Rec1;
import iip.interfaces.SimpleDataSourceInterface;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConditionalOnProperty(value={"iip.service.SimpleSource"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class SimpleDataSource
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.SimpleSource:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private SimpleDataSourceInterface service = (SimpleDataSourceInterface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleSourceImpl", SimpleDataSourceInterface.class, (String)"SimpleSource", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    public SimpleDataSource() {
        HashMap paramValues = new HashMap();
        ParameterConfigurer cfg = this.service.getParameterConfigurer("camIP");
        if (null != cfg) {
            cfg.addValue(paramValues, (Object)"127.0.0.1");
        }
        if (null != (cfg = this.service.getParameterConfigurer("camPort"))) {
            cfg.addValue(paramValues, (Object)-1);
        }
        try {
            this.service.reconfigure(paramValues);
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Configuring initial parameter: {}", (Object)e.getMessage());
        }
        this.appInstId = SimpleDataSource.getAppInstIdSuffix((Service)this.service, (String)"_");
    }

    @Bean
    public Consumer<Feedback> processFeedback_SimpleSource() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processFeedback(data));
        };
    }

    @Bean
    public Supplier<Flux<Rec1>> createRec1_SimpleSource() {
        return () -> Flux.from(emitter -> {});
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(this.getClass()).info("Initializing service SimpleSource: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("SimpleSource", sId, "SimpleMeshApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("SimpleSource", sId, "SimpleMeshApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("SimpleSource", sId, "SimpleMeshApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.service.attachRec1Ingestor(data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                Transport.send(c -> c.asyncSend("data_SimpleSource_Rec1_SimpleMeshApp" + this.appInstId, data), (String)"SimpleSource", (String[])new String[]{"receiveRec1_SimpleReceiver-in-0"});
            });
            this.createReceptionCallback("data_SimpleReceiver_Feedback_SimpleMeshApp" + this.appInstId, this.processFeedback_SimpleSource(), Feedback.class, "processFeedback_SimpleSource-in-0");
        }
    }
}

