package iip.nodes;

import java.util.function.Function;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;

import iip.datatypes.Rec13;
import iip.interfaces.SimpleDataTransformer3Interface;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'Simple Data Transformer3'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.SimpleTransformer3", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class SimpleDataTransformer3 extends SpringAsyncServiceBase {

    @Value("${iip.service.SimpleTransformer3:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private SimpleDataTransformer3Interface service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * Creates an instance.
     */
    public SimpleDataTransformer3() {
        service = AbstractService.createInstance("de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleTransformer3Imp"
            + "l", SimpleDataTransformer3Interface.class, "SimpleTransformer3", "deployment.yml");
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Called when data arrived that shall be processed (synchronously).
     *
     * @return the data transformation functor
     */
    @Bean
    public Function<Rec13, Rec13> transformRec13Rec13_SimpleTransformer3() {
        return data -> service.transformRec13(data);
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service SimpleTransformer3: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("SimpleTransformer3", sId, "SimpleMeshApp3", iId);
            serviceReceived = metrics.createServiceReceivedCounter("SimpleTransformer3", sId, "SimpleMeshApp3", iId);
            processingTime = metrics.createServiceProcessingTimer("SimpleTransformer3", sId, "SimpleMeshApp3", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
        }
    }

}
