/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import iip.datatypes.Rec13;
import iip.interfaces.SimpleDataReceiver3Interface;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.SimpleReceiver3"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class SimpleDataReceiver3
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.SimpleReceiver3:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private SimpleDataReceiver3Interface service = (SimpleDataReceiver3Interface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleReceiver3Impl", SimpleDataReceiver3Interface.class, (String)"SimpleReceiver3", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = SimpleDataReceiver3.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Consumer<Rec13> receiveRec13_SimpleReceiver3() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRec13(data));
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(this.getClass()).info("Initializing service SimpleReceiver3: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("SimpleReceiver3", sId, "SimpleMeshApp3", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("SimpleReceiver3", sId, "SimpleMeshApp3", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("SimpleReceiver3", sId, "SimpleMeshApp3", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
        }
    }
}

