/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.maven;

import java.util.ArrayList;
import java.util.List;

public class DummyApp {
    public static final String PROPERTY_ARGS = "iip.springStart.args";
    public static final String PARAM_PREFIX = "--";
    public static final String PARAM_VALUE_SEP = "=";

    public static String getArg(String[] args, String argName, String dflt) {
        String result = dflt;
        String prefix = PARAM_PREFIX + argName + PARAM_VALUE_SEP;
        for (int a = 0; a < args.length; ++a) {
            String arg = args[a];
            if (!arg.startsWith(prefix)) continue;
            result = arg.substring(prefix.length());
            break;
        }
        return result;
    }

    public static int getIntArg(String[] args, String argName, int dflt) {
        int result;
        try {
            result = Integer.parseInt(DummyApp.getArg(args, argName, String.valueOf(dflt)));
        }
        catch (NumberFormatException e) {
            result = dflt;
        }
        return result;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... elements) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : elements) {
            result.add(e);
        }
        return result;
    }

    public static String[] toArgs(String args) {
        String tmp;
        if (args == null) {
            args = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean inQuote = false;
        int lastPos = 0;
        for (int i = 0; i < args.length(); ++i) {
            String tmp2;
            char c = args.charAt(i);
            if ('\'' == c || '\"' == c) {
                inQuote = !inQuote;
                continue;
            }
            if (' ' != c || inQuote) continue;
            if (lastPos != i && (tmp2 = args.substring(lastPos, i).trim()).length() > 0) {
                result.add(tmp2);
            }
            lastPos = i + 1;
        }
        if (lastPos < args.length() && (tmp = args.substring(lastPos, args.length()).trim()).length() > 0) {
            result.add(tmp);
        }
        return result.toArray(new String[0]);
    }

    @SafeVarargs
    public static <T> List<T> addAll(List<T> list, T ... elements) {
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    public static void main(String[] args) {
        String sysArgs = System.getProperty(PROPERTY_ARGS, null);
        if (null != sysArgs) {
            if (sysArgs.startsWith("\"") && sysArgs.endsWith("\"") && sysArgs.length() > 1) {
                sysArgs = sysArgs.substring(1, sysArgs.length() - 1);
            }
            System.out.println("iip.springStart.args=" + sysArgs);
            List<String> tmp = DummyApp.toList(args);
            DummyApp.addAll(tmp, DummyApp.toArgs(sysArgs));
            System.out.println(tmp);
        }
        int start = DummyApp.getIntArg(args, "start", 1);
        int max = DummyApp.getIntArg(args, "max", 10);
        int modulo = DummyApp.getIntArg(args, "modulo", 5);
        for (int i = start; i <= max; ++i) {
            System.out.println("STEP: " + i);
            if (i % modulo == 0) {
                System.err.println("DONE: " + modulo);
            }
            DummyApp.sleep(500);
        }
    }
}

