/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.configuration.maven.ProcessUnit;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.maven.DummyApp;

public class ProcessUnitTest {
    @Test
    public void testTerminatingMatchingProcess() throws IOException {
        System.out.println("Testing process with successful regex terminating on match:");
        Pattern p = Pattern.compile("^DONE: \\d+$");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("p", null).addArgument((Object)"java").addArgument((Object)DummyApp.class.getName()).setHome(new File("./target/test-classes")).setNotifyListenerByLogMatch(true).addCheckRegEx(p).build();
        TimeUtils.sleep((int)500);
        Assert.assertTrue((boolean)unit.isRunning());
        TimeUtils.sleep((int)3000);
        Assert.assertTrue((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"p", (Object)unit.getDescription());
        Assert.assertTrue((boolean)unit.hasCheckRegEx());
    }

    @Test
    public void testTerminatingNonMatchingProcess() throws IOException {
        System.out.println("Testing process with failing regex terminating itself when over:");
        Pattern p = Pattern.compile("^XYZ: \\d+$");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("p2", null).addArgument((Object)"java").addArgument((Object)DummyApp.class.getName()).setHome(new File("./target/test-classes")).setNotifyListenerByLogMatch(false).addCheckRegEx(p).setRegExConjunction(false).build();
        TimeUtils.sleep((int)500);
        Assert.assertTrue((boolean)unit.isRunning());
        TimeUtils.sleep((int)5000);
        Assert.assertFalse((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"p2", (Object)unit.getDescription());
        Assert.assertTrue((boolean)unit.hasCheckRegEx());
        Assert.assertEquals((long)0L, (long)unit.getExitValue());
    }

    @Test
    public void testTerminatedProcess() throws IOException {
        System.out.println("Testing process being explicitly terminated:");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("", null).addArgument((Object)"java").addArgument((Object)DummyApp.class.getName()).setHome(new File("./target/test-classes")).build();
        TimeUtils.sleep((int)500);
        Assert.assertTrue((boolean)unit.isRunning());
        unit.stop();
        TimeUtils.sleep((int)1000);
        Assert.assertFalse((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"", (Object)unit.getDescription());
        Assert.assertFalse((boolean)unit.hasCheckRegEx());
    }

    @Test
    public void testProcessMultiPattern() throws IOException {
        Pattern p = Pattern.compile("^DONE: \\d+$");
        AtomicInteger terminationCount = new AtomicInteger();
        System.out.println("Testing process with timeout and multi patterns:");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("p", null).addArgument((Object)"java").addArgument((Object)DummyApp.class.getName()).addArgument((Object)"--modulo=2").setHome(new File("./target/test-classes")).setNotifyListenerByLogMatch(true).addCheckRegEx(p).setListener(r -> terminationCount.incrementAndGet() > 2).build();
        TimeUtils.sleep((int)500);
        Assert.assertTrue((boolean)unit.isRunning());
        TimeUtils.sleep((int)3500);
        Assert.assertTrue((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"p", (Object)unit.getDescription());
        Assert.assertTrue((boolean)unit.hasCheckRegEx());
        Assert.assertEquals((long)3L, (long)terminationCount.get());
    }

    @Test
    public void testTimeoutProcess() throws IOException {
        AtomicInteger terminationCount = new AtomicInteger();
        System.out.println("Testing process with timeout:");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("p", null).addArgument((Object)"java").addArgument((Object)DummyApp.class.getName()).setHome(new File("./target/test-classes")).setTimeout(1000L).setListener(r -> {
            terminationCount.incrementAndGet();
            return true;
        }).build();
        TimeUtils.sleep((int)500);
        Assert.assertTrue((boolean)unit.isRunning());
        TimeUtils.sleep((int)1000);
        Assert.assertFalse((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"p", (Object)unit.getDescription());
        Assert.assertFalse((boolean)unit.hasCheckRegEx());
        Assert.assertEquals((long)1L, (long)terminationCount.get());
    }

    @Test
    public void testShellProcess() throws IOException {
        System.out.println("Testing process in script, terminated:");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("", null).addShellScriptCommand("test").addArgument((Object)"--start=2").setHome(new File("./target/test-classes")).build();
        TimeUtils.sleep((int)1500);
        Assert.assertTrue((boolean)unit.isRunning());
        unit.stop();
        TimeUtils.sleep((int)1000);
        Assert.assertFalse((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"", (Object)unit.getDescription());
        Assert.assertFalse((boolean)unit.hasCheckRegEx());
    }

    @Test
    public void testMvnProcess() throws IOException {
        System.out.println("Testing mvn process, terminated:");
        Pattern p = Pattern.compile("^.*Scanning for projects.*$");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("mvn", null).addMavenCommand().addArgument((Object)"-P").addArgument((Object)"App").addArgument((Object)"validate").addArgument((Object)"-Diip.springStart.args=\"--iip.test.stop=1000 --iip.test.brokerPort=1234\"").addCheckRegEx(p).logTo(null).build();
        Assert.assertTrue((boolean)unit.isRunning());
        unit.waitFor();
        Assert.assertTrue((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"mvn", (Object)unit.getDescription());
        Assert.assertTrue((boolean)unit.hasCheckRegEx());
    }

    @Test
    public void testMvnProcess2() throws IOException {
        System.out.println("Testing mvn process, terminated:");
        Pattern p = Pattern.compile("^.*gen.*$");
        ProcessUnit unit = new ProcessUnit.ProcessUnitBuilder("mvn", null).addMavenCommand().addArgument(true, (Object)"exec:java@app").addArgument(false, (Object)"xyz").addArgument((Object)"-Diip.springStart.args=\"--iip.test.stop=1000 --iip.test.brokerPort=1234\"").addCheckRegEx(p).logTo(null).build();
        Assert.assertTrue((boolean)unit.isRunning());
        unit.waitFor();
        Assert.assertTrue((boolean)unit.getLogMatches());
        Assert.assertFalse((boolean)unit.isRunning());
        Assert.assertEquals((Object)"mvn", (Object)unit.getDescription());
        Assert.assertTrue((boolean)unit.hasCheckRegEx());
    }
}

