/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.configuration.maven.ProcessUnit;
import de.iip_ecosphere.platform.configuration.maven.TestProcessSpec;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.collector.Collector;
import de.iip_ecosphere.platform.support.iip_aas.config.RuntimeSetup;
import de.iip_ecosphere.platform.tools.maven.python.AbstractLoggingMojo;
import de.iip_ecosphere.platform.tools.maven.python.FilesetUtils;
import de.iip_ecosphere.platform.tools.maven.python.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="testApp", defaultPhase=LifecyclePhase.PACKAGE)
public class TestAppMojo
extends AbstractLoggingMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session.offline}")
    private boolean offline;
    @Parameter(defaultValue="${session.request}")
    private MavenExecutionRequest request;
    @Parameter(property="configuration.testApp.testCmd", required=false, defaultValue="")
    private String testCmd;
    @Parameter(property="configuration.testApp.testCmdAsScript", required=false, defaultValue="false")
    private boolean testCmdAsScript;
    @Parameter(property="configuration.testApp.appId", required=false, defaultValue="app")
    private String appId;
    @Parameter(property="configuration.testApp.appProfile", required=false, defaultValue="App")
    private String appProfile;
    @Parameter(property="configuration.testApp.appPom", required=false)
    private File appPom;
    @Parameter(property="configuration.testApp.appOffline", required=false, defaultValue="true")
    private boolean appOffline;
    @Parameter(property="configuration.testApp.appArgs", required=false)
    private List<String> appArgs;
    @Parameter(property="configuration.testApp.mvnArgs", required=false)
    private List<String> mvnArgs;
    @Parameter(property="configuration.testApp.mvnPluginArgs", required=false)
    private List<String> mvnPluginArgs;
    @Parameter(property="configuration.testApp.logFile", required=false, defaultValue="")
    private File logFile;
    @Parameter(property="configuration.testApp.logRegExprs", required=false)
    private List<String> logRegExprs;
    @Parameter(property="configuration.testApp.logRegExConjunction", required=false, defaultValue="true")
    private boolean logRegExConjunction;
    @Parameter(property="configuration.testApp.logRegExMatchCount", required=false, defaultValue="1")
    private int logRegExMatchCount;
    @Parameter(property="configuration.testApp.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="configuration.testApp.brokerDir", required=false, defaultValue="")
    private String brokerDir;
    @Parameter(property="configuration.testApp.brokerPort", required=false, defaultValue="-1")
    private int brokerPort;
    @Parameter(property="configuration.testApp.brokerWaitTime", required=true, defaultValue="3000")
    private int brokerWaitTime;
    @Parameter(property="configuration.testApp.testTime", required=true, defaultValue="120000")
    private int testTime;
    private int testTimePlatform;
    @Parameter(property="configuration.testApp.platformStartTimeout", required=true, defaultValue="120000")
    private int platformStartTimeout;
    @Parameter(property="configuration.outputDirectory", required=true, defaultValue="gen")
    private String outputDirectory;
    @Parameter(property="configuration.testApp.platformDir", required=false, defaultValue="")
    private File platformDir;
    @Parameter(property="configuration.testApp.startPlatform", required=false, defaultValue="true")
    private boolean startPlatform;
    @Parameter(property="configuration.testApp.startEcsRuntime", required=false, defaultValue="false")
    private boolean startEcsRuntime;
    @Parameter(property="configuration.testApp.startServiceMgr", required=false, defaultValue="false")
    private boolean startServiceManager;
    @Parameter(property="configuration.testApp.startEcsServiceMgr", required=false, defaultValue="true")
    private boolean startEcsServiceManager;
    @Parameter(property="configuration.testApp.deploymentPlan", required=false)
    private File deploymentPlan;
    @Parameter(property="configuration.testApp.deploymentResource", required=false, defaultValue="local")
    private String deploymentResource;
    @Parameter(property="configuration.testApp.mgtUiSetupFileTemplate", required=false, defaultValue="")
    private File mgtUiSetupFileTemplate;
    @Parameter(property="configuration.testApp.mgtUiSetupFile", required=false, defaultValue="")
    private File mgtUiSetupFile;
    @Parameter(property="configuration.testApp.befores", required=false)
    private List<TestProcessSpec> befores;
    @Parameter(property="configuration.ngTest.nodejs", required=false, defaultValue="")
    private String nodejs;
    @Parameter(required=false)
    private FileSet artifacts;
    private List<ProcessUnit> units = new ArrayList<ProcessUnit>();
    private long testStart;

    private ProcessUnit buildAndRegister(ProcessUnit.ProcessUnitBuilder builder) throws MojoExecutionException {
        ProcessUnit result = builder.build4Mvn();
        this.units.add(0, result);
        return result;
    }

    private ProcessUnit.ProcessUnitBuilder createPlatformBuilder(String description, File home, String scriptName, ProcessUnit.TerminationListener listener, String ... args) {
        Pattern p = Pattern.compile("^.*Startup completed..*$");
        ProcessUnit.ProcessUnitBuilder builder = new ProcessUnit.ProcessUnitBuilder(description, (Logger)this).setHome(home).addShellScriptCommand(scriptName).addArguments(args).addCheckRegEx(p).setListener(listener).setTimeout(this.testTimePlatform).setNotifyListenerByLogMatch(true);
        return builder;
    }

    private ProcessUnit startPlatformService(String description, File home, String scriptName, String ... args) throws MojoExecutionException {
        AtomicBoolean started = new AtomicBoolean();
        ProcessUnit pu = this.buildAndRegister(this.createPlatformBuilder(description, home, scriptName, r -> {
            if (ProcessUnit.TerminationReason.MATCH_COMPLETE == r) {
                started.set(true);
            }
            return false;
        }, args));
        TimeUtils.waitFor(() -> !started.get(), (int)this.platformStartTimeout, (int)300);
        if (!started.get()) {
            throw new MojoExecutionException("Start of " + pu.getDescription() + " did not emit expected regEx");
        }
        return pu;
    }

    private RuntimeSetup startPlatform(int brokerPort) throws MojoExecutionException {
        RuntimeSetup result = null;
        if (TestAppMojo.isValidFile(this.platformDir)) {
            FilesetUtils.streamFiles((FileSet)this.artifacts, (boolean)false).forEach(f -> {
                File target = new File(new File(this.platformDir, "artifacts"), f.getName());
                try {
                    this.getLog().info((CharSequence)("Copying artifact " + String.valueOf(f) + " to " + String.valueOf(target)));
                    Files.copy(f.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Cannot copy artifact " + String.valueOf(f) + ":" + e.getMessage()));
                }
            });
            File rtSetup = RuntimeSetup.getFile();
            FileUtils.deleteQuietly((File)rtSetup);
            File local = new File(this.platformDir, "oktoflow-local.yml");
            try (PrintStream setupLocal = new PrintStream(local);){
                setupLocal.println("transport: ");
                setupLocal.println("  port: " + brokerPort);
                setupLocal.println("service-mgr: ");
                setupLocal.println("  transport: ");
                setupLocal.println("    port: " + brokerPort);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot write " + String.valueOf(local)));
            }
            String iipId = "--iip.id=" + this.deploymentResource;
            if (this.startPlatform) {
                this.startPlatformService("platform central services", this.platformDir, "platform", new String[0]);
            }
            if (this.startEcsServiceManager) {
                this.startPlatformService("ECS-Runtime & service manager", this.platformDir, "ecsServiceMgr", iipId);
            } else {
                if (this.startEcsRuntime) {
                    this.startPlatformService("ECS-Runtime", this.platformDir, "ecs", iipId);
                }
                if (this.startServiceManager) {
                    int iipPort = NetUtils.getEphemeralPort();
                    this.startPlatformService("service manager", this.platformDir, "serviceMgr", "--iip.port=" + iipPort, iipId);
                }
            }
            if (TimeUtils.waitFor(() -> !rtSetup.exists(), (int)2000, (int)300)) {
                result = RuntimeSetup.load();
            }
        }
        return result;
    }

    private static boolean isValidFile(File file) {
        return null != file && file.exists();
    }

    private void deployApp(boolean deploy, String id) throws MojoExecutionException {
        if (TestAppMojo.isValidFile(this.platformDir) && TestAppMojo.isValidFile(this.deploymentPlan)) {
            Object name;
            Object object = name = deploy ? "deploy app" : "undeploy app";
            if (id.length() > 0) {
                name = (String)name + " " + id;
            }
            ProcessUnit.ProcessUnitBuilder pub = new ProcessUnit.ProcessUnitBuilder((String)name, (Logger)this).setHome(this.platformDir).addShellScriptCommand("cli").addArgument(deploy ? "deploy" : "undeploy").addArgument(this.deploymentPlan.getAbsolutePath());
            if (!deploy) {
                pub.addArgument(id).setTimeout(20000L);
            }
            ProcessUnit pu = pub.build4Mvn();
            int status = pu.waitFor();
            if (deploy && ProcessUnit.isFailed(status)) {
                throw new MojoExecutionException(pu.getDescription() + " terminated with status: " + status);
            }
        }
    }

    private void startProcesses() throws MojoExecutionException {
        if (this.befores != null) {
            for (TestProcessSpec p : this.befores) {
                int status;
                p.allocatePorts(this.project, this.getLog());
                ProcessUnit.ProcessUnitBuilder builder = new ProcessUnit.ProcessUnitBuilder(p.getDescription(), (Logger)this);
                builder.addArgumentOrScriptCommand(p.isCmdAsScript(), p.getCmd());
                if (p.isErrToIn()) {
                    builder.redirectErr2In();
                }
                if (null != p.getHome()) {
                    builder.setHome(p.getHome());
                }
                builder.addArguments(p.extrapolateArgs());
                ProcessUnit pu = this.buildAndRegister(builder);
                if (!p.isWaitFor() || (status = pu.waitFor()) == Integer.MIN_VALUE || status == 0) continue;
                throw new MojoExecutionException(pu.getDescription() + " terminated with status: " + status);
            }
        }
    }

    private synchronized boolean stopProcessUnits() {
        boolean failed = false;
        for (ProcessUnit u : this.units) {
            int status = u.stop();
            if (status == Integer.MIN_VALUE || status == 0) continue;
            this.getLog().error((CharSequence)(u.getDescription() + " terminated with status: " + status));
            failed = true;
        }
        this.units.clear();
        if (TestAppMojo.isValidFile(this.platformDir)) {
            FileUtils.deleteQuietly((File)new File(this.platformDir, "oktoflow-local.yml"));
        }
        FileUtils.deleteQuietly((File)this.mgtUiSetupFile);
        return failed;
    }

    private boolean handleTermination(ProcessUnit.TerminationReason reason, AtomicBoolean terminated, AtomicInteger testTerminatedCount) {
        boolean stop = true;
        switch (reason) {
            case TIMEOUT: {
                this.getLog().info((CharSequence)"Test timeout");
                break;
            }
            case MATCH_COMPLETE: {
                int tCount = testTerminatedCount.incrementAndGet();
                if (tCount >= Math.max(this.logRegExMatchCount, 1)) {
                    this.getLog().info((CharSequence)"Required regEx matches complete. Stopping test.");
                    Collector.collect((String)this.project.getArtifactId()).addExecutionTimeMs(System.currentTimeMillis() - this.testStart).close();
                    break;
                }
                this.getLog().info((CharSequence)("Required regEx matched " + tCount + " times."));
                stop = false;
                break;
            }
        }
        terminated.set(stop);
        return stop;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.testTimePlatform = this.testTime;
            if (TestAppMojo.isValidFile(this.platformDir)) {
                this.testTimePlatform = (int)((long)this.testTimePlatform + TimeUnit.MINUTES.toMillis(2L));
            }
            if (TestAppMojo.isValidFile(this.deploymentPlan)) {
                this.testTimePlatform = (int)((long)this.testTimePlatform + TimeUnit.MINUTES.toMillis(3L));
            }
            this.executeImpl();
        }
    }

    private ProcessUnit.ProcessUnitBuilder addMavenTestCall(ProcessUnit.ProcessUnitBuilder testBuilder) {
        String buildId;
        String sPath;
        Object tmpAppArgs = "";
        if (null != this.appArgs && this.appArgs.size() > 0) {
            tmpAppArgs = " " + CollectionUtils.toStringSpaceSeparated(this.appArgs);
        }
        testBuilder.addMavenCommand();
        if (this.offline || this.appOffline) {
            testBuilder.addArgument("-o");
        }
        if (null == (sPath = System.getenv("MAVEN_SETTINGS_PATH"))) {
            String string = sPath = null != this.request.getUserSettingsFile() ? this.request.getUserSettingsFile().getPath() : null;
        }
        if (null != sPath) {
            testBuilder.addArgument("-s");
            testBuilder.addArgument(sPath);
        }
        if (TestAppMojo.isValidFile(this.appPom)) {
            testBuilder.addArgument("-f");
            testBuilder.addArgument(this.appPom);
        }
        if (this.appProfile != null && this.appProfile.trim().length() > 0 && !this.appProfile.equals("-")) {
            testBuilder.addArgument("-P");
            testBuilder.addArgument(this.appProfile);
        }
        if ((buildId = System.getProperty("iip.ciBuildId")) != null) {
            testBuilder.addArgument("-Diip.ciBuildId=" + buildId);
        }
        if (null != this.mvnArgs) {
            testBuilder.addArguments(this.extrapolate(this.mvnArgs, this.befores));
        }
        testBuilder.addArgument("exec:java@" + this.appId);
        if (null != this.mvnPluginArgs) {
            testBuilder.addArguments(this.extrapolate(this.mvnPluginArgs, this.befores));
        }
        testBuilder.addArgument("-Diip.springStart.args=\"--iip.test.stop=" + this.testTime + " --iip.test.brokerPort=" + this.brokerPort + (String)tmpAppArgs + "\"");
        return testBuilder;
    }

    private String replacePlaceholder(String contents, String placeholder, String value) {
        return null == value ? contents : contents.replace("${" + placeholder + "}", value);
    }

    private String replaceAsUri(String contents, String placeholder, String value, String info) {
        String result = contents;
        if (null != value) {
            try {
                URI uri = new URI(value);
                uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null);
                result = this.replacePlaceholder(contents, placeholder, uri.toString());
            }
            catch (URISyntaxException e) {
                this.getLog().error((CharSequence)("Cannot process " + info + ": " + e.getMessage()));
            }
        } else {
            this.getLog().warn((CharSequence)("No " + info + " stated in runtime setup"));
        }
        return result;
    }

    private void writeMgtUiSetup(RuntimeSetup setup) {
        boolean mgtOutFileDefined;
        boolean bl = mgtOutFileDefined = this.mgtUiSetupFile != null && this.mgtUiSetupFile.getPath().length() > 0;
        if (null != setup && TestAppMojo.isValidFile(this.mgtUiSetupFileTemplate) && mgtOutFileDefined) {
            try {
                String contents = FileUtils.readFileToString((File)this.mgtUiSetupFileTemplate, (Charset)Charset.defaultCharset());
                contents = this.replaceAsUri(contents, "aasRegistryUri", setup.getAasRegistry(), "AAS registry");
                contents = this.replaceAsUri(contents, "aasServerUri", setup.getAasServer(), "AAS server");
                this.mgtUiSetupFile.getParentFile().mkdirs();
                try (PrintWriter out = new PrintWriter(new FileWriter(this.mgtUiSetupFile));){
                    out.println(contents);
                }
                this.getLog().info((CharSequence)("Wrote processed management UI setup file " + String.valueOf(this.mgtUiSetupFile)));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot process managment UI setup template/file: " + e.getMessage()));
            }
        } else if (null == setup) {
            this.getLog().warn((CharSequence)"No platform runtime setup found");
        } else if (!TestAppMojo.isValidFile(this.mgtUiSetupFileTemplate)) {
            this.getLog().warn((CharSequence)("No management UI setup template defined/found: " + String.valueOf(this.mgtUiSetupFileTemplate)));
        } else if (!mgtOutFileDefined) {
            this.getLog().warn((CharSequence)"No management UI setup output file defined");
        }
    }

    private List<String> extrapolate(List<String> args, List<TestProcessSpec> processes) {
        List<String> result = null;
        if (null != args && null != processes) {
            result = new ArrayList<String>();
            result.addAll(args);
            for (TestProcessSpec p : processes) {
                result = p.extrapolateArgs(result);
            }
        }
        return result;
    }

    private File determineBrokerDir() {
        File dir;
        if (this.brokerDir != null && this.brokerDir.length() > 0) {
            dir = new File(this.brokerDir);
        } else {
            File tmp = new File(this.outputDirectory);
            do {
                if ((dir = new File(tmp, "broker/broker")).exists()) continue;
                tmp = new File(tmp.getParent());
            } while (!dir.exists() && null != tmp && tmp.toString().length() > 0);
            if (null == tmp || tmp.toString().length() == 0) {
                dir = new File(this.outputDirectory, "broker/broker");
            }
        }
        this.getLog().info((CharSequence)("Using broker dir: " + String.valueOf(dir)));
        return dir;
    }

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        AtomicInteger testTerminatedCount = new AtomicInteger();
        AtomicBoolean testTerminated = new AtomicBoolean(false);
        if (this.brokerPort < 0) {
            this.brokerPort = NetUtils.getEphemeralPort();
        }
        if (this.brokerPort > 0) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stopProcessUnits()));
            this.getLog().info((CharSequence)("Using broker port: " + this.brokerPort));
            this.buildAndRegister(this.createPlatformBuilder("broker", this.determineBrokerDir(), "broker", null, String.valueOf(this.brokerPort)).setTimeout(this.testTimePlatform));
            TimeUtils.sleep((int)this.brokerWaitTime);
            this.writeMgtUiSetup(this.startPlatform(this.brokerPort));
        }
        this.startProcesses();
        ProcessUnit.ProcessUnitBuilder testBuilder = new ProcessUnit.ProcessUnitBuilder("test app", (Logger)this);
        if (null != this.logFile) {
            this.getLog().info((CharSequence)("Logging test output to " + String.valueOf(this.logFile)));
            testBuilder.logTo(this.logFile);
        }
        if (null != this.testCmd && this.testCmd.length() > 0) {
            this.deployApp(true, "");
            testBuilder.setNodeJsHome(this.nodejs);
            testBuilder.addArgumentOrScriptCommand(this.testCmdAsScript, this.testCmd);
            testBuilder.addArguments(this.appArgs);
        } else {
            this.addMavenTestCall(testBuilder);
        }
        testBuilder.setRegExConjunction(this.logRegExConjunction);
        if (null != this.logRegExprs) {
            for (String ex : this.logRegExprs) {
                try {
                    testBuilder.addCheckRegEx(Pattern.compile(ex));
                }
                catch (PatternSyntaxException e) {
                    this.getLog().error((CharSequence)("Cannot compile regex " + ex + ":" + e.getMessage() + " Ignoring."));
                }
            }
        }
        testBuilder.setTimeout(this.testTime).setListener(r -> this.handleTermination(r, testTerminated, testTerminatedCount));
        if (this.logFile != null && this.logFile.getPath().length() > 0) {
            testBuilder.logTo(this.logFile);
        }
        this.testStart = System.currentTimeMillis();
        ProcessUnit testUnit = this.buildAndRegister(testBuilder);
        this.getLog().info((CharSequence)("Waiting for test end, at maximum specified test time: " + this.testTime + " ms"));
        TimeUtils.waitFor(() -> !testTerminated.get() && testUnit.isRunning(), (int)this.testTime, (int)300);
        if (null != this.testCmd && this.testCmd.length() > 0) {
            this.deployApp(false, "1");
        }
        int testUnitExitStatus = testUnit.getExitValue();
        boolean failed = this.stopProcessUnits();
        if (testUnit.hasCheckRegEx() && !testUnit.getLogMatches()) {
            throw new MojoExecutionException("Specified regular expressions do not match. Test did not succeed.");
        }
        if (testUnitExitStatus != Integer.MIN_VALUE && testUnitExitStatus != 0) {
            throw new MojoExecutionException("Test processes did not succeed (status " + testUnitExitStatus + ") See above for details.");
        }
        if (failed) {
            throw new MojoExecutionException("Spawned processes did not terminate successfully. See above for details.");
        }
    }
}

