/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.configuration.PlatformInstantiatorExecutor;
import de.iip_ecosphere.platform.configuration.maven.DependencyResolver;
import de.iip_ecosphere.platform.configuration.maven.ProcessUnit;
import de.iip_ecosphere.platform.tools.maven.python.AbstractLoggingMojo;
import de.iip_ecosphere.platform.tools.maven.python.FileChangeDetector;
import de.iip_ecosphere.platform.tools.maven.python.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractConfigurationMojo
extends AbstractLoggingMojo
implements DependencyResolver.Caller {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(property="configuration.model", required=true)
    private String model;
    @Parameter(property="configuration.modelDirectory", required=true, defaultValue="src/test/easy")
    private String modelDirectory;
    @Parameter(property="configuration.metaModelDirectory", required=true, defaultValue="src/main/easy")
    private String metaModelDirectory;
    @Parameter(property="configuration.outputDirectory", required=true, defaultValue="gen")
    private String outputDirectory;
    @Parameter(property="configuration.resourcesDirectory", required=false, defaultValue="resources.ipr")
    private String resourcesDirectory;
    @Parameter(property="configuration.fallbackResourcesDirectory", required=false, defaultValue="resources")
    private String fallbackResourcesDirectory;
    @Parameter(property="configuration.tracingLevel", required=false, defaultValue="TOP")
    private String tracingLevel;
    @Parameter(property="configuration.adjustOutputDirectoryIfGenBroker", required=false, defaultValue="trues")
    private boolean adjustOutputDirectoryIfGenBroker;
    @Parameter(property="configuration.apps", required=false, defaultValue="")
    private String apps;
    @Parameter(property="configuration.force", required=false, defaultValue="")
    private boolean force;
    @Parameter(property="configuration.checkChanged", required=false, defaultValue="false")
    private boolean checkChanged;
    @Parameter(property="configuration.changeCheckArtifacts", required=false, defaultValue="")
    private String changeCheckArtifacts;
    @Parameter(property="unpack.force", required=false, defaultValue="false")
    private boolean unpackForce;
    @Parameter(required=false, defaultValue="true")
    private boolean asProcess;
    @Parameter
    private File mavenHome;

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public String getModel() {
        return this.model;
    }

    public String getModelDirectory() {
        return this.modelDirectory;
    }

    public String getMetaModelDirectory() {
        return this.metaModelDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public String getFallbackResourcesDirectory() {
        return this.fallbackResourcesDirectory;
    }

    public String getTracingLevel() {
        return this.tracingLevel;
    }

    protected boolean getUnpackForce() {
        return this.unpackForce;
    }

    protected boolean checkChanged() {
        return this.checkChanged;
    }

    public abstract String getStartRule();

    protected boolean isModelDirectoryValid() {
        boolean result = false;
        File modelDir = new File(this.getModelDirectory());
        if (modelDir.exists()) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*.ivml");
            try (Stream<Path> stream = Files.walk(modelDir.toPath(), new FileVisitOption[0]);){
                result = stream.anyMatch(f -> matcher.matches(f.getFileName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private String makeAbsolute(String directory) {
        String result = directory;
        if (null != directory && directory.length() > 0) {
            File f = new File(directory);
            if (!f.isAbsolute()) {
                f = new File(this.project.getBasedir(), directory);
            }
            result = f.getAbsolutePath();
        }
        return result;
    }

    private String validateDirectory(String directory) {
        String result = directory;
        if (null != directory && !new File(directory).exists()) {
            result = null;
        }
        return result;
    }

    protected String adjustOutputDir(String outputDir) {
        return outputDir;
    }

    protected File findGenParent(String outputDir) {
        File parent;
        File iter;
        boolean genFound = false;
        for (iter = parent = new File(outputDir); null != iter; iter = iter.getParentFile()) {
            if (!iter.getName().equals("gen")) continue;
            genFound = true;
            break;
        }
        if (null != iter && genFound) {
            parent = iter;
        }
        return parent;
    }

    protected boolean modelNewerThanOut(String metaModelDir, String modelDir, String outDir) {
        boolean enabled;
        boolean newer = false;
        String execId = null == this.mojoExecution.getExecutionId() ? "" : "-" + this.mojoExecution.getExecutionId();
        File metaHashFile = FileChangeDetector.getHashFileInTarget((MavenProject)this.project, (String)("easy-meta" + execId));
        File modelHashFile = FileChangeDetector.getHashFileInTarget((MavenProject)this.project, (String)("easy" + execId));
        List<File> metaModelFiles = this.checkFilesByHash(metaHashFile, metaModelDir, null);
        List<File> modelFiles = this.checkFilesByHash(modelHashFile, modelDir, "IVML model");
        boolean bl = enabled = this.enabled(modelFiles) || this.enabled(metaModelFiles);
        if ((metaHashFile.exists() || modelHashFile.exists()) && null != this.changeCheckArtifacts && !this.changeCheckArtifacts.isEmpty()) {
            Predicate<File> pred = f -> this.isNewer((File)f, metaHashFile) || this.isNewer((File)f, modelHashFile);
            StringTokenizer tokenizer = new StringTokenizer(this.changeCheckArtifacts);
            ArrayList<String> arts = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                arts.add(tokenizer.nextToken());
            }
            enabled |= new DependencyResolver(this).haveDependenciesChangedSince(arts, pred);
        }
        if (enabled) {
            long maxModel = this.getMaxLastModified(modelDir, f -> AbstractConfigurationMojo.isModelFile(f));
            long maxOut = this.getMaxLastModified(outDir, f -> true);
            newer = maxOut < 0L || maxModel > maxOut;
        }
        return newer || !new File(outDir).exists();
    }

    private static boolean isModelFile(File file) {
        String name = file.getName();
        return name.endsWith(".ivml") || name.endsWith(".vil") || name.endsWith(".vtl");
    }

    private boolean isNewer(File artifact, File hash) {
        return hash != null && artifact.lastModified() > hash.lastModified();
    }

    private boolean enabled(List<File> files) {
        return null == files || files.size() > 0;
    }

    private List<File> checkFilesByHash(File hashFile, String modelDir, String info) {
        List modelFiles = null;
        File model = new File(modelDir);
        try (Stream<Path> stream = Files.walk(model.toPath(), new FileVisitOption[0]);){
            FileChangeDetector fcd = new FileChangeDetector(hashFile, (Logger)this, info);
            fcd.readHashFile();
            modelFiles = stream.map(p -> p.toFile()).filter(f -> f.isFile()).collect(Collectors.toList());
            modelFiles = fcd.checkHashes(modelFiles);
            fcd.writeHashFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLog().info((CharSequence)("Changed " + info + " files: " + String.valueOf(modelFiles)));
        return modelFiles;
    }

    protected long getMaxLastModified(String dir, FileFilter filter) {
        long result = -1L;
        File d = new File(dir);
        if (d.exists()) {
            try (Stream<Path> stream = Files.walk(d.toPath(), new FileVisitOption[0]);){
                result = stream.map(p -> p.toFile().lastModified()).max(Long::compare).get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean enableRun(String metaModelDir, String modelDir, String outputDir) {
        return this.modelNewerThanOut(metaModelDir, modelDir, outputDir) || this.force;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.adjustMavenHome();
        String resourcesDir = this.validateDirectory(this.makeAbsolute(this.getResourcesDirectory()));
        if (null == resourcesDir) {
            resourcesDir = this.validateDirectory(this.makeAbsolute(this.getFallbackResourcesDirectory()));
        }
        String outputDir = this.adjustOutputDir(this.makeAbsolute(this.getOutputDirectory()));
        String modelDir = this.makeAbsolute(this.getModelDirectory());
        String metaModelDir = this.makeAbsolute(this.getMetaModelDirectory());
        String[] args = new String[]{this.getModel(), modelDir, outputDir, this.getStartRule(), metaModelDir};
        if (this.isModelDirectoryValid()) {
            if (this.enableRun(metaModelDir, modelDir, outputDir)) {
                PlatformInstantiatorExecutor executor = this.createExecutor();
                try {
                    if (this.asProcess) {
                        executor.executeAsProcess(this.getClass().getClassLoader(), resourcesDir, this.getTracingLevel(), this.composeMvnArgs(), args);
                    }
                    executor.execute(ClassLoader.getPlatformClassLoader(), resourcesDir, this.getTracingLevel(), this.composeMvnArgs(), args);
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            } else {
                this.getLog().info((CharSequence)("Skipped as code in output directory '" + outputDir + "' is newer than IVML model."));
            }
        } else {
            this.getLog().info((CharSequence)("Model directory is not valid. No IVML files found in " + this.getModelDirectory()));
        }
    }

    private void adjustMavenHome() {
        String bin = ProcessUnit.getMavenBinPath();
        if (null == bin && this.mavenHome != null) {
            System.setProperty("okto.mvn.home", this.mavenHome.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Using Maven bin path: " + ProcessUnit.getMavenBinPath()));
    }

    private PlatformInstantiatorExecutor createExecutor() {
        File localRepo = null;
        LocalRepository lr = this.getRepoSession().getLocalRepository();
        if (lr != null) {
            localRepo = lr.getBasedir();
        }
        return new PlatformInstantiatorExecutor(localRepo, w -> this.getLog().warn((CharSequence)w), i -> this.getLog().info((CharSequence)i), t -> this.recordExecutionTime((long)t));
    }

    private String composeMvnArgs() {
        Object mvnArgs = "";
        if (this.session.isOffline()) {
            mvnArgs = (String)mvnArgs + "-o";
        }
        return mvnArgs;
    }

    protected void recordExecutionTime(long time) {
    }

    @Override
    public MavenSession getSession() {
        return this.session;
    }

    @Override
    public ProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    @Override
    public RepositorySystem getRepoSystem() {
        return this.repoSystem;
    }
}

