/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.configuration.maven.BasicProcessSpec;
import de.iip_ecosphere.platform.configuration.maven.ProcessUnit;
import de.iip_ecosphere.platform.tools.maven.python.AbstractLoggingMojo;
import de.iip_ecosphere.platform.tools.maven.python.Logger;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process", defaultPhase=LifecyclePhase.COMPILE)
public class ProcessMojo
extends AbstractLoggingMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="configuration.process.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="configuration.process.processes", required=false)
    private List<BasicProcessSpec> processes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip && null != this.processes) {
            for (BasicProcessSpec p : this.processes) {
                ProcessUnit.ProcessUnitBuilder builder = new ProcessUnit.ProcessUnitBuilder(p.getDescription(), (Logger)this);
                builder.addArgumentOrScriptCommand(p.isCmdAsScript(), p.getCmd());
                if (null != p.getHome()) {
                    builder.setHome(p.getHome());
                }
                p.allocatePorts(this.project, this.getLog());
                builder.addArguments(p.extrapolateArgs());
                ProcessUnit pu = builder.build4Mvn();
                int status = pu.waitFor();
                if (status == Integer.MIN_VALUE || status == 0) continue;
                throw new MojoExecutionException(pu.getDescription() + " terminated with status: " + status);
            }
        }
    }
}

