/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.configuration.maven.AbstractConfigurationMojo;
import java.io.File;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.maven.AbstractTest;

public class ConfigurationTest
extends AbstractTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testNoIvml() throws Exception {
        MavenProject project = this.readMavenProject(new File("src/test/resources/unit/project-noIvml"));
        this.assertBase(project, "generateApps");
        this.assertBase(project, "generateAppsNoDeps");
        this.assertBase(project, "generateBroker");
        this.assertBase(project, "generateInterfaces");
        this.assertBase(project, "generatePlatform");
    }

    private void assertBase(MavenProject project, String goal) throws Exception {
        this.assertBase(project, goal, goal);
    }

    private void assertBase(MavenProject project, String goal, String expectedStartRule) throws Exception {
        AbstractConfigurationMojo mojo = (AbstractConfigurationMojo)this.lookupConfiguredMojo(project, goal);
        ConfigurationTest.assertNotNull((Object)mojo);
        Assert.assertEquals((Object)expectedStartRule, (Object)mojo.getStartRule());
        Assert.assertEquals((Object)"ExamplePython", (Object)mojo.getModel());
        Assert.assertTrue((boolean)mojo.getModelDirectory().endsWith("/src/test/easy"));
        Assert.assertTrue((boolean)mojo.getOutputDirectory().endsWith("/gen/py"));
        Assert.assertTrue((boolean)mojo.getResourcesDirectory().endsWith("/resources"));
        Assert.assertTrue((boolean)mojo.getFallbackResourcesDirectory().endsWith("/resources"));
        Assert.assertEquals((Object)"TOP", (Object)mojo.getTracingLevel());
        mojo.execute();
    }
}

