/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.JavaUtils;
import de.iip_ecosphere.platform.tools.maven.python.Logger;
import de.iip_ecosphere.platform.tools.maven.python.StandardLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ProcessUnit {
    public static final String PROP_MAVEN_BIN = "okto.mvn.home";
    public static final Set<String> SCRIPT_NAMES = Collections.unmodifiableSet(CollectionUtils.toSet((Object[])new String[]{"ant", "ng", "npm", "mvn"}));
    public static final String[] WIN_BAT_PREFIX = new String[]{"cmd", "/s", "/c"};
    public static final int UNKOWN_EXIT_STATUS = Integer.MIN_VALUE;
    private static Timer timer;
    private String description;
    private Process process;
    private TimerTask timeoutTask;
    private List<Closeable> closeables;
    private boolean logMatches;
    private List<Pattern> checkRegEx;
    private Logger logger;
    private TerminationListener listener;

    private ProcessUnit(String description, Process process, long timeout, TerminationListener listener, List<Pattern> checkRegEx, Logger logger) {
        this.description = description;
        this.process = process;
        this.listener = listener;
        this.logger = logger;
        if (checkRegEx != null) {
            this.checkRegEx = Collections.unmodifiableList(checkRegEx);
        }
        if (timeout > 0L) {
            if (null == timer) {
                timer = new Timer();
            }
            this.timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    ProcessUnit.this.handleListenerNotification(TerminationReason.TIMEOUT);
                }
            };
            timer.schedule(this.timeoutTask, timeout);
        }
    }

    private void attach(InputStreamHandler handler) {
        this.attach((Closeable)handler);
        new Thread(handler).start();
    }

    private void attach(Closeable closeable) {
        if (null == this.closeables) {
            this.closeables = new ArrayList<Closeable>();
        }
        this.closeables.add(closeable);
    }

    private void notifyLogMatches(boolean terminateByLogMatch) {
        this.logMatches = true;
        if (terminateByLogMatch) {
            this.handleListenerNotification(TerminationReason.MATCH_COMPLETE);
        }
    }

    private void handleListenerNotification(TerminationReason reason) {
        boolean stop = reason.isStopRequired();
        stop = null != this.listener ? (stop |= this.listener.notifyTermination(reason)) : true;
        if (stop) {
            this.stop();
        }
    }

    public boolean getLogMatches() {
        return this.logMatches;
    }

    public int getExitValue() {
        return null == this.process || this.process.isAlive() ? Integer.MIN_VALUE : this.process.exitValue();
    }

    public static boolean isFailed(int status) {
        return status != Integer.MIN_VALUE && status != 0;
    }

    public static boolean isSuccess(int status) {
        return status != Integer.MIN_VALUE && status == 0;
    }

    public static String getMavenBinPath() {
        return System.getProperty(PROP_MAVEN_BIN);
    }

    public String getDescription() {
        return this.description;
    }

    public List<Pattern> getCheckRegEx() {
        return this.checkRegEx;
    }

    public boolean hasCheckRegEx() {
        return this.getCheckRegEx() != null && this.getCheckRegEx().size() > 0;
    }

    public boolean isRunning() {
        return null != this.process && this.process.isAlive();
    }

    public int waitFor() {
        int result = Integer.MIN_VALUE;
        if (null != this.process && this.process.isAlive()) {
            try {
                result = this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    private static void splitPath(Consumer<String> pathEltConsumer) {
        String path = System.getProperty("java.library.path", "");
        StringTokenizer tokens = new StringTokenizer(path, File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            pathEltConsumer.accept(tokens.nextToken());
        }
    }

    public synchronized int stop() {
        if (null != this.timeoutTask) {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
        }
        if (null != this.process) {
            this.logger.info("Stopping process '" + this.description + "'");
            ProcessHandle.of(this.process.pid()).ifPresent(p -> p.descendants().forEach(ProcessHandle::destroyForcibly));
            this.process.destroyForcibly();
            this.process = null;
        }
        if (null != this.closeables) {
            for (Closeable c : this.closeables) {
                try {
                    c.close();
                }
                catch (IOException iOException) {}
            }
            this.closeables = null;
        }
        return this.getExitValue();
    }

    public static interface TerminationListener {
        public boolean notifyTermination(TerminationReason var1);
    }

    public static enum TerminationReason {
        TIMEOUT(true),
        MATCH_COMPLETE(false);

        private boolean stopRequired;

        private TerminationReason(boolean stopRequired) {
            this.stopRequired = stopRequired;
        }

        public boolean isStopRequired() {
            return this.stopRequired;
        }
    }

    private static class InputStreamHandler
    implements Runnable,
    Closeable {
        private InputStream in;
        private Consumer<String> logger;
        private List<Pattern> checkRegEx;
        private Consumer<Pattern> checkResultConsumer;

        private InputStreamHandler(InputStream in, Consumer<String> logger, List<Pattern> checkRegEx, Consumer<Pattern> checkResultConsumer) {
            this.in = in;
            this.logger = logger;
            this.checkRegEx = checkRegEx;
            this.checkResultConsumer = checkResultConsumer;
        }

        @Override
        public void run() {
            Scanner sc = new Scanner(this.in);
            while (null != this.logger && sc.hasNextLine()) {
                String line = sc.nextLine();
                if (null == line) continue;
                if (null != this.logger) {
                    this.logger.accept(line);
                }
                if (null == this.checkRegEx) continue;
                for (Pattern p : this.checkRegEx) {
                    if (!p.matcher(line).matches()) continue;
                    this.checkResultConsumer.accept(p);
                }
            }
            sc.close();
        }

        @Override
        public void close() throws IOException {
            this.logger = null;
        }
    }

    private static class ConjunctiveLogRegExConsumer
    implements Consumer<Pattern> {
        private List<Pattern> requiredPatterns;
        private Set<Pattern> patterns;
        private ProcessUnit unit;
        private boolean notifyByLogMatch;

        ConjunctiveLogRegExConsumer(List<Pattern> patterns, ProcessUnit unit, boolean notifyByLogMatch) {
            this.unit = unit;
            this.notifyByLogMatch = notifyByLogMatch;
            if (patterns != null && patterns.size() > 0) {
                this.requiredPatterns = Collections.unmodifiableList(patterns);
                this.patterns = new HashSet<Pattern>();
            }
        }

        @Override
        public void accept(Pattern pattern) {
            if (this.patterns != null) {
                this.patterns.remove(pattern);
                if (this.patterns.isEmpty()) {
                    this.unit.notifyLogMatches(this.notifyByLogMatch);
                    this.patterns.addAll(this.requiredPatterns);
                }
            }
        }
    }

    public static class ProcessUnitBuilder {
        private String description;
        private List<String> args = new ArrayList<String>();
        private File home;
        private Logger logger;
        private long timeout;
        private File logFile;
        private List<Pattern> checkRegEx;
        private TerminationListener listener;
        private boolean notifyByLogMatch = true;
        private boolean conjunctLogMatches = true;
        private String argAggregate;
        private String argAggregateStart;
        private String argAggregateEnd;
        private boolean err2In = false;
        private String nodejsHome;

        public ProcessUnitBuilder(String description, Logger logger) {
            this.description = description;
            this.logger = null == logger ? new StandardLogger() : logger;
        }

        public ProcessUnitBuilder logTo(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public ProcessUnitBuilder addCheckRegEx(Pattern regEx) {
            if (null == this.checkRegEx) {
                this.checkRegEx = new ArrayList<Pattern>();
            }
            this.checkRegEx.add(regEx);
            return this;
        }

        public ProcessUnitBuilder setRegExConjunction(boolean conjunct) {
            this.conjunctLogMatches = conjunct;
            return this;
        }

        public ProcessUnitBuilder setHome(File home) {
            this.home = home;
            return this;
        }

        public ProcessUnitBuilder redirectErr2In() {
            this.err2In = true;
            return this;
        }

        public ProcessUnitBuilder addMavenCommand() {
            if (SystemUtils.IS_OS_WINDOWS) {
                this.addArguments(WIN_BAT_PREFIX);
                this.enableArgumentAggregation();
            }
            this.addArgument(this.getMavenPath());
            return this;
        }

        private String getMavenPath() {
            Object path = ProcessUnit.getMavenBinPath();
            if (path != null) {
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
            } else {
                path = "";
            }
            return (String)path + "mvn";
        }

        private String prependPath(String path, String cmd) {
            Object result = cmd;
            if (null != path && ((String)path).length() > 0) {
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
                result = (String)path + cmd;
            }
            return result;
        }

        public ProcessUnitBuilder setNodeJsHome(String home) {
            if (home != null && home.length() > 0) {
                this.nodejsHome = home;
            }
            return this;
        }

        private String getNodeJsPath() {
            String result = this.nodejsHome;
            if (null == result) {
                result = System.getenv("NODEJS_HOME");
            }
            if (null == result) {
                AtomicReference<String> res = new AtomicReference<String>(result);
                ProcessUnit.splitPath(e -> {
                    if (e.contains("nodejs")) {
                        res.set((String)e);
                    }
                });
                result = res.get();
            }
            return result;
        }

        public ProcessUnitBuilder addShellScriptCommand(String scriptName) {
            return this.addShellScriptCommand(scriptName, SystemUtils.IS_OS_WINDOWS ? "bat" : "sh");
        }

        public ProcessUnitBuilder addShellScriptCommand(String scriptName, String extension) {
            Object cmd = scriptName;
            if (extension != null && extension.length() > 0) {
                Object e = extension;
                if (!((String)e).startsWith(".")) {
                    e = "." + (String)e;
                }
                cmd = (String)cmd + (String)e;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                this.addArguments(WIN_BAT_PREFIX);
                this.enableArgumentAggregation();
                this.addArgument(cmd);
            } else {
                this.addArguments("sh", "./" + (String)cmd);
            }
            return this;
        }

        private void enableArgumentAggregation() {
            if (SystemUtils.IS_OS_WINDOWS) {
                this.argAggregate = "";
                this.argAggregateStart = "\"";
                this.argAggregateEnd = "\"";
            }
        }

        private boolean appendByAggregation(String arg) {
            if (this.argAggregate != null && arg.length() > 0) {
                if (this.argAggregate.length() > 0) {
                    this.argAggregate = this.argAggregate + " ";
                }
                this.argAggregate = this.argAggregate + arg;
            }
            return this.argAggregate == null;
        }

        public ProcessUnitBuilder addArgumentOrScriptCommand(String cmd) {
            return this.addArgumentOrScriptCommand(false, cmd);
        }

        public ProcessUnitBuilder addArgumentOrScriptCommand(boolean cmdAsScript, String cmd) {
            if (SCRIPT_NAMES.contains(cmd)) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    this.addArguments(WIN_BAT_PREFIX);
                    this.enableArgumentAggregation();
                }
                if ("ng".equals(cmd) || "npm".equals(cmd)) {
                    cmd = this.prependPath(this.getNodeJsPath(), cmd);
                }
                this.addArgument(cmd);
            } else if (cmdAsScript) {
                this.addShellScriptCommand(cmd);
            } else {
                if ("mvn".equals(cmd)) {
                    cmd = this.getMavenPath();
                }
                this.addArgument(cmd);
            }
            return this;
        }

        public ProcessUnitBuilder addArgument(boolean enable, Object argument) {
            if (enable) {
                this.addArgument(argument);
            }
            return this;
        }

        public ProcessUnitBuilder addArgument(Object argument) {
            String arg = argument.toString();
            if (this.appendByAggregation(arg)) {
                this.args.add(arg);
            }
            return this;
        }

        public ProcessUnitBuilder addArguments(List<String> arguments) {
            if (null != arguments && this.appendByAggregation(CollectionUtils.toStringSpaceSeparated(arguments))) {
                this.args.addAll(arguments);
            }
            return this;
        }

        public ProcessUnitBuilder addArguments(String ... arguments) {
            return this.addArguments(CollectionUtils.toList((Object[])arguments));
        }

        public ProcessUnitBuilder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public ProcessUnitBuilder setNotifyListenerByLogMatch(boolean notifyByLogMatch) {
            this.notifyByLogMatch = notifyByLogMatch;
            return this;
        }

        public ProcessUnitBuilder setListener(TerminationListener listener) {
            this.listener = listener;
            return this;
        }

        public ProcessUnit build4Mvn() throws MojoExecutionException {
            try {
                return this.build();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }

        public ProcessUnit build() throws IOException {
            Object path;
            Object info = "";
            if (null != this.argAggregate) {
                this.args.add(this.argAggregateStart + this.argAggregate + this.argAggregateEnd);
                this.argAggregate = null;
                this.argAggregateStart = null;
                this.argAggregateEnd = null;
            }
            ProcessBuilder builder = new ProcessBuilder(this.args);
            if (null != this.home) {
                builder.directory(this.home);
                info = " in " + String.valueOf(this.home);
            }
            if (null != (path = JavaUtils.getJavaPath()) && null != ProcessUnit.getMavenBinPath()) {
                path = (String)path + File.pathSeparator + ProcessUnit.getMavenBinPath();
            }
            if (null != this.nodejsHome && this.nodejsHome.length() > 0) {
                path = path == null ? this.nodejsHome : (String)path + File.pathSeparator + this.nodejsHome;
            }
            if (null != path) {
                if (builder.environment().get("PATH") != null) {
                    path = (String)path + File.pathSeparator + builder.environment().get("PATH");
                }
                builder.environment().put("PATH", (String)path);
                info = (String)info + " with " + (String)path + " in PATH";
            }
            this.logger.info("Starting " + CollectionUtils.toStringSpaceSeparated(this.args) + (String)info);
            Process proc = builder.start();
            ProcessUnit result = new ProcessUnit(this.description, proc, this.timeout, this.listener, this.checkRegEx, this.logger);
            if (null != proc) {
                Consumer<String> inConsumer = null;
                Consumer<String> errConsumer = null;
                if (null != this.logFile) {
                    try {
                        PrintWriter logWriter = new PrintWriter(new FileWriter(this.logFile));
                        inConsumer = l -> logWriter.println((String)l);
                        errConsumer = inConsumer;
                        result.attach(logWriter);
                    }
                    catch (IOException e) {
                        this.logger.error((Throwable)e);
                    }
                }
                if (null == inConsumer) {
                    inConsumer = l -> this.logger.info(l);
                }
                if (null == errConsumer) {
                    errConsumer = this.err2In ? l -> this.logger.info(l) : l -> this.logger.error(l);
                }
                ConjunctiveLogRegExConsumer matchConsumer = this.conjunctLogMatches ? new ConjunctiveLogRegExConsumer(this.checkRegEx, result, this.notifyByLogMatch) : m -> result.notifyLogMatches(this.notifyByLogMatch);
                result.attach(new InputStreamHandler(proc.getInputStream(), inConsumer, this.checkRegEx, matchConsumer));
                result.attach(new InputStreamHandler(proc.getErrorStream(), errConsumer, this.checkRegEx, matchConsumer));
            }
            return result;
        }
    }
}

