/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ConfigurationLifecycleDescriptor;
import de.iip_ecosphere.platform.configuration.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.EasySetup;
import de.iip_ecosphere.platform.configuration.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.StatisticsVisitor;
import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import org.junit.Assert;
import org.junit.Test;

public class CommentTests {
    private static final boolean recordMissing(AbstractVariable var, SortedSet<String> missing) {
        AbstractVariable parentVar;
        IDatatype type;
        boolean record = true;
        if (var.getParent() instanceof AbstractVariable && TypeQueries.isContainer((IDatatype)(type = DerivedDatatype.resolveToBasis((IDatatype)(parentVar = (AbstractVariable)var.getParent()).getType())))) {
            record = false;
        }
        if (record) {
            missing.add(var.getQualifiedName() + " = ");
        }
        return record;
    }

    @Test
    public void testComments() {
        TreeSet missing = new TreeSet();
        ConfigurationSetup setup = ConfigurationSetup.getSetup();
        EasySetup easySetup = setup.getEasyProducer();
        easySetup.reset();
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer("IIPEcosphere", easySetup.getIvmlMetaModelFolder(), new File("gen"));
        configurer.configure(setup);
        ConfigurationLifecycleDescriptor lcd = configurer.obtainLifecycleDescriptor();
        lcd.startup(new String[0]);
        StatisticsVisitor vis = new StatisticsVisitor();
        vis.setNoCommentConsumer(v -> CommentTests.recordMissing(v, missing));
        Configuration cfg = ConfigurationManager.getIvmlConfiguration();
        Assert.assertNotNull((Object)cfg);
        vis.visitConfiguration(cfg);
        StatisticsVisitor.Statistics stat = vis.getStatistics();
        lcd.shutdown();
        setup.getEasyProducer().reset();
        System.out.println("metaVars: " + stat.getMetaVars() + ", metaVars (commented): " + stat.getMetaVarsWithComment() + ", used vars: " + stat.noOfVariables() + ", top-level vars: " + stat.noOfToplevelVariables() + ", constraints: " + stat.noOfConstraintVariables());
        for (String s : missing) {
            System.out.println(s);
        }
        Assert.assertEquals((String)"There are variables without comment/description in respective .text file for the actual locale. For affected variable names to be fixed, please see above.", (long)stat.getMetaVars(), (long)stat.getMetaVarsWithComment());
    }
}

