/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.PlatformInstantiatorExecutor;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.AbstractIvmlTests;

public class IvmlKodexMeshTests
extends AbstractIvmlTests {
    @Test
    public void testKodexMesh() throws ExecutionException, IOException {
        File gen = new File(TEST_BASE_FOLDER, "KodexMesh");
        PlatformInstantiatorExecutor.instantiate((PlatformInstantiator.InstantiationConfigurer)IvmlKodexMeshTests.genApps(new AbstractIvmlTests.TestConfigurer("KodexMesh", new File(MODEL_BASE_FOLDER, "single"), gen)));
        File base = new File(gen, "ApplicationInterfaces");
        File srcMain = new File(base, "src/main");
        File srcMainPython = new File(srcMain, "python");
        File srcMainAssembly = new File(srcMain, "assembly");
        IvmlKodexMeshTests.assertFile(srcMainAssembly, "pythonInterfaces.xml");
        this.extractPythonServiceEnv(srcMainPython);
        this.pythonSourceCodeCheck(srcMainPython, "datatypes/KRec13.py");
        this.pythonSourceCodeCheck(srcMainPython, "datatypes/KRec13Impl.py");
        this.pythonSourceCodeCheck(srcMainPython, "datatypes/KRec13Anon.py");
        this.pythonSourceCodeCheck(srcMainPython, "datatypes/KRec13AnonImpl.py");
        this.pythonSourceCodeCheck(srcMainPython, "serializers/KRec13Serializer.py");
        this.pythonSourceCodeCheck(srcMainPython, "serializers/KRec13AnonSerializer.py");
        this.pythonSourceCodeCheck(srcMainPython, "interfaces/KodexPythonServiceInterface.py");
        base = new File(gen, "SimpleKodexTestingApp");
        srcMain = new File(base, "src/main");
        srcMainPython = new File(srcMain, "python");
        srcMainAssembly = new File(srcMain, "assembly");
        IvmlKodexMeshTests.assertFile(srcMainAssembly, "kodex_pseudonymizer.xml");
        IvmlKodexMeshTests.assertFile(srcMainAssembly, "python_kodexPythonService.xml");
        IvmlKodexMeshTests.assertAllFiles(gen);
        IvmlKodexMeshTests.assertTemplateZip(gen, "impl.SimpleKodexTestingApp");
    }
}

