/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.DrawflowGraphFormat;
import de.iip_ecosphere.platform.configuration.ivml.AasIvmlMapper;
import de.iip_ecosphere.platform.configuration.ivml.AbstractIvmlModifier;
import de.iip_ecosphere.platform.configuration.serviceMesh.ServiceMeshGraphMapper;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;

public class ConfigurationAas
implements AasContributor,
AbstractIvmlModifier.ConfigurationChangeListener,
JsonResultWrapper.OperationCompletedListener {
    public static final String NAME_SUBMODEL = "Configuration";
    private transient List<AasIvmlMapper.AasChange> aasChanges = new ArrayList<AasIvmlMapper.AasChange>();

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)NAME_SUBMODEL);
        AasIvmlMapper mapper = new AasIvmlMapper(() -> ConfigurationManager.getVilConfiguration(), new ServiceMeshGraphMapper(), this);
        mapper.mapByType(smB, iCreator);
        mapper.addGraphFormat(new DrawflowGraphFormat());
        ConfigurationManager.setAasOperationCompletedListener(this);
        ConfigurationManager.setAasIvmlMapper(mapper);
        smB.build();
        return null;
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
        ConfigurationManager.getAasIvmlMapper().bindOperations(sBuilder);
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    public boolean isValid() {
        return true;
    }

    private void clearAasChanges() {
        this.aasChanges.clear();
    }

    @Override
    public void configurationChanged(IDecisionVariable var, AbstractIvmlModifier.ConfigurationChangeType type) {
        this.aasChanges.add(new AasIvmlMapper.AasChange(var, type));
    }

    public void operationCompleted() {
        try {
            Aas aas = AasPartRegistry.retrieveIipAas();
            Submodel sm = aas.getSubmodel(NAME_SUBMODEL);
            Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac((Aas)aas, (String)NAME_SUBMODEL);
            for (AasIvmlMapper.AasChange c : this.aasChanges) {
                c.apply(ConfigurationManager.getAasIvmlMapper(), sm, smB);
            }
            smB.build();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(ConfigurationAas.class).error("While modifying configuration AAS: {}", (Object)e.getMessage());
        }
        this.clearAasChanges();
    }

    public void operationFailed() {
        this.clearAasChanges();
    }
}

