/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.EasyLogLevel;
import de.iip_ecosphere.platform.configuration.EasySetup;
import de.iip_ecosphere.platform.configuration.StatusCache;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.uni_hildesheim.sse.easy.loader.ManifestLoader;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.logger.ILogger;
import net.ssehub.easy.basics.logger.LoggingLevel;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.producer.core.mgmt.EasyExecutor;

public class ConfigurationLifecycleDescriptor
implements LifecycleDescriptor {
    private ManifestLoader loader;
    private boolean doLogging = true;
    private boolean doFilterLogs = false;
    private ClassLoader classLoader = ConfigurationLifecycleDescriptor.class.getClassLoader();

    private boolean allowLogging(String msg, Class<?> clazz, String bundleName, LogLevel level) {
        boolean emit = this.doLogging;
        if (this.doFilterLogs && LogLevel.ERROR != level && LogLevel.WARN != level) {
            emit = clazz == EasyExecutor.class;
        }
        return emit;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (null != classLoader) {
            this.classLoader = classLoader;
        }
    }

    public void startup(String[] args) {
        try {
            Slf4EasyLogger logger = new Slf4EasyLogger();
            Log.setLogger((Log.LoaderLogger)logger);
            EASyLoggerFactory.INSTANCE.setLogger((ILogger)logger);
            EASyLoggerFactory.INSTANCE.setLoggingLevel(LoggingLevel.INFO);
            ConfigurationSetup setup = ConfigurationSetup.getSetup();
            this.loader = new ManifestLoader(false, this.classLoader);
            EasySetup easySetup = setup.getEasyProducer();
            this.loader.setVerbose(easySetup.getLogLevel() == EasyLogLevel.EXTRA_VERBOSE);
            ConfigurationLifecycleDescriptor.getLogger().info("EASy-Producer is starting");
            this.doFilterLogs = easySetup.getLogLevel() == EasyLogLevel.NORMAL;
            this.doLogging = !this.doFilterLogs;
            this.loader.startup();
            this.doLogging = true;
            ConfigurationLifecycleDescriptor.getLogger().info("Setting up configuration base: {}", (Object)easySetup.getBase());
            ConfigurationLifecycleDescriptor.getLogger().info("Setting up configuration meta model: {}", (Object)easySetup.getIvmlMetaModelFolder());
            ConfigurationLifecycleDescriptor.getLogger().info("Setting up configuration model name: {}", (Object)easySetup.getIvmlModelName());
            EasyExecutor exec = new EasyExecutor(easySetup.getBase(), easySetup.getIvmlMetaModelFolder(), easySetup.getIvmlModelName());
            exec.setLogger((EasyExecutor.Logger)new ExecLogger());
            exec.setVilModelName("IIPEcosphere");
            ConfigurationLifecycleDescriptor.getLogger().info("Setting up generation target: {}", (Object)easySetup.getGenTarget());
            exec.setVilSource(easySetup.getGenTarget());
            exec.setVilTarget(easySetup.getGenTarget());
            File ivmlCfg = easySetup.getIvmlConfigFolder();
            if (null != ivmlCfg && !ivmlCfg.equals(easySetup.getIvmlMetaModelFolder())) {
                ConfigurationLifecycleDescriptor.getLogger().info("Setting up configuration folder: {}", (Object)ivmlCfg);
                exec.prependIvmlFolder(ivmlCfg);
            }
            if (null != easySetup.getAdditionalIvmlFolders()) {
                for (File f : easySetup.getAdditionalIvmlFolders()) {
                    ConfigurationLifecycleDescriptor.getLogger().info("Setting up additional configuration folder: {}", (Object)f);
                    exec.addIvmlFolder(f);
                }
            }
            try {
                ConfigurationLifecycleDescriptor.getLogger().info("Setting up EASy-Producer locations, loading models");
                exec.setupLocations();
                ConfigurationManager.setExecutor(exec);
                ConfigurationLifecycleDescriptor.getLogger().info("EASy-Producer models loaded");
                StatusCache.start();
                ConfigurationLifecycleDescriptor.getLogger().info("Status cache started");
            }
            catch (ModelManagementException e) {
                ConfigurationLifecycleDescriptor.getLogger().error("Cannot set model locations. Configuration capabilities may be disabled. " + e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            ConfigurationLifecycleDescriptor.getLogger().error("Cannot start EASy-Producer. Configuration capabilities may be disabled. " + e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        StatusCache.stop();
        EasyExecutor exec = ConfigurationManager.getExecutor();
        if (null != exec) {
            try {
                exec.discardLocations();
            }
            catch (ModelManagementException e) {
                ConfigurationLifecycleDescriptor.getLogger().error("Cannot set model locations. Configuration capabilities may be disabled. " + e.getMessage(), (Throwable)e);
            }
        }
        exec.clearModels();
        ConfigurationManager.setExecutor(null);
        if (null != this.loader) {
            ConfigurationLifecycleDescriptor.getLogger().info("EASy-Producer is stopping");
            this.doLogging = !this.doFilterLogs;
            this.loader.shutdown();
            this.doLogging = true;
            ConfigurationLifecycleDescriptor.getLogger().info("EASy-Producer stopped");
        }
    }

    public Thread getShutdownHook() {
        return null;
    }

    public int priority() {
        return 1;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ConfigurationLifecycleDescriptor.class);
    }

    private static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        TRACE,
        FATAL,
        OFF;

    }

    private class Slf4EasyLogger
    implements ILogger,
    Log.LoaderLogger {
        private Slf4EasyLogger() {
        }

        public void info(String msg, Class<?> clazz, String bundleName) {
            if (ConfigurationLifecycleDescriptor.this.allowLogging(msg, clazz, bundleName, LogLevel.INFO)) {
                ConfigurationLifecycleDescriptor.getLogger().info("[" + clazz.getName() + "] " + msg);
            }
        }

        public void error(String msg, Class<?> clazz, String bundleName) {
            if (ConfigurationLifecycleDescriptor.this.allowLogging(msg, clazz, bundleName, LogLevel.ERROR)) {
                ConfigurationLifecycleDescriptor.getLogger().error("[" + clazz.getName() + "] " + msg);
            }
        }

        public void warn(String msg, Class<?> clazz, String bundleName) {
            if (ConfigurationLifecycleDescriptor.this.allowLogging(msg, clazz, bundleName, LogLevel.WARN)) {
                ConfigurationLifecycleDescriptor.getLogger().warn("[" + clazz.getName() + "] " + msg);
            }
        }

        public void debug(String msg, Class<?> clazz, String bundleName) {
            if (ConfigurationLifecycleDescriptor.this.allowLogging(msg, clazz, bundleName, LogLevel.DEBUG)) {
                ConfigurationLifecycleDescriptor.getLogger().debug("[" + clazz.getName() + "] " + msg);
            }
        }

        public void exception(String msg, Class<?> clazz, String bundleName) {
            if (ConfigurationLifecycleDescriptor.this.allowLogging(msg, clazz, bundleName, LogLevel.ERROR)) {
                ConfigurationLifecycleDescriptor.getLogger().error("[" + clazz.getName() + "] " + msg);
            }
        }

        public void error(String error) {
            ConfigurationLifecycleDescriptor.getLogger().error("[Loader] " + error);
        }

        public void error(String error, Exception exception) {
            ConfigurationLifecycleDescriptor.getLogger().error("[Loader] " + error);
        }

        public void warn(String warning) {
            ConfigurationLifecycleDescriptor.getLogger().warn("[Loader] " + warning);
        }

        public void warn(String warning, Exception exception) {
            ConfigurationLifecycleDescriptor.getLogger().warn("[Loader] " + warning);
        }

        public void info(String msg) {
            ConfigurationLifecycleDescriptor.getLogger().warn("[Loader] " + msg);
        }
    }

    private class ExecLogger
    implements EasyExecutor.Logger {
        private ExecLogger() {
        }

        public void warn(String text) {
            ConfigurationLifecycleDescriptor.getLogger().warn(text);
        }

        public void error(String text) {
            ConfigurationSetup setup = ConfigurationSetup.getSetup();
            EasySetup eSetup = setup.getEasyProducer();
            ConfigurationLifecycleDescriptor.getLogger().error("{} [base: {} model: {} meta: {} cfg: {} gen: {} additional: {}]", new Object[]{text, eSetup.getBase(), eSetup.getIvmlModelName(), eSetup.getIvmlMetaModelFolder(), eSetup.getIvmlConfigFolder(), eSetup.getGenTarget(), eSetup.getAdditionalIvmlFolders()});
        }

        public void info(String text) {
        }
    }
}

