/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.aas;

import de.iip_ecosphere.platform.configuration.aas.AasEnum;
import de.iip_ecosphere.platform.configuration.aas.AasEnumLiteral;
import de.iip_ecosphere.platform.configuration.aas.AasField;
import de.iip_ecosphere.platform.configuration.aas.ParsingEnumKind;
import de.iip_ecosphere.platform.configuration.aas.RowProcessor;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.SemanticIdRecognizer;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ParsingUtils {
    public static final String IRI_MARKER_TEXT = "IRI";
    public static final String IRDI_MARKER_TEXT = "IRDI";
    public static final String[] SEMANTICID_MARKER = new String[]{ParsingUtils.toSemanticIdMarker("IRI"), ParsingUtils.toSemanticIdMarker("IRDI")};
    public static final String[] SEMANTICID_MARKER_WITH_PATH = new String[]{SEMANTICID_MARKER[0], SEMANTICID_MARKER[1], "[IRDI PATH]", "[IRDI Path]"};
    private static final Pattern BRACKETS_WIITH_FOOTNOTE = Pattern.compile("^\\[([^\\]]+)\\]\\W*\\d*$");
    private static final Pattern ENUM_LITERAL_PATTERN = Pattern.compile("(and\\W+)?\\d+\\.\\W*\"([^\"]+)\"(\\.)?");

    ParsingUtils() {
    }

    static String toIdentifier(String name) {
        StringBuilder builder = new StringBuilder(name.trim());
        for (int i = 0; i < builder.length(); ++i) {
            char c = builder.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            builder.setCharAt(i, '_');
        }
        return builder.toString();
    }

    static String removeLinebreaks(String data) {
        return null == data ? "" : data.replace("\r\n", " ").replace("\r", " ").replace("\n", " ");
    }

    static String replaceWhitespace(String data, String replacement) {
        String result = data;
        if (data != null) {
            result = data.replace("\n", replacement).replace("\r", replacement).replace(" ", replacement);
        }
        return result;
    }

    static String removeWhitespace(String data) {
        return ParsingUtils.replaceWhitespace(data, "");
    }

    static int consumeWhitespaces(String data, int pos) {
        while (pos < data.length() && Character.isWhitespace(data.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    static int consumeNonWhitespaces(String data, int pos) {
        while (pos < data.length() && !Character.isWhitespace(data.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    static String toNullIfEmpty(String data) {
        String result = data;
        if (null != data && data.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    static String[] toLines(String data) {
        return null == data ? null : data.split("\\R");
    }

    static String removeBrackets(String data) {
        Matcher matcher;
        String result = data;
        if (data != null && (matcher = BRACKETS_WIITH_FOOTNOTE.matcher(data)).matches()) {
            result = ParsingUtils.removeWhitespace(matcher.group(1));
        }
        return result;
    }

    static String fixTypeName(String name) {
        String result = ParsingUtils.removeBrackets(name);
        int pos = name.indexOf("[");
        if (pos > 0) {
            result = name.substring(0, pos).trim();
        }
        return result;
    }

    static String getLastNoteComment(String text) {
        String result = null;
        if (text != null) {
            int pos = text.lastIndexOf("Note: ");
            result = text.substring(pos);
        }
        return result;
    }

    static boolean hasFixedIdShort(String noteComment) {
        boolean fixedIdShort = false;
        if (null != noteComment) {
            String tmp = noteComment.toLowerCase();
            if (tmp.equals("note: the above idshort shall always be as stated.")) {
                fixedIdShort = true;
            } else if (tmp.equals("note: the idshort can be chosen freely.") || tmp.startsWith("note: a different idshort might be used")) {
                fixedIdShort = false;
            } else {
                ParsingUtils.getLogger().warn("unexpected AasType idShort comment: {}", (Object)noteComment);
            }
        }
        return fixedIdShort;
    }

    static String inferEnum(String data, String description, AasField field, AasEnumResultHandler aasEnums, boolean atBeginning) {
        String result = description;
        boolean isOpen = description.matches(".*declared as.*open.*for further addition.*") || description.matches(".*usage of values that are not given.*");
        for (ParsingEnumKind kind : ParsingEnumKind.values()) {
            String[] match = kind.getMatch(data, atBeginning);
            if (null == match) continue;
            result = match[0];
            data = match[1];
            field.setValueType(ParsingUtils.inferEnum(kind, data, field.getIdShort(), field.getSemanticId(), result, aasEnums, isOpen));
        }
        return result;
    }

    static String inferEnum(ParsingEnumKind kind, String descriptionRest, String idShort, String semanticId, String description, AasEnumResultHandler aasEnums, boolean isOpen) {
        String enumName = idShort;
        if (!aasEnums.hasEnum(enumName)) {
            AasEnum en = new AasEnum(enumName);
            en.setSemanticId(semanticId);
            en.setIsOpen(isOpen);
            en.setDescription(ParsingUtils.filterLanguage(description));
            en.setParsingEnumKind(kind);
            Enumeration<Object> tokenizer = ParsingUtils.tokenizeEnumSpec(descriptionRest, kind);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextElement().toString();
                switch (kind) {
                    case ENUM: {
                        ParsingUtils.inferEnumLiteralFromToken(token, en);
                        break;
                    }
                    case ENUM_ENTRIES: {
                        ParsingUtils.inferEnumEntriesLiteralFromToken(token, en);
                        break;
                    }
                    case VALUE_LIST2: {
                        ParsingUtils.inferValueList2EntriesLiteralFromToken(token, en);
                        break;
                    }
                    case IRDIS: {
                        ParsingUtils.inferEnumIrdiLiteralsFromToken(token, en);
                        break;
                    }
                }
            }
            aasEnums.add(en);
        }
        return enumName;
    }

    private static Enumeration<Object> tokenizeEnumSpec(String text, ParsingEnumKind enumKind) {
        Vector<Object> tokens = new Vector<Object>();
        String delim = ",";
        if (ParsingEnumKind.VALUE_LIST2 == enumKind) {
            ParsingUtils.tokenizeEnumSpecValueList2(text, tokens);
        } else {
            int pos;
            int inValueSpec = 0;
            int lastPos = 0;
            for (pos = 0; pos < text.length(); ++pos) {
                char c = text.charAt(pos);
                if ('(' == c) {
                    ++inValueSpec;
                    continue;
                }
                if (')' == c) {
                    --inValueSpec;
                    continue;
                }
                if (0 != inValueSpec || text.indexOf(delim, pos) != pos) continue;
                String tok = text.substring(lastPos, pos).trim();
                if (tok.length() > 0) {
                    tokens.add(tok);
                }
                lastPos = pos += delim.length();
            }
            String tok = text.substring(lastPos, pos).trim();
            if (tok.length() > 0) {
                tokens.add(tok);
            }
        }
        return tokens.elements();
    }

    private static void tokenizeEnumSpecValueList2(String text, Vector<Object> tokens) {
        int pos = text.indexOf(61623);
        if (pos > 0) {
            StringTokenizer tk = new StringTokenizer(text, "\uf0b7");
            while (tk.hasMoreTokens()) {
                String t = tk.nextToken().trim();
                if (t.length() <= 0) continue;
                tokens.add(t + "|");
            }
        } else {
            pos = 0;
            do {
                if ((pos = text.indexOf("[", 0)) <= 0) continue;
                int pos2 = text.indexOf("]", pos);
                if (pos2 > 0) {
                    String idShort = text.substring(0, pos).trim();
                    String semId = SemanticIdRecognizer.getSemanticIdFrom((String)text.substring(pos2 + 1).trim(), (boolean)true);
                    if (null != semId) {
                        pos = text.indexOf(" ", pos + semId.length() + 1);
                        tokens.add(semId + "|" + idShort);
                        text = pos > 0 ? text.substring(pos) : text;
                        continue;
                    }
                    pos = -1;
                    continue;
                }
                pos = -1;
            } while (pos > 0);
        }
    }

    private static void inferEnumLiteralFromToken(String token, AasEnum en) {
        int brStartPos = token.indexOf("(");
        int brEndPos = token.indexOf(")");
        if (brStartPos > 0 && brStartPos < brEndPos) {
            String beforePar = token.substring(0, brStartPos);
            String beforeParPrefix = ParsingUtils.getSemanticIdPrefix(beforePar);
            String inPar = token.substring(brStartPos + 1, brEndPos);
            String[] inParParts = inPar.split(",");
            String[] inParPrefix = new String[inParParts.length];
            for (int i = 0; i < inParParts.length; ++i) {
                inParParts[i] = inParParts[i].trim();
                inParPrefix[i] = ParsingUtils.getSemanticIdPrefix(inParParts[i]);
            }
            if (null != beforeParPrefix) {
                beforePar = ParsingUtils.removeWhitespace(beforePar);
                String desc = token.substring(brStartPos + 1, brEndPos);
                String name = ParsingUtils.toLiteralName(desc);
                String identifier = null;
                int idPos = name.indexOf(" - ");
                if (idPos > 0) {
                    identifier = ParsingUtils.toIdentifier(name.substring(0, idPos));
                }
                AasEnumLiteral lit = new AasEnumLiteral(name, IdentifierType.compose((String)beforeParPrefix, (String)beforePar), desc, identifier);
                en.addLiteral(lit);
            } else if (inParParts.length == 2 && inParPrefix[1] != null) {
                AasEnumLiteral lit = new AasEnumLiteral(beforePar, IdentifierType.compose((String)inParPrefix[1].trim(), (String)inParParts[1]), "", null);
                lit.setValue(inParParts[0]);
                en.addLiteral(lit);
            } else if (inParParts.length == 1 && inParPrefix[0] != null) {
                AasEnumLiteral lit = new AasEnumLiteral(beforePar, IdentifierType.compose((String)inParPrefix[0].trim(), (String)inParParts[0]), "", null);
                en.addLiteral(lit);
            } else {
                ParsingUtils.getLogger().warn("Unknown enum literal structure: {}", (Object)token);
            }
        } else if (!token.contains(" ")) {
            AasEnumLiteral lit = new AasEnumLiteral(token, null, null, null);
            en.addLiteral(lit);
        } else {
            ParsingUtils.getLogger().warn("Unknown enum literal structure: {}", (Object)token);
        }
    }

    private static void inferValueList2EntriesLiteralFromToken(String token, AasEnum en) {
        int pos = token.indexOf("|");
        if (pos > 0) {
            String semId = token.substring(0, pos);
            String name = token.substring(pos + 1);
            String id = null;
            int spacePos = name.indexOf("  ");
            if (spacePos > 0) {
                id = name.substring(0, spacePos).trim();
                name = name.substring(spacePos + 2).trim();
            }
            en.addLiteral(new AasEnumLiteral(name, semId, null, id));
        }
    }

    private static void inferEnumIrdiLiteralsFromToken(String token, AasEnum en) {
        int pos;
        token = token.replace("\u2013", "-");
        do {
            if ((pos = token.indexOf("-")) <= 0) continue;
            String idShort = token.substring(0, pos).trim();
            String semId = SemanticIdRecognizer.getSemanticIdFrom((String)(token = token.substring(pos + 1).trim()), (boolean)false);
            if (null == semId) continue;
            token = token.substring(semId.length());
            en.addLiteral(new AasEnumLiteral(idShort, semId, null, null));
        } while (pos > 0);
    }

    private static String getSemanticIdPrefix(String text) {
        return SemanticIdRecognizer.getIdentifierPrefix((String)ParsingUtils.removeWhitespace(text));
    }

    private static void inferEnumEntriesLiteralFromToken(String token, AasEnum en) {
        String lastToken = null;
        int pos = (token = token.replace("\u201c", "\"").replace("\u201d", "\"").trim()).indexOf("\" and");
        if (pos > 0) {
            lastToken = token.substring(pos + 1);
            token = token.substring(0, pos + 1).trim();
            ParsingUtils.parseEnumEntriesLiteralFromToken(token, en);
            pos = lastToken.indexOf("\".");
            if (pos > 0) {
                lastToken = lastToken.substring(0, pos + 2).trim();
            }
            ParsingUtils.parseEnumEntriesLiteralFromToken(lastToken, en);
        } else {
            ParsingUtils.parseEnumEntriesLiteralFromToken(token, en);
        }
    }

    static String removeQuotes(String value) {
        int pos1 = value.indexOf("\u201c", 1);
        int pos2 = value.lastIndexOf("\u201d", value.length() - 2);
        if (value.startsWith("\u201c") && value.endsWith("\u201d") && pos1 < 0 && pos2 < 0) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.length() > 0 && value.charAt(0) == '\uf0b7') {
            value = value.substring(1).trim();
        }
        return value;
    }

    private static void parseEnumEntriesLiteralFromToken(String token, AasEnum en) {
        Matcher matcher = ENUM_LITERAL_PATTERN.matcher(token);
        if (matcher.matches()) {
            AasEnumLiteral lit = new AasEnumLiteral(matcher.group(2), "", "", null);
            en.addLiteral(lit);
        }
    }

    private static String toLiteralName(String description) {
        String result = description;
        int nameCutPos = description.indexOf(" ");
        for (int count = 3; nameCutPos > 0 && count >= 0; --count) {
            int nextCutPos = description.indexOf(" ", nameCutPos + 1);
            if (nextCutPos > 0) {
                nameCutPos = nextCutPos;
                continue;
            }
            nameCutPos = -1;
            break;
        }
        if (nameCutPos > 0) {
            result = description.substring(0, nameCutPos);
        }
        return result.trim();
    }

    static String filterLanguage(String description) {
        String result = description;
        if (description.contains("definition @") || description.contains("Definition @")) {
            String tmp = description.replace("preferredName @", "").replace("definition @", "@").replace("Definition @", "@");
            result = ParsingUtils.filterLanguageImpl(tmp);
        }
        if (result.equals(description)) {
            result = ParsingUtils.filterLanguageImpl(description);
        }
        return result;
    }

    private static String filterLanguageImpl(String description) {
        String result = description;
        String[] tmp = description.split("@");
        if (tmp.length > 1) {
            String en = null;
            String any = null;
            for (int i = 0; i < tmp.length; ++i) {
                int pos;
                if (tmp[i].length() <= 0 || (pos = tmp[i].indexOf(" ")) < 0 || pos > 3) continue;
                String lang = tmp[i].substring(0, pos);
                if (lang.endsWith(":")) {
                    lang = lang.substring(0, lang.length() - 1);
                }
                String desc = tmp[i].substring(pos + 1).trim();
                if ("en".equals(lang)) {
                    en = desc;
                    continue;
                }
                any = desc;
            }
            if (en != null) {
                result = en;
            } else if (any != null) {
                result = any;
            }
        }
        return result;
    }

    static boolean isGenericIdShort(String idShort) {
        boolean known = false;
        if (idShort != null) {
            known = "{arbitrary}".equals(idShort) || "{Variable}".equals(idShort) || idShort.startsWith("{Local");
            known |= idShort.startsWith("{") && idShort.endsWith("}");
            known |= ParsingUtils.removeWhitespace(idShort).equalsIgnoreCase("<noidshort>");
            known |= ParsingUtils.removeWhitespace(idShort).equalsIgnoreCase("<no_idshort>");
        }
        return known;
    }

    private static String toSemanticIdMarker(String value) {
        return "[" + value + "]";
    }

    static String[] getSemanticIdMarkers(String value) {
        ArrayList<String> result = new ArrayList<String>();
        for (String m : SEMANTICID_MARKER_WITH_PATH) {
            int pos = -(m.length() + 1);
            do {
                if ((pos = value.indexOf(m, pos + m.length() + 1)) < 0) continue;
                result.add(m);
            } while (pos >= 0);
        }
        return result.toArray(new String[result.size()]);
    }

    static int countSemanticIdMarker(String value) {
        return ParsingUtils.getSemanticIdMarkers(value).length;
    }

    static boolean hasSemanticIdMarker(String value) {
        boolean result = false;
        for (String m : SEMANTICID_MARKER) {
            if (!value.startsWith(m)) continue;
            result = true;
            break;
        }
        return result;
    }

    static String removeSuffix(String text, String suffix) {
        String result = text;
        if (text.endsWith(suffix)) {
            result = text.substring(0, text.length() - suffix.length());
        }
        return result;
    }

    static String removePrefix(String text, String prefix) {
        String result = text;
        if (text.startsWith(prefix)) {
            result = text.substring(prefix.length());
        }
        return result;
    }

    static boolean contains(String[] data, String item) {
        boolean found = false;
        for (int d = 0; !found && d < data.length; ++d) {
            found = data[d].equals(item);
        }
        return found;
    }

    static boolean isValue(String val) {
        return null != val && val.length() > 0;
    }

    static boolean isValue(Object[] val) {
        return null != val && val.length > 0;
    }

    static String stripRefBy(String type) {
        String result = type;
        if (type.startsWith("refBy(") && type.endsWith(")")) {
            result = type.substring(6, type.length() - 1);
        }
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RowProcessor.class);
    }

    static class AasEnumResultHandler {
        private List<AasEnum> enums;
        private Consumer<AasEnum> notifier;

        AasEnumResultHandler(List<AasEnum> enums) {
            this(enums, null);
        }

        AasEnumResultHandler(List<AasEnum> enums, Consumer<AasEnum> notifier) {
            this.enums = enums;
            this.notifier = notifier;
        }

        public void add(AasEnum en) {
            this.enums.add(en);
            if (null != this.notifier) {
                this.notifier.accept(en);
            }
        }

        public boolean hasEnum(String idShort) {
            return this.enums.stream().anyMatch(e -> e.getIdShort().equals(idShort));
        }
    }
}

