/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.opcua.data;

import de.iip_ecosphere.platform.configuration.opcua.data.FieldType;

public class FieldVariableType
extends FieldType {
    private String variableType;
    private boolean optional;
    private String level;
    private String rank;
    private String dimensions;

    public FieldVariableType(String nodeId, String browseName, String displayName, String description, String dataType, String variableType, boolean optional, String level, String rank, String dimensions) {
        super(nodeId, browseName, displayName, description, dataType, optional);
        this.variableType = variableType;
        this.optional = optional;
        this.level = level;
        this.rank = rank;
        this.dimensions = dimensions;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public String getLevel() {
        return this.level;
    }

    public String getRank() {
        return this.rank;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UAFieldVariableType {\n");
        builder.append("\t\t\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t\t\t" + FieldVariableType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\t\t\tnodeClass = NodeClass::UAVariable,\n");
        builder.append("\t\t\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\t\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\t\t\tdescription = \"" + this.getDescription() + "\"");
        if (!this.getDataType().equals("")) {
            if (!this.getDataType().equals("opcType")) {
                builder.append(",\n\t\t\t\ttype = refBy(" + this.getDataType() + ")");
            } else {
                builder.append(",\n\t\t\t\ttype = refBy(opcUnknownDataType)");
            }
        }
        builder.append(",\n\t\t\t\ttypeDefinition = refBy(" + this.variableType + ")");
        builder.append(",\n\t\t\t\toptional = " + this.optional);
        if (!this.level.equals("")) {
            builder.append(",\n\t\t\t\taccessLevel = " + this.level);
        }
        if (!this.rank.equals("")) {
            builder.append(",\n\t\t\t\tvalueRank = " + this.rank);
        }
        if (!this.dimensions.equals("")) {
            builder.append(",\n\t\t\t\tarrayDimensions = " + this.dimensions);
        }
        builder.append("\n");
        return builder.toString();
    }
}

