/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.opcua.data;

import de.iip_ecosphere.platform.configuration.opcua.data.FieldType;
import de.iip_ecosphere.platform.configuration.opcua.data.ObjectType;
import java.util.ArrayList;

public class RootObjectType
extends ObjectType {
    private String rootParent;

    public RootObjectType(String nodeId, String browseName, String displayName, String description, boolean optional, String type, String rootParent, ArrayList<FieldType> fields) {
        super(nodeId, browseName, displayName, description, optional, type, fields);
        this.rootParent = rootParent;
    }

    public String getRootParent() {
        return this.rootParent;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tUARootObjectType " + this.getVarName() + " = {\n");
        builder.append("\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t" + RootObjectType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\tnodeClass = NodeClass::UAObject,\n");
        builder.append("\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\tdescription = \"" + this.getDescription() + "\",\n");
        builder.append("\t\toptional = " + this.isOptional() + ",\n");
        builder.append("\t\ttypeDefinition = refBy(" + this.getType() + "),\n");
        builder.append("\t\trootParent = refBy(" + this.rootParent + "),\n");
        if (!this.getFields().isEmpty()) {
            builder.append("\t\tfields = {\n\t\t\t");
            ArrayList<FieldType> fields = this.getFields();
            for (FieldType f : fields) {
                builder.append(f.toString());
                if (f.equals(fields.get(fields.size() - 1))) {
                    builder.append("\t\t\t}\n");
                    continue;
                }
                builder.append("\t\t\t}, ");
            }
            builder.append("\t\t}\n");
        } else {
            builder.append("\t\tfields = {\n\t\t}\n");
        }
        builder.append("\t};\n\n");
        return builder.toString();
    }
}

