/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.opcua.data;

import de.iip_ecosphere.platform.configuration.opcua.data.BaseType;

public class RootVariableType
extends BaseType {
    private String dataType;
    private String variableType;
    private String level;
    private String rank;
    private String dimensions;
    private String rootParent;

    public RootVariableType(String nodeId, String browseName, String displayName, String description, String dataType, String variableType, boolean optional, String level, String rank, String dimensions, String rootParent) {
        super(nodeId, browseName, displayName, description, optional);
        this.dataType = dataType;
        this.variableType = variableType;
        this.level = level;
        this.rank = rank;
        this.dimensions = dimensions;
        this.rootParent = rootParent;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public String getLevel() {
        return this.level;
    }

    public String getRank() {
        return this.rank;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public String getRootParent() {
        return this.rootParent;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tUARootVariableType " + this.getVarName() + " = {\n");
        builder.append("\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t" + RootVariableType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\tnodeClass = NodeClass::UAVariable,\n");
        builder.append("\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\tdescription = \"" + this.getDescription() + "\",\n");
        builder.append("\t\toptional = " + this.isOptional());
        if (!this.getDataType().equals("")) {
            if (!this.getDataType().equals("opcType")) {
                builder.append(",\n\t\ttype = refBy(" + this.getDataType() + ")");
            } else {
                builder.append(",\n\t\ttype = refBy(opcUnknownDataType)");
            }
        }
        builder.append(",\n\t\ttypeDefinition = refBy(" + this.getVariableType() + ")");
        builder.append(",\n\t\trootParent = refBy(" + this.rootParent + ")");
        if (!this.level.equals("")) {
            builder.append(",\n\t\taccessLevel = " + this.level);
        }
        if (!this.rank.equals("")) {
            builder.append(",\n\t\tvalueRank = " + this.rank);
        }
        if (!this.dimensions.equals("")) {
            builder.append(",\n\t\tarrayDimensions = " + this.dimensions);
        }
        builder.append("\n");
        builder.append("\t};\n\n");
        return builder.toString();
    }
}

