/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration;

import de.uni_hildesheim.sse.easy.loader.ListLoader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.producer.core.mgmt.EasyExecutor;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class Starter {
    public static void main(String[] args) throws IOException, ModelManagementException {
        File modelFolder = new File("src/main/easy");
        File cfgFolder = new File("src/main/test");
        ListLoader loader = new ListLoader();
        loader.setVerbose(true);
        System.out.println("EASy starting");
        loader.startup();
        System.out.println("EASy started");
        ModelLocations.Location l = VarModel.INSTANCE.locations().addLocation(cfgFolder, ProgressObserver.NO_OBSERVER);
        l.addDependentLocation(VarModel.INSTANCE.locations().addLocation(modelFolder, ProgressObserver.NO_OBSERVER));
        BuildModel.INSTANCE.locations().addLocation(modelFolder, ProgressObserver.NO_OBSERVER);
        TemplateModel.INSTANCE.locations().addLocation(modelFolder, ProgressObserver.NO_OBSERVER);
        System.out.println("Location added");
        List models = VarModel.INSTANCE.availableModels().getModelInfo("IIPEcosphere");
        if (null != models && !models.isEmpty()) {
            ModelInfo prjInfo = (ModelInfo)models.get(0);
            try {
                Project prj = (Project)VarModel.INSTANCE.load(prjInfo);
                Configuration cfg = new Configuration(prj);
                ReasonerConfiguration rCfg = new ReasonerConfiguration();
                ReasoningResult rResult = ReasonerFrontend.getInstance().propagate(cfg, rCfg, ProgressObserver.NO_OBSERVER);
                System.out.println("Reasoning is ok: " + !rResult.hasConflict());
                EasyExecutor.printReasoningMessages((ReasoningResult)rResult);
                List vil = BuildModel.INSTANCE.availableModels().getModelInfo("IIPEcosphere");
                if (null != vil && !vil.isEmpty()) {
                    ModelInfo vilInfo = (ModelInfo)vil.get(0);
                    Script script = (Script)BuildModel.INSTANCE.load(vilInfo);
                    TracerFactory.setInstance((TracerFactory)ConsoleTracerFactory.INSTANCE);
                    new Executor(script).addBase(new File(".")).addSource(new File(".")).addConfiguration(cfg).addTarget(new File(".")).execute();
                }
            }
            catch (ModelManagementException e) {
                System.out.println("CANNOT READ " + prjInfo.getName() + ": " + e.getMessage());
            }
            catch (VilException e) {
                System.out.println("VIL " + prjInfo.getName() + ": " + e.getMessage());
            }
        }
        System.out.println("Removing location");
        TemplateModel.INSTANCE.locations().removeLocation(modelFolder, ProgressObserver.NO_OBSERVER);
        TemplateModel.INSTANCE.locations().removeLocation(cfgFolder, ProgressObserver.NO_OBSERVER);
        BuildModel.INSTANCE.locations().removeLocation(modelFolder, ProgressObserver.NO_OBSERVER);
        VarModel.INSTANCE.locations().removeLocation(modelFolder, ProgressObserver.NO_OBSERVER);
        System.out.println("EASy stopping");
        loader.shutdown();
        System.out.println("EASy stopped");
    }
}

