/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.aas;

import de.iip_ecosphere.platform.configuration.aas.ReadExcelFile;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class ExcelSpecTests {
    static final String RESOURCES_DIR = "src/test/resources/idta/";
    static final String TMP_OUT = FileUtils.getTempDirectoryPath() + "/idta.ivml";
    static final String TMP_TEXT = FileUtils.getTempDirectoryPath() + "/idta.text";

    private void testSpecWithXls(String fileName) throws IOException {
        this.testSpecWithXls(fileName, null);
    }

    private void testSpecWithXls(String fileName, String idShortPrefix) throws IOException {
        Charset cs = Charset.defaultCharset();
        ReadExcelFile.main((String[])new String[]{RESOURCES_DIR + fileName + ".xlsx", TMP_OUT, idShortPrefix});
        String out = FileUtils.readFileToString((File)new File(TMP_OUT), (Charset)cs);
        out = out.replaceAll("[^\\x00-\\x7F]", "");
        String spec = FileUtils.readFileToString((File)new File(RESOURCES_DIR + fileName + ".pdf.spec"), (Charset)cs);
        spec = spec.replaceAll("[^\\x00-\\x7F]", "");
        Assert.assertEquals((Object)spec, (Object)out);
        String text = FileUtils.readFileToString((File)new File(TMP_TEXT), (Charset)cs);
        Assert.assertTrue((text.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIdta02001_1_0_xls() throws IOException {
        this.testSpecWithXls("2001/IDTA 02001-1-0_Submodel_MTP.print");
    }

    @Test
    public void testIdta02002_1_0_xls() throws IOException {
        this.testSpecWithXls("2002/IDTA-02002-1-0_Submodel_ContactInformation");
    }

    @Test
    public void testIdta02003_1_2_xls() throws IOException {
        this.testSpecWithXls("2003/IDTA-02003-1-2_Submodel_TechnicalData");
    }

    @Test
    public void testIdta02004_1_2_xls() throws IOException {
        this.testSpecWithXls("2004/IDTA 02004-1-2_Submodel_Handover Documentation");
    }

    @Test
    public void testIdta02005_1_0_xls() throws IOException {
        this.testSpecWithXls("2005/IDTA 02005-1-0_Submodel_ProvisionOfSimulationModels");
    }

    @Test
    public void testIdta02006_2_0_xls() throws IOException {
        this.testSpecWithXls("2006/IDTA-02006-2-0_Submodel_Digital-Nameplate");
    }

    @Test
    public void testIdta02007_1_0_xls() throws IOException {
        this.testSpecWithXls("2007/IDTA-02007-1-0_Submodel_Software-Nameplate");
    }

    @Test
    public void testIdta02008_1_1_xls() throws IOException {
        this.testSpecWithXls("2008/IDTA 02008-1-1_Submodel_TimeSeriesData");
    }

    @Test
    public void testIdta02010_1_0_xls() throws IOException {
        this.testSpecWithXls("2010/IDTA 02010-1-0_Submodel_ServiceRequestNotification");
    }

    @Test
    public void testIdta02011_1_0_xls() throws IOException {
        this.testSpecWithXls("2011/IDTA-02011-1-0_Submodel_HierarchicalStructuresEnablingBoM");
    }

    @Test
    public void testIdta02012_1_0_xls() throws IOException {
        this.testSpecWithXls("2012/IDTA 02012-1-0_Submodel_DEXPI");
    }

    @Test
    public void testIdta02013_1_0_xls() throws IOException {
        this.testSpecWithXls("2013/IDTA 02013-1-0_Submodel_Reliability", "Ry");
    }

    @Test
    public void testIdta02014_1_0_xls() throws IOException {
        this.testSpecWithXls("2014/IDTA 02014-1-0_Submodel_FunctionalSafety", "Fs");
    }

    @Test
    public void testIdta02015_1_0_xls() throws IOException {
        this.testSpecWithXls("2015/IDTA 02015-1-0 _Submodel_ControlComponentType.print", "Ct");
    }

    @Test
    public void testIdta02016_1_0_xls() throws IOException {
        this.testSpecWithXls("2016/IDTA 02016-1-0 _Submodel_ControlComponentInstance", "Ci");
    }

    @Test
    public void testIdta02017_1_0_xls() throws IOException {
        this.testSpecWithXls("2017/IDTA 02017-1-0_Submodel_Asset Interfaces Description.mod");
    }

    @Test
    public void testIdta02021_1_0_xls() throws IOException {
        this.testSpecWithXls("2021/IDTA 02021-1-0_Submodel_Sizing of Power Drive Trains");
    }

    @Test
    public void testIdta02023_0_9_xls() throws IOException {
        this.testSpecWithXls("2023/IDTA 2023-0-9 _Submodel_CarbonFootprint");
    }

    @Test
    public void testIdtaDraft20230124_xls() throws IOException {
        this.testSpecWithXls("2023-01-24 - Draft_IDTA_Submodel_PCF-mod", "Draft");
    }

    @Test
    public void testIdta02022_1_0_xls() throws IOException {
        this.testSpecWithXls("2022/IDTA 02022-1-0_Submodel_Wireless Communication");
    }

    @Test
    public void testIdta02026_1_0_xls() throws IOException {
        this.testSpecWithXls("2026/IDTA_02026-1-0_Submodel_ProvisionOf3DModels");
    }

    @Test
    public void testIdta02027_1_0_xls() throws IOException {
        this.testSpecWithXls("2027/IDTA 02027-1-0_Submodel_AssetInterfacesMappingConfiguration");
    }

    @Test
    public void testIdta02034_1_0_xls() throws IOException {
        this.testSpecWithXls("2034/IDTA 02034-1-0 Submodel_CreationAndClassificationOfMaterial");
    }

    @Test
    public void testIdta02045_1_0_xls() throws IOException {
        this.testSpecWithXls("2045/IDTA 02045-1-0_Submodel_Data Model for Asset Location");
    }

    @Test
    public void testIdta02046_1_0_xls() throws IOException {
        this.testSpecWithXls("2046/IDTA 02046-1-0_Submodel_WorkstationWorkerMatchingData");
    }

    @Test
    public void testIdta02056_1_0_xls() throws IOException {
        this.testSpecWithXls("2056/IDTA 02056-1-0_Submodel_Data Retention Policies");
    }
}

