/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.opcua;

import de.iip_ecosphere.platform.configuration.opcua.parser.DomParser;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class DomParserTest {
    @Test
    public void testDomParserMachineTool() throws IOException {
        File in = new File("src/main/resources/NodeSets/Opc.Ua.MachineTool.NodeSet2.xml");
        Assert.assertTrue((boolean)in.exists());
        File tmp = new File("target/tmp");
        tmp.mkdirs();
        File out = new File(tmp, "OpcMachineTool.ivml");
        DomParser.setDefaultVerbose((boolean)false);
        DomParser.setUsingIvmlFolder((String)"target/tmp");
        DomParser.main((String[])new String[]{in.toString()});
        DomParser.process((File)in, (String)"MachineTool", (File)out, (boolean)false);
        Charset charset = Charset.forName("UTF-8");
        File expected = new File("src/test/resources/OpcMachineTool.ivml");
        String exContents = DomParserTest.normalize(FileUtils.readFileToString((File)expected, (Charset)charset));
        String outContents = DomParserTest.normalize(FileUtils.readFileToString((File)out, (Charset)charset));
        Assert.assertEquals((Object)exContents, (Object)outContents);
    }

    @Test
    public void testDomParserWoodworking() throws IOException {
        File in = new File("src/main/resources/NodeSets/Opc.Ua.Woodworking.NodeSet2.xml");
        Assert.assertTrue((boolean)in.exists());
        File tmp = new File("target/tmp");
        tmp.mkdirs();
        File out = new File(tmp, "OpcWoodworking.ivml");
        DomParser.setDefaultVerbose((boolean)false);
        new File("target/ivml").mkdirs();
        DomParser.setUsingIvmlFolder((String)"target/tmp");
        DomParser.process((File)in, (String)"Woodworking", (File)out, (boolean)false);
        Charset charset = Charset.forName("UTF-8");
        File expected = new File("src/test/resources/OpcWoodworking.ivml");
        String exContents = DomParserTest.normalize(FileUtils.readFileToString((File)expected, (Charset)charset));
        String outContents = DomParserTest.normalize(FileUtils.readFileToString((File)out, (Charset)charset));
        Assert.assertEquals((Object)exContents, (Object)outContents);
    }

    static void printCharDiff(String exContents, String outContents) {
        for (int i = 0; i < Math.min(exContents.length(), outContents.length()); ++i) {
            if (exContents.charAt(i) == outContents.charAt(i)) continue;
            System.out.println(exContents.charAt(i) + " " + outContents.charAt(i));
        }
    }

    private static String normalize(String text) {
        StringBuilder tmp = new StringBuilder(text);
        for (int i = 0; i < tmp.length(); ++i) {
            char c = tmp.charAt(i);
            if (c == '\u00ac') {
                tmp.setCharAt(i, '-');
                continue;
            }
            if (c == '\u2013' || c == '\ufffd') {
                tmp.setCharAt(i, '-');
                continue;
            }
            if (c == '\u2264') {
                tmp.setCharAt(i, '?');
                continue;
            }
            if (c != '\u2019' && c != '\u201e' && c != '\u201c' && c != '\u2026') continue;
            tmp.setCharAt(i, '-');
        }
        return tmp.toString();
    }
}

