/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.aas;

import de.iip_ecosphere.platform.configuration.aas.AasEnum;
import de.iip_ecosphere.platform.configuration.aas.AasEnumLiteral;
import de.iip_ecosphere.platform.configuration.aas.AasField;
import de.iip_ecosphere.platform.configuration.aas.AasImports;
import de.iip_ecosphere.platform.configuration.aas.AasSmeType;
import de.iip_ecosphere.platform.configuration.aas.AasType;
import de.iip_ecosphere.platform.configuration.aas.ParsingUtils;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AasSpecSummary {
    private Version version;
    private String projectName;
    private String versionIdentifier;
    private String specNumber;
    private String title;
    private List<AasType> types;
    private List<AasEnum> enums;

    AasSpecSummary(List<AasType> types, List<AasEnum> enums) {
        this.types = types;
        this.enums = enums;
        this.validate();
    }

    void setIdentifier(String projectName, String versionIdentifier, Version version, String title, String specNumber) {
        this.projectName = projectName;
        this.versionIdentifier = versionIdentifier;
        this.version = version;
        this.title = title;
        this.specNumber = specNumber;
    }

    private void registerType(Map<String, AasType> typeMap, Map<String, AasType> sIdTypeMap, String idShort, AasType type) {
        typeMap.put(idShort, type);
        if (type.getSemanticId() != null) {
            sIdTypeMap.put(type.getSemanticId(), type);
        }
    }

    private void validate() {
        HashMap<String, AasType> typeMap = new HashMap<String, AasType>();
        HashMap<String, AasType> sIdTypeMap = new HashMap<String, AasType>();
        HashMap<String, AasEnum> enumMap = new HashMap<String, AasEnum>();
        HashMap<String, Object> rename = new HashMap<String, Object>();
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        ArrayList<AasType> removeType = new ArrayList<AasType>();
        for (AasType t : this.types) {
            String idShort = t.getIdShort();
            if (idShort.startsWith("{")) {
                String newIdShort = idShort.replace("{", "").replace("}", "");
                rename.put(t.getSemanticId(), newIdShort);
                t.setIdShort(newIdShort);
                t.setDisplayName(idShort);
                AasSpecSummary.getLogger().info("Renamed type {} to {} for semanticId {} as no IVML identifier.", new Object[]{idShort, newIdShort, t.getSemanticId()});
                idShort = newIdShort;
            }
            if (!typeMap.containsKey(idShort)) {
                this.registerType(typeMap, sIdTypeMap, idShort, t);
                counter.put(idShort, 1);
                continue;
            }
            if (!sIdTypeMap.containsKey(t.getSemanticId())) {
                int cnt = (Integer)counter.get(idShort) + 1;
                counter.put(idShort, cnt);
                String newIdShort = idShort + "_" + cnt;
                t.setIdShort(newIdShort);
                rename.put(t.getSemanticId(), newIdShort);
                this.registerType(typeMap, sIdTypeMap, newIdShort, t);
                AasSpecSummary.getLogger().info("Renamed type {} to {} for semanticId {}.", new Object[]{idShort, newIdShort, t.getSemanticId()});
                continue;
            }
            removeType.add(t);
        }
        this.types.removeAll(removeType);
        for (AasEnum e : this.enums) {
            this.validate(e);
            enumMap.put(e.getIdShort(), e);
        }
        String imports = AasImports.importsStream().map(i -> i.getProjectName()).collect(Collectors.joining(", "));
        for (AasType t : this.types) {
            if (null == t.getSmeType()) {
                AasSpecSummary.getLogger().error("Type {} has no SME type assigned. Cannot print IVML. ", (Object)t.getIdShort());
            }
            HashSet<String> fieldIdShorts = new HashSet<String>();
            for (AasField f : t.fields()) {
                String semId;
                String idShort = f.getIdShort();
                if (null != idShort && idShort.startsWith("{")) {
                    f.setDisplayName(idShort);
                    int pos = idShort.indexOf("}");
                    if (pos > 0) {
                        idShort = idShort.substring(0, pos);
                    }
                    idShort = idShort.replace("{", "").replace("}", "");
                    semId = f.getSemanticId();
                    if (semId != null && semId.startsWith("iri:")) {
                        pos = semId.lastIndexOf(47);
                        String semIdNamePart = semId.substring(pos + 1);
                        if (pos > 0 && semIdNamePart.length() >= 3 && Character.isAlphabetic(semIdNamePart.charAt(0))) {
                            idShort = ParsingUtils.toIdentifier(semIdNamePart);
                        }
                    }
                    f.setIdShort(idShort);
                }
                this.ensureUniqueFieldName(fieldIdShorts, f);
                String ivmlValueType = f.getIvmlValueType(true);
                if (null == ivmlValueType) continue;
                ivmlValueType = ParsingUtils.stripRefBy(ivmlValueType);
                semId = f.getSemanticId();
                String renameTo = (String)rename.get(semId);
                if (null != renameTo) {
                    ivmlValueType = renameTo;
                    f.setValueType(ivmlValueType);
                    AasSpecSummary.getLogger().warn("Changed type of {}/{} to {} as type of semanticId {} was ambiguous. ", new Object[]{t.getIdShort(), f.getIdShort(), ivmlValueType, semId});
                } else {
                    String impType = AasImports.getSpecificType(semId);
                    if (null != impType) {
                        ivmlValueType = impType;
                        f.setValueType(impType);
                        AasSpecSummary.getLogger().info("Changed type of {}/{} to {} due to import for semanticId {}. ", new Object[]{t.getIdShort(), f.getIdShort(), semId});
                    }
                }
                if (AasField.isBasicType(ivmlValueType)) continue;
                boolean isType = typeMap.containsKey(ivmlValueType);
                boolean isEnum = enumMap.containsKey(ivmlValueType);
                if (isType || isEnum || AasImports.isKnownType(ivmlValueType, null)) continue;
                String impType = null;
                AasType refType = (AasType)sIdTypeMap.get(semId);
                if (null != refType) {
                    impType = refType.getIdShort();
                }
                if (null != impType) {
                    boolean diff = !f.getValueType().equals(impType);
                    f.setValueType(impType);
                    this.info(diff, "Changed type of {}/{} to {} due to declared semanticId {}. ", t.getIdShort(), f.getIdShort(), impType, semId);
                    continue;
                }
                AasSpecSummary.getLogger().warn("Value type of field {} in type {} is not defined: {}. Using generic type. Declared imports are: {}", new Object[]{f.getIdShort(), t.getIdShort(), ivmlValueType, imports});
                f.setValueType(null);
            }
        }
    }

    private void ensureUniqueFieldName(Set<String> fieldIdShorts, AasField field) {
        String idShort = field.getIdShort();
        if (!fieldIdShorts.contains(idShort)) {
            fieldIdShorts.add(idShort);
        } else {
            String lastIdShort;
            int i = 1;
            while (fieldIdShorts.contains(lastIdShort = idShort + "_" + i++)) {
            }
            field.setIdShort(lastIdShort);
        }
    }

    private void info(boolean condition, String text, Object ... args) {
        if (condition) {
            AasSpecSummary.getLogger().info(text, args);
        }
    }

    private void validate(AasEnum en) {
        int count = 1;
        for (AasEnumLiteral lit : en.literals()) {
            if (!ParsingUtils.isValue(lit.getIdShort())) {
                Object idShort = "VALUE_" + count;
                if (ParsingUtils.isValue(lit.getIdentifier())) {
                    idShort = lit.getIdentifier();
                } else if (ParsingUtils.isValue(lit.getDisplayName())) {
                    idShort = ParsingUtils.toIdentifier(lit.getDisplayName());
                } else if (ParsingUtils.isValue(lit.getValueId())) {
                    idShort = ParsingUtils.toIdentifier(lit.getValueId());
                }
                lit.setIdShort((String)idShort);
            }
            ++count;
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public String getTitle() {
        return this.title;
    }

    public int getTypesCount() {
        return this.types.size();
    }

    public Optional<AasType> getMainSubmodel() {
        return this.types.stream().filter(t -> t.getSmeType() == AasSmeType.SUBMODEL).findFirst();
    }

    public Iterable<AasType> types() {
        return this.types;
    }

    public Iterable<AasEnum> enums() {
        return this.enums;
    }

    public String getSpecNumber() {
        return this.specNumber;
    }

    public void printStatistics(PrintStream out) {
        int fields = 0;
        int ops = 0;
        for (AasType t : this.types) {
            fields += t.getFieldsCount();
            ops += t.getOperationsCount();
        }
        out.println("Statistics: " + this.title);
        out.println(" - types: " + this.types.size());
        out.println(" - fields: " + fields);
        out.println(" - operations: " + ops);
        out.println(" - enums: " + this.enums.size());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AasSpecSummary.class);
    }
}

