/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ivml.DecisionVariableProvider;
import de.iip_ecosphere.platform.configuration.ivml.DefaultEdge;
import de.iip_ecosphere.platform.configuration.ivml.DefaultGraph;
import de.iip_ecosphere.platform.configuration.ivml.DefaultNode;
import de.iip_ecosphere.platform.configuration.ivml.GraphFactory;
import de.iip_ecosphere.platform.configuration.ivml.IvmlGraphMapper;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import org.junit.Assert;

public class AbstractGraphTest {
    protected static final GraphFactory FACTORY = new GraphFactory(){

        public IvmlGraphMapper.IvmlGraph createGraph(IDecisionVariable var) {
            return new TestGraph();
        }

        public IvmlGraphMapper.IvmlGraphEdge createEdge(IDecisionVariable var, IvmlGraphMapper.IvmlGraphNode start, IvmlGraphMapper.IvmlGraphNode end) {
            return new TestEdge(start, end);
        }

        public IvmlGraphMapper.IvmlGraphNode createNode(IDecisionVariable var) {
            return new TestNode();
        }
    };
    protected static final DecisionVariableProvider VAR_PROVIDER = new DecisionVariableProvider(){

        public IDecisionVariable getVariable(String varName) throws ExecutionException {
            return null;
        }
    };

    public static IvmlGraphMapper.IvmlGraph createAbcGraph() {
        TestGraph result = new TestGraph();
        result.setName("ABC graph");
        TestNode nodeA = new TestNode();
        nodeA.setName("Node A");
        result.addNode((IvmlGraphMapper.IvmlGraphNode)nodeA);
        TestNode nodeB = new TestNode();
        nodeB.setName("Node B");
        result.addNode((IvmlGraphMapper.IvmlGraphNode)nodeB);
        TestNode nodeC = new TestNode();
        nodeC.setName("Node C");
        result.addNode((IvmlGraphMapper.IvmlGraphNode)nodeC);
        TestEdge edgeAB = new TestEdge((IvmlGraphMapper.IvmlGraphNode)nodeA, (IvmlGraphMapper.IvmlGraphNode)nodeB);
        edgeAB.setName("Edge A-B");
        nodeA.addEdge((IvmlGraphMapper.IvmlGraphEdge)edgeAB);
        nodeB.addEdge((IvmlGraphMapper.IvmlGraphEdge)edgeAB);
        TestEdge edgeBC = new TestEdge((IvmlGraphMapper.IvmlGraphNode)nodeB, (IvmlGraphMapper.IvmlGraphNode)nodeC);
        edgeBC.setName("Edge B-C");
        nodeB.addEdge((IvmlGraphMapper.IvmlGraphEdge)edgeBC);
        nodeC.addEdge((IvmlGraphMapper.IvmlGraphEdge)edgeBC);
        TestEdge edgeAC = new TestEdge((IvmlGraphMapper.IvmlGraphNode)nodeA, (IvmlGraphMapper.IvmlGraphNode)nodeC);
        edgeAC.setName("Edge A-C");
        nodeA.addEdge((IvmlGraphMapper.IvmlGraphEdge)edgeAC);
        nodeC.addEdge((IvmlGraphMapper.IvmlGraphEdge)edgeAC);
        return result;
    }

    public static IvmlGraphMapper.IvmlGraph createEmptyGraph() {
        TestGraph result = new TestGraph();
        result.setName("empty");
        return result;
    }

    public static void assertGraph(IvmlGraphMapper.IvmlGraph expected, IvmlGraphMapper.IvmlGraph actual) {
        Assert.assertEquals((long)expected.getNodeCount(), (long)actual.getNodeCount());
        HashMap<String, IvmlGraphMapper.IvmlGraphNode> nodes = new HashMap<String, IvmlGraphMapper.IvmlGraphNode>();
        for (IvmlGraphMapper.IvmlGraphNode node : expected.nodes()) {
            nodes.put(node.getName(), node);
        }
        for (IvmlGraphMapper.IvmlGraphNode node : actual.nodes()) {
            IvmlGraphMapper.IvmlGraphNode eNode = (IvmlGraphMapper.IvmlGraphNode)nodes.get(node.getName());
            Assert.assertNotNull((Object)eNode);
            Assert.assertEquals((long)eNode.getYPos(), (long)node.getYPos());
            Assert.assertEquals((long)eNode.getXPos(), (long)node.getXPos());
            Assert.assertEquals((long)eNode.getWidth(), (long)node.getWidth());
            Assert.assertEquals((long)eNode.getHeight(), (long)node.getHeight());
            Assert.assertEquals((long)eNode.getInEdgesCount(), (long)node.getInEdgesCount());
            Assert.assertEquals((long)eNode.getOutEdgesCount(), (long)node.getOutEdgesCount());
            AbstractGraphTest.assertEdges(eNode.inEdges(), node.inEdges());
            AbstractGraphTest.assertEdges(eNode.outEdges(), node.outEdges());
            nodes.remove(node.getName());
        }
        Assert.assertEquals((long)0L, (long)nodes.size());
    }

    private static void assertEdges(Iterable<? extends IvmlGraphMapper.IvmlGraphEdge> expected, Iterable<? extends IvmlGraphMapper.IvmlGraphEdge> actual) {
        String id;
        HashMap<CallSite, IvmlGraphMapper.IvmlGraphEdge> edges = new HashMap<CallSite, IvmlGraphMapper.IvmlGraphEdge>();
        for (IvmlGraphMapper.IvmlGraphEdge ivmlGraphEdge : expected) {
            id = ivmlGraphEdge.getStart().getName() + "|" + ivmlGraphEdge.getEnd().getName();
            edges.put((CallSite)((Object)id), ivmlGraphEdge);
        }
        for (IvmlGraphMapper.IvmlGraphEdge ivmlGraphEdge : actual) {
            id = ivmlGraphEdge.getStart().getName() + "|" + ivmlGraphEdge.getEnd().getName();
            IvmlGraphMapper.IvmlGraphEdge eEdge = (IvmlGraphMapper.IvmlGraphEdge)edges.get(id);
            Assert.assertNotNull((Object)eEdge);
            Assert.assertEquals((Object)ivmlGraphEdge.getStart().getName(), (Object)eEdge.getStart().getName());
            Assert.assertEquals((Object)ivmlGraphEdge.getEnd().getName(), (Object)eEdge.getEnd().getName());
            edges.remove(id);
        }
        Assert.assertEquals((long)0L, (long)edges.size());
    }

    public static class TestGraph
    extends DefaultGraph {
        private String name;

        public TestGraph() {
            super(null);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class TestNode
    extends DefaultNode {
        private String name;
        private int xPos = 0;
        private int yPos = 0;
        private int width = -1;
        private int height = -1;

        public TestNode() {
            super(null);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getXPos() {
            return this.xPos;
        }

        public int getYPos() {
            return this.yPos;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setXPos(int xPos) {
            this.xPos = xPos;
        }

        public void setYPos(int yPos) {
            this.yPos = yPos;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }

    public static class TestEdge
    extends DefaultEdge {
        private String name;

        public TestEdge(IvmlGraphMapper.IvmlGraphNode start, IvmlGraphMapper.IvmlGraphNode end) {
            super(null, start, end);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

