/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.PlatformInstantiatorExecutor;
import de.iip_ecosphere.platform.support.OsUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.Assume;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.AbstractIvmlTests;

public class IvmlContainerLxcTests
extends AbstractIvmlTests {
    @Test
    public void testContainerTest() throws ExecutionException, IOException {
        boolean winAndLxcDisabled = false;
        boolean uxAndHomeOk = false;
        if (OsUtils.isWindows()) {
            if (Boolean.valueOf(System.getProperty("easy.lxc.failOnError", "true")).booleanValue()) {
                System.out.println("LXC does not support Windows. This test can run without container create if -Deasy.lxc.failOnError=false.");
            } else {
                winAndLxcDisabled = true;
            }
        } else if (OsUtils.getUserHome().startsWith("/home/")) {
            uxAndHomeOk = true;
        } else {
            System.out.println("LXC runs on linx only if the user home is in /home/");
        }
        Assume.assumeTrue((boolean)(winAndLxcDisabled | uxAndHomeOk));
        File gen = new File(TEST_BASE_FOLDER, "ContainerCreationLxc");
        PlatformInstantiatorExecutor.instantiate((PlatformInstantiator.InstantiationConfigurer)new AbstractIvmlTests.TestConfigurer("ContainerCreationLxc", new File(MODEL_BASE_FOLDER, "single"), gen));
        IvmlContainerLxcTests.assertAllFiles(gen);
        IvmlContainerLxcTests.assertTemplateZip(gen, "impl.SimpleMeshTestingContainerApp");
    }
}

