/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ConfigurationLifecycleDescriptor;
import de.iip_ecosphere.platform.configuration.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.DrawflowGraphFormat;
import de.iip_ecosphere.platform.configuration.EasySetup;
import de.iip_ecosphere.platform.configuration.ivml.AasIvmlMapper;
import de.iip_ecosphere.platform.configuration.ivml.GraphFormat;
import de.iip_ecosphere.platform.configuration.ivml.IvmlGraphMapper;
import de.iip_ecosphere.platform.configuration.serviceMesh.ServiceMeshGraphMapper;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class TestAasIvmlModel {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("CfgModelName cfgFolder [meshVariables*]");
        } else {
            TestWithPlugin.loadPlugins();
            EasySetup ep = ConfigurationSetup.getSetup().getEasyProducer();
            File modelFolder = new File("src/main/easy");
            File cfgFolder = new File(args[1]);
            ep.setBase(modelFolder);
            ep.setIvmlMetaModelFolder(modelFolder);
            ep.setIvmlConfigFolder(cfgFolder);
            ep.setIvmlModelName(args[0]);
            File commonFolder = new File(cfgFolder.getParent(), "common");
            if (commonFolder.exists()) {
                ep.setAdditionalIvmlFolders(CollectionUtils.toList((Object[])new File[]{commonFolder}));
            }
            ConfigurationLifecycleDescriptor lc = new ConfigurationLifecycleDescriptor();
            lc.startup(new String[0]);
            ReasoningResult rRes = ConfigurationManager.validateAndPropagate();
            if (null == rRes) {
                System.out.println("No model loaded");
                System.exit(1);
            }
            Configuration cfg = ConfigurationManager.getVilConfiguration();
            DrawflowGraphFormat format = new DrawflowGraphFormat();
            AasIvmlMapper mapper = new AasIvmlMapper(() -> cfg, (IvmlGraphMapper)new ServiceMeshGraphMapper(), null);
            mapper.addGraphFormat((GraphFormat)format);
            ConfigurationManager.setAasIvmlMapper((AasIvmlMapper)mapper);
            AasPartRegistry.AasSetup aasSetup = AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false);
            AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)aasSetup);
            ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
            Endpoint regEndpoint = aasSetup.adaptEndpoint(aasSetup.getRegistryEndpoint());
            System.out.println("ServerHost " + aasSetup.getServerHost() + " " + regEndpoint.toUri());
            ServerRecipe.LocalPersistenceType pType = ServerRecipe.LocalPersistenceType.INMEMORY;
            System.out.println("Starting " + String.valueOf(pType) + " AAS registry on " + regEndpoint.toUri());
            Server registryServer = rcp.createRegistryServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)pType, new String[0]);
            registryServer.start();
            Endpoint serverEndpoint = aasSetup.adaptEndpoint(aasSetup.getServerEndpoint());
            System.out.println("ServerHost " + aasSetup.getServerHost() + " " + serverEndpoint.toUri());
            System.out.println("Starting " + String.valueOf(pType) + " AAS server on " + serverEndpoint.toUri());
            AasServer aasServer = rcp.createAasServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)pType, new String[0]);
            aasServer.start();
            AasFactory aasFactory = AasFactory.getInstance();
            Aas.AasBuilder aasBuilder = aasFactory.createAasBuilder("Platform", null);
            Submodel.SubmodelBuilder smb = AasPartRegistry.createSubmodelBuilder((Aas.AasBuilder)aasBuilder, (String)"Configuration");
            InvocablesCreator iCreator = aasFactory.createInvocablesCreator((SetupSpec)aasSetup);
            ProtocolServerBuilder psb = aasFactory.createProtocolServerBuilder((SetupSpec)aasSetup);
            mapper.mapByType(smb, iCreator);
            mapper.bindOperations(psb);
            smb.build();
            Aas aas = (Aas)aasBuilder.build();
            aas.accept((AasVisitor)new AasPrintVisitor());
            Server implServer = ((Server)psb.build()).start();
            try {
                AasPartRegistry.remoteDeploy((List)CollectionUtils.toList((Object[])new Aas[]{aas}));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 2; i < args.length; ++i) {
                try {
                    System.out.println("Graph " + args[i] + ":");
                    System.out.println(mapper.getGraph(args[i], format.getName()));
                    continue;
                }
                catch (ExecutionException e) {
                    System.out.println("ERROR: " + e.getMessage());
                }
            }
            implServer.stop(false);
            aasServer.stop(true);
            registryServer.stop(true);
            lc.shutdown();
        }
    }
}

