/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.aas;

import de.iip_ecosphere.platform.configuration.aas.ReadAasxFile;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.aas.ExcelSpecTests;

public class AasxSpecTests {
    private void testSpecWithAasx(String fileName) throws IOException {
        this.testSpecWithAasx(fileName, null);
    }

    private void testSpecWithAasx(String fileName, String idShortPrefix) throws IOException {
        Charset cs = Charset.defaultCharset();
        String specNumber = ReadAasxFile.getSpecNumber((String)fileName);
        ReadAasxFile.main((String[])new String[]{"src/test/resources/idta/" + fileName + ".aasx", ExcelSpecTests.TMP_OUT, specNumber, idShortPrefix});
        String out = FileUtils.readFileToString((File)new File(ExcelSpecTests.TMP_OUT), (Charset)cs);
        out = out.replaceAll("[^\\x00-\\x7F]", "");
        String spec = FileUtils.readFileToString((File)new File("src/test/resources/idta/" + fileName + ".aasx.spec"), (Charset)cs);
        spec = spec.replaceAll("[^\\x00-\\x7F]", "");
        Assert.assertEquals((Object)spec, (Object)out);
        String text = FileUtils.readFileToString((File)new File(ExcelSpecTests.TMP_TEXT), (Charset)cs);
        Assert.assertTrue((text.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIdta02001_1_0() throws IOException {
        this.testSpecWithAasx("2001/IDTA 02001-1-0_Subomdel_MTPv1.0-rc2-with-documentation");
    }

    @Test
    public void testIdta02002_1_0() throws IOException {
        this.testSpecWithAasx("2002/IDTA 02002-1-0_Template_ContactInformation");
    }

    @Test
    public void testIdta02003_1_2() throws IOException {
        this.testSpecWithAasx("2003/IDTA 02003-1-2_SubmodelTemplate_TechnicalData_v1.2_withQualifier");
    }

    @Test
    public void testIdta02004_1_2() throws IOException {
        this.testSpecWithAasx("2004/IDTA 02004-1-2_Template_Handover Documentation");
    }

    @Test
    public void testIdta02005_1_0() throws IOException {
        this.testSpecWithAasx("2005/IDTA 02005-1-0_Template_ProvisionOfSimulationModels");
    }

    @Test
    public void testIdta02006_2_0() throws IOException {
        this.testSpecWithAasx("2006/IDTA 02006-2-0_Template_Digital Nameplate");
    }

    @Test
    public void testIdta02007_1_0() throws IOException {
        this.testSpecWithAasx("2007/IDTA 02007-1-0_Template_Software Nameplate");
    }

    @Test
    public void testIdta02008_1_1() throws IOException {
        this.testSpecWithAasx("2008/IDTA 02008-1-1_Template_withOperations_TimeSeriesData");
    }

    @Test
    public void testIdta02010_1_0() throws IOException {
        this.testSpecWithAasx("2010/IDTA 02010-1-0_Template_ServiceRequestNotification");
    }

    @Test
    public void testIdta02011_1_0() throws IOException {
        this.testSpecWithAasx("2011/IDTA 02011-1-0_Template_HierarchicalStructuresEnablingBoM");
    }

    @Test
    public void testIdta02012_1_0() throws IOException {
        this.testSpecWithAasx("2012/IDTA 02012-1-0_Template_DEXPI");
    }

    @Test
    public void testIdta02013_1_0() throws IOException {
        this.testSpecWithAasx("2013/IDTA 02013-1-0_Template_Reliability", "Ry");
    }

    @Test
    public void testIdta02014_1_0() throws IOException {
        this.testSpecWithAasx("2014/IDTA 02014-1-0_Template_FunctionalSafety", "Fs");
    }

    @Test
    public void testIdta02015_1_0() throws IOException {
        this.testSpecWithAasx("2015/IDTA 02015-1-0 _Template_ControlComponentType", "Ct");
    }

    @Test
    public void testIdta02016_1_0() throws IOException {
        this.testSpecWithAasx("2016/IDTA 02016-1-0 _Template_ControlComponentInstance", "Ci");
    }

    @Test
    public void testIdta02017_1_0() throws IOException {
        this.testSpecWithAasx("2017/IDTA 02017-1-0_Template_Asset Interfaces Description");
    }

    @Test
    public void testIdta02021_1_0() throws IOException {
        this.testSpecWithAasx("2021/IDTA 02021-1-0_Template_Sizing of Power Drive Trains");
    }

    @Test
    public void testIdta02023_0_9() throws IOException {
        this.testSpecWithAasx("2023/IDTA 2023-0-9 _Template_CarbonFootprint");
    }
}

