/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ConfigurationLifecycleDescriptor;
import de.iip_ecosphere.platform.configuration.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.EasySetup;
import de.iip_ecosphere.platform.configuration.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.ivml.IvmlGraphMapper;
import de.iip_ecosphere.platform.configuration.ivml.IvmlUtils;
import de.iip_ecosphere.platform.configuration.serviceMesh.ServiceMeshGraphMapper;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.iip_aas.IipVersion;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.FolderClasspathPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import de.iip_ecosphere.platform.support.resources.MavenResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.Value;

public class IvmlDashboardMapper {
    private File projectFolder;
    private AasFactory factory;
    private Map<String, Object> unitMapping;
    private String targetMapping = "grafana";
    private List<DisplayRow> displayRows;
    private transient String appName;
    private transient String appId;
    private transient String appVersion;
    private transient int panelCount;
    private transient IDatatype aliasType;

    public IvmlDashboardMapper(AasFactory factory, File projectFolder) {
        this.projectFolder = projectFolder;
        this.factory = factory;
        try {
            this.unitMapping = Yaml.getInstance().loadMapping(ResourceLoader.getResourceAsStream((String)"semanticIdDashboard.yml", (ResourceResolver[])new ResourceResolver[0]));
            Object tmp = this.unitMapping.get(this.targetMapping);
            if (tmp instanceof Map) {
                this.unitMapping = (Map)tmp;
            }
        }
        catch (IOException e) {
            this.unitMapping = new HashMap<String, Object>();
            IvmlDashboardMapper.getLogger().error("Cannot load unit mapping: {}", (Object)e.getMessage());
        }
    }

    private void clear() {
        this.appName = null;
        this.appId = null;
        this.appVersion = null;
        this.panelCount = 1;
    }

    public void process(Configuration cfg, Aas aas, ResultConsumer consumer) throws ModelQueryException, ExecutionException {
        Project prj = cfg.getConfiguration().getProject();
        IDatatype applicationType = ModelQuery.findType((IResolutionScope)prj, (String)"Application", null);
        this.aliasType = ModelQuery.findType((IResolutionScope)prj, (String)"AliasType", null);
        for (IDecisionVariable var : cfg.getConfiguration()) {
            IDatatype type = var.getDeclaration().getType();
            if (!applicationType.isAssignableFrom(type) || IvmlUtils.isTemplate(var.getDeclaration())) continue;
            this.clear();
            Aas appAas = null == aas ? (Aas)this.factory.createAasBuilder("TestApplication", null).build() : aas;
            Submodel.SubmodelBuilder smB = appAas.createSubmodelBuilder("dashboardSpec", null);
            this.appName = IvmlUtils.getStringValue(var, "name", "");
            this.appId = IvmlUtils.getStringValue(var, "id", "");
            this.appVersion = IvmlUtils.getStringValue(var, "ver", "");
            if (IvmlDashboardMapper.isNotBlank(this.appVersion) && IvmlUtils.getBooleanValue(var.getNestedElement("snapshot"), true)) {
                this.appVersion = this.appVersion + "-SNAPSHOT";
            }
            this.displayRows = this.collectDisplayRows(var.getNestedElement("displayRows"));
            this.createHeader(smB);
            this.createDisplayRows(smB);
            SubmodelElementCollection.SubmodelElementCollectionBuilder dashboardB = this.createDashboardSpec(smB);
            SubmodelElementCollection.SubmodelElementCollectionBuilder panelsB = dashboardB.createSubmodelElementCollectionBuilder("panels");
            SubmodelElementCollection.SubmodelElementCollectionBuilder dbB = dashboardB.createSubmodelElementCollectionBuilder("db");
            HashMap<String, String> dbMapping = new HashMap<String, String>();
            IDecisionVariable meshes = var.getNestedElement("services");
            if (null != meshes) {
                ServiceMeshGraphMapper mapper = new ServiceMeshGraphMapper();
                for (int n = 0; n < meshes.getNestedElementsCount(); ++n) {
                    IDecisionVariable mesh = Configuration.dereference((IDecisionVariable)meshes.getNestedElement(n));
                    IvmlGraphMapper.IvmlGraph graph = mapper.getGraphFor(mesh);
                    for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : graph.nodes()) {
                        this.processNode(ivmlGraphNode, panelsB, dbB, dbMapping);
                    }
                }
            }
            panelsB.build();
            dbB.build();
            dashboardB.build();
            Submodel submodel = (Submodel)smB.build();
            if (null == consumer) continue;
            consumer.consume(appAas, submodel, this.appId);
        }
    }

    private List<DisplayRow> collectDisplayRows(IDecisionVariable var) {
        ArrayList<DisplayRow> result = new ArrayList<DisplayRow>();
        if (null != var) {
            for (int e = 0; e < var.getNestedElementsCount(); ++e) {
                IDecisionVariable element = IvmlUtils.dereference(var.getNestedElement(e));
                String name = IvmlUtils.getStringValue(element, "name", "");
                if (name.length() <= 0) continue;
                DisplayRow row = new DisplayRow();
                result.add(row);
                row.name = name;
                row.displayName = IvmlUtils.getStringValue(element, "displayName", null);
                row.id = this.factory.fixId("row_" + result.size());
            }
        }
        return result;
    }

    private static boolean isNotBlank(CharSequence text) {
        return !IvmlDashboardMapper.isBlank(text);
    }

    private static boolean isBlank(CharSequence text) {
        return null == text || text.length() == 0;
    }

    private void createHeader(Submodel.SubmodelBuilder smB) {
        this.createProperty((SubmodelElementContainerBuilder)smB, "oktoVersion", Type.STRING, IipVersion.getInstance().getVersionInfo(), "oktoflow version");
        this.createProperty((SubmodelElementContainerBuilder)smB, "name", Type.STRING, this.appName, "application name");
        this.createProperty((SubmodelElementContainerBuilder)smB, "id", Type.STRING, this.appId, "application id");
        this.createProperty((SubmodelElementContainerBuilder)smB, "version", Type.STRING, this.appVersion, "application version");
        this.createProperty((SubmodelElementContainerBuilder)smB, "aasMetamodelVersion", Type.STRING, this.factory.getMetaModelVersion(), "AAS metamodel version");
    }

    private void createDisplayRows(Submodel.SubmodelBuilder smB) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder rowsB = smB.createSubmodelElementCollectionBuilder("Rows");
        for (DisplayRow row : this.displayRows) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder rowB = rowsB.createSubmodelElementCollectionBuilder(row.id);
            this.createProperty((SubmodelElementContainerBuilder)rowB, "id", Type.STRING, row.id, "Unique id of display row");
            this.createProperty((SubmodelElementContainerBuilder)rowB, "name", Type.STRING, row.name, "Name of display row");
            this.createProperty((SubmodelElementContainerBuilder)rowB, "displayName", Type.STRING, row.displayName, "Display name of display row");
            rowB.build();
        }
        rowsB.build();
    }

    private SubmodelElementCollection.SubmodelElementCollectionBuilder createDashboardSpec(Submodel.SubmodelBuilder smB) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder dashboardB = smB.createSubmodelElementCollectionBuilder("Dashboard");
        this.createProperty((SubmodelElementContainerBuilder)dashboardB, "title", Type.STRING, this.appName, "application name");
        this.createProperty((SubmodelElementContainerBuilder)dashboardB, "uid", Type.STRING, this.appId, "application UID");
        SubmodelElementCollection.SubmodelElementCollectionBuilder tagsB = dashboardB.createSubmodelElementCollectionBuilder("tags");
        tagsB.build();
        return dashboardB;
    }

    private void processNode(IvmlGraphMapper.IvmlGraphNode node, SubmodelElementCollection.SubmodelElementCollectionBuilder panelsB, SubmodelElementCollection.SubmodelElementCollectionBuilder dbsB, Map<String, String> dbMapping) {
        IDecisionVariable var = node.getVariable();
        IDecisionVariable impl = Configuration.dereference((IDecisionVariable)var.getNestedElement("impl"));
        if (null != impl && IvmlUtils.isOfCompoundType(impl, "InfluxConnector")) {
            IDecisionVariable inputVar;
            ConnectorInfo connInfo = this.resolveConnector(impl);
            String influxDb = dbMapping.get(connInfo.name);
            if (null == influxDb) {
                influxDb = this.processDb(impl, connInfo, dbsB);
                dbMapping.put(connInfo.name, influxDb);
            }
            if (null != (inputVar = impl.getNestedElement("input")) && inputVar.getNestedElementsCount() > 0) {
                IDecisionVariable ioTypeVar = inputVar.getNestedElement(0);
                IDecisionVariable typeVar = Configuration.dereference((IDecisionVariable)ioTypeVar.getNestedElement("type"));
                this.processType(this.resolveType(typeVar), connInfo, panelsB, influxDb);
            }
        }
    }

    private String processDb(IDecisionVariable impl, ConnectorInfo connInfo, SubmodelElementCollection.SubmodelElementCollectionBuilder dbsB) {
        String uid = this.factory.fixId(connInfo.name.replace(" ", "_"));
        SubmodelElementCollection.SubmodelElementCollectionBuilder dbB = dbsB.createSubmodelElementCollectionBuilder(uid);
        this.createProperty((SubmodelElementContainerBuilder)dbB, "uid", Type.STRING, uid, "InfluxDB uid");
        if (IvmlDashboardMapper.isNotBlank(connInfo.host)) {
            String path;
            Object url = connInfo.security != null && connInfo.security.ssl ? "https" : "http";
            url = (String)url + "//:" + connInfo.host;
            if (connInfo.port > 0) {
                url = (String)url + ":" + connInfo.port;
            }
            if (IvmlDashboardMapper.isNotBlank(path = IvmlUtils.getStringValue(impl, "urlPath", null))) {
                url = (String)url + "/" + path;
            }
            this.createProperty((SubmodelElementContainerBuilder)dbB, "url", Type.STRING, url, "InfluxDB URL");
        }
        this.createProperty((SubmodelElementContainerBuilder)dbB, "organization", Type.STRING, connInfo.organization, "InfluxDB organization");
        ResourceLoader.registerResourceResolver((ResourceResolver)new MavenResourceResolver(this.projectFolder));
        if (connInfo.security != null && IvmlDashboardMapper.isNotBlank(connInfo.security.authenticationKey)) {
            String authKey = connInfo.security.authenticationKey;
            if (connInfo.security.enableTokenExport) {
                IdentityStore store = IdentityStore.getInstance();
                String token = "";
                IdentityToken tok = store.getToken(authKey, new String[0]);
                if (null != tok) {
                    switch (tok.getType()) {
                        case ISSUED: 
                        case USERNAME: {
                            token = tok.getTokenDataAsString();
                            break;
                        }
                        default: {
                            IvmlDashboardMapper.getLogger().warn("Cannot process token of type {} for authentication key {}", (Object)tok.getType(), (Object)authKey);
                            break;
                        }
                    }
                } else {
                    IvmlDashboardMapper.getLogger().warn("No authentication token for authentication key {}", (Object)authKey);
                }
                this.createProperty((SubmodelElementContainerBuilder)dbB, "token", Type.STRING, token, "InfluxDB token");
            } else {
                IvmlDashboardMapper.getLogger().warn("No permission to export authentication token for authentication key {}", (Object)authKey);
            }
        }
        dbB.build();
        return uid;
    }

    private ConnectorInfo resolveConnector(IDecisionVariable var) {
        ConnectorInfo result = null;
        if (null != var) {
            result = new ConnectorInfo();
            String fallbackPanelName = "panel " + this.panelCount++;
            result.id = IvmlUtils.getStringValue(var, "id", fallbackPanelName);
            result.name = IvmlUtils.getStringValue(var, "name", fallbackPanelName);
            result.organization = IvmlUtils.getStringValue(var, "organization", "");
            result.bucket = IvmlUtils.getStringValue(var, "bucket", "");
            result.measurement = IvmlUtils.getStringValue(var, "measurement", "");
            result.host = IvmlUtils.getStringValue(var, "host", null);
            result.port = IvmlUtils.getIntValue(var, "port", -1);
            IDecisionVariable security = var.getNestedElement("security");
            if (null != security) {
                SecuritySettings sec = new SecuritySettings();
                sec.ssl = IvmlUtils.getBooleanValue(var, "ssl", false);
                sec.authenticationKey = IvmlUtils.getStringValue(security, "authenticationKey", null);
                sec.enableTokenExport = IvmlUtils.getBooleanValue(security, "enableTokenExport", false);
                sec.keystoreKey = IvmlUtils.getStringValue(security, "keystoreKey", null);
                sec.keyAlias = IvmlUtils.getStringValue(security, "keyAlias", null);
                sec.idStoreAuthenticationPrefix = IvmlUtils.getStringValue(security, "idStoreAuthenticationPrefix", null);
                result.security = sec;
            }
        }
        return result;
    }

    private String getSemanticId(IDecisionVariable var, String semanticId) {
        if (semanticId == null) {
            semanticId = IvmlUtils.getStringValue(var, "semanticId", semanticId);
        }
        return semanticId;
    }

    private RecordType resolveType(IDecisionVariable var) {
        RecordType result = null;
        if (null != var && var != null) {
            result = new RecordType();
            result.name = IvmlUtils.getStringValue(var, "name", "");
            IDecisionVariable recordIter = var;
            while (recordIter != null && !recordIter.hasNullValue()) {
                IDecisionVariable fields = recordIter.getNestedElement("fields");
                for (int f = 0; f < fields.getNestedElementsCount(); ++f) {
                    Optional<DisplayRow> dr;
                    IDecisionVariable fieldVar = fields.getNestedElement(f);
                    Field fld = new Field();
                    fld.name = IvmlUtils.getStringValue(fieldVar, "name", "");
                    fld.field = IvmlUtils.getStringValue(fieldVar, "mappedName", fld.name);
                    fld.description = IvmlUtils.getStringValue(fieldVar, "description", "");
                    fld.displayName = IvmlUtils.getStringValue(fieldVar, "displayName", "");
                    fld.unit = this.resolveSemanticIdToUnit(fieldVar);
                    fld.panelType = this.resolvePanelType(fieldVar);
                    IDecisionVariable displayRow = IvmlUtils.dereference(fieldVar.getNestedElement("displayRow"));
                    String displayRowName = IvmlUtils.getStringValue(displayRow, "name", null);
                    if (displayRowName != null && (dr = this.displayRows.stream().filter(r -> r.name.equals(displayRowName)).findFirst()).isPresent()) {
                        fld.displayRow = dr.get();
                    }
                    result.fields.add(fld);
                }
                recordIter = Configuration.dereference((IDecisionVariable)recordIter.getNestedElement("refining"));
            }
        }
        return result;
    }

    private String resolvePanelType(IDecisionVariable var) {
        Object tmp;
        Value val;
        String displayValue = null;
        IDecisionVariable displayVar = var.getNestedElement("display");
        if (null != displayVar && (val = displayVar.getValue()) instanceof EnumValue) {
            displayValue = ((EnumValue)val).getValue().getName();
        }
        if (displayValue != null && null != (tmp = this.unitMapping.get("Display_" + displayValue))) {
            displayValue = tmp.toString();
        }
        return displayValue;
    }

    private String mapSemanticIdToUnit(String semId) {
        String result = semId;
        if (null != result) {
            Object tmp = this.unitMapping.get(result);
            result = null == tmp ? null : tmp.toString();
        }
        return result;
    }

    private String resolveSemanticIdToUnit(IDecisionVariable var) {
        String semanticId = this.getSemanticId(var, null);
        IDecisionVariable type = Configuration.dereference((IDecisionVariable)var.getNestedElement("type"));
        while (this.aliasType.isAssignableFrom(type.getDeclaration().getType())) {
            semanticId = this.getSemanticId(type, semanticId);
            type = Configuration.dereference((IDecisionVariable)type.getNestedElement("represents"));
        }
        String result = semanticId;
        if (null != result) {
            result = this.mapSemanticIdToUnit(result);
        }
        if (null == result) {
            result = this.mapSemanticIdToUnit(IvmlUtils.getStringValue(type, "name", ""));
        }
        return result;
    }

    private void processType(RecordType type, ConnectorInfo influx, SubmodelElementCollection.SubmodelElementCollectionBuilder panelsB, String influxDb) {
        if (null != type && influx != null) {
            for (Field f : type.fields) {
                if (IvmlDashboardMapper.isBlank(f.unit) || IvmlDashboardMapper.isBlank(f.panelType)) continue;
                SubmodelElementCollection.SubmodelElementCollectionBuilder panelB = panelsB.createSubmodelElementCollectionBuilder(f.name);
                this.createProperty((SubmodelElementContainerBuilder)panelB, "title", Type.STRING, f.name, "Panel title");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "unit", Type.STRING, f.unit, "Panel unit");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "datasource_uid", Type.STRING, influxDb, "Unique identifier for InfluxDB in db section");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "bucket", Type.STRING, influx.bucket, "InfluxDB bucket");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "measurement", Type.STRING, influx.measurement, "InfluxDB measurement");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "fields", Type.STRING, f.field, "InfluxDB fields in measurement");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "panel_type", Type.STRING, f.panelType, "Panel type");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "description", Type.STRING, f.description, "Panel description");
                this.createProperty((SubmodelElementContainerBuilder)panelB, "displayName", Type.STRING, f.displayName, "Panel display name");
                if (f.displayRow != null) {
                    this.createProperty((SubmodelElementContainerBuilder)panelB, "row", Type.STRING, f.displayRow.id, "Display row id pointing to rows section");
                }
                this.processLegend(type.legend, panelB);
                this.processPanelPosition(type.position, panelB);
                panelB.build();
            }
        }
    }

    private void processLegend(Legend legend, SubmodelElementCollection.SubmodelElementCollectionBuilder panelB) {
        if (null != legend) {
            this.createProperty((SubmodelElementContainerBuilder)panelB, "as_table", Type.BOOLEAN, legend.asTable, "Legend: as_table");
            this.createProperty((SubmodelElementContainerBuilder)panelB, "placement", Type.STRING, legend.placement, "Legend: placement");
            this.createProperty((SubmodelElementContainerBuilder)panelB, "calculations", Type.STRING, legend.calculations, "Legend: calculations");
        }
    }

    private void processPanelPosition(PanelPosition position, SubmodelElementCollection.SubmodelElementCollectionBuilder panelB) {
        if (null != position) {
            this.createProperty((SubmodelElementContainerBuilder)panelB, "x", Type.INTEGER, position.x, "Panel position: x");
            this.createProperty((SubmodelElementContainerBuilder)panelB, "y", Type.INTEGER, position.y, "Panel position: y");
            this.createProperty((SubmodelElementContainerBuilder)panelB, "width", Type.INTEGER, position.width, "Panel position: width");
            this.createProperty((SubmodelElementContainerBuilder)panelB, "height", Type.INTEGER, position.height, "Panel position: height");
        }
    }

    private void createProperty(SubmodelElementContainerBuilder parent, String idShort, Type type, Object value, String description) {
        if (value != null) {
            parent.createPropertyBuilder(idShort).setValue(type, value).setDescription(new LangString[]{new LangString("EN", description)}).build();
        }
    }

    public static void main(String[] args) throws ExecutionException, IOException {
        System.out.println("oktoflow dashboard instantiator");
        if (args.length < 2) {
            System.out.println("Following arguments are required:");
            System.out.println(" - name of the model/configuration");
            System.out.println(" - folder the model is located in, src/main/easy is used for the metamodel");
            System.out.println(" - optional IVML meta model folder");
        } else {
            IvmlDashboardMapper.mainImpl(args);
        }
    }

    private static void mainImpl(String[] args) throws ExecutionException, IOException {
        File support = new File("../../support").getCanonicalFile();
        String supportFolder = support.toString();
        PluginManager.registerPlugin((PluginSetupDescriptor)new FolderClasspathPluginSetupDescriptor(new File(supportFolder + "/support.aas.basyx")));
        PluginManager.registerPlugin((PluginSetupDescriptor)new FolderClasspathPluginSetupDescriptor(new File(supportFolder + "/support.aas.basyx2")));
        PluginManager.registerPlugin((PluginSetupDescriptor)new FolderClasspathPluginSetupDescriptor(new File(supportFolder + "/support.yaml-snakeyaml")));
        String pluginId = "aas.basyx-2.0";
        AasFactory factory = IvmlDashboardMapper.getAasFactory("aas.basyx-2.0");
        ConfigurationSetup setup = ConfigurationSetup.getSetup();
        EasySetup easySetup = setup.getEasyProducer();
        easySetup.reset();
        File projectFolder = new File(args[1]);
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(args[0], projectFolder, new File("gen"));
        if (args.length >= 3) {
            configurer.setIvmlMetaModelFolder(new File(args[2]));
        }
        configurer.configure(setup);
        ConfigurationLifecycleDescriptor lcd = configurer.obtainLifecycleDescriptor();
        lcd.startup(new String[0]);
        Configuration cfg = ConfigurationManager.getIvmlConfiguration();
        try {
            new IvmlDashboardMapper(factory, projectFolder).process(cfg, null, (aas, sm, id) -> {
                String fileName = id.replace(' ', '_');
                File file = new File("target/" + fileName + ".json");
                try {
                    factory.createPersistenceRecipe().writeTo(List.of(aas), file);
                    IvmlDashboardMapper.getLogger().info("File {} written.", (Object)file);
                }
                catch (IOException e) {
                    IvmlDashboardMapper.getLogger().error("While writing {}: {}", (Object)file, (Object)e.getMessage());
                }
            });
        }
        catch (ModelQueryException e) {
            throw new ExecutionException(e);
        }
        lcd.shutdown();
        setup.getEasyProducer().reset();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IvmlDashboardMapper.class);
    }

    private static AasFactory getAasFactory(String aasFactoryPluginId) {
        Plugin plugin = PluginManager.getPlugin((String)aasFactoryPluginId, AasFactory.class);
        AasFactory factory = null != plugin ? (AasFactory)plugin.getInstance() : AasFactory.getInstance();
        return factory;
    }

    public static interface ResultConsumer {
        public void consume(Aas var1, Submodel var2, String var3);
    }

    private static class DisplayRow {
        private String id;
        private String name;
        private String displayName;

        private DisplayRow() {
        }
    }

    private static class ConnectorInfo {
        private String id;
        private String name;
        private String organization;
        private String bucket;
        private String measurement;
        private String host;
        private int port;
        private SecuritySettings security;

        private ConnectorInfo() {
        }
    }

    private static class RecordType {
        private String name;
        private List<Field> fields = new ArrayList<Field>();
        private Legend legend;
        private PanelPosition position;

        private RecordType() {
        }
    }

    private static class SecuritySettings {
        private boolean ssl;
        private String authenticationKey;
        private boolean enableTokenExport;
        private String keystoreKey;
        private String keyAlias;
        private String idStoreAuthenticationPrefix;

        private SecuritySettings() {
        }
    }

    private static class Field {
        private String name;
        private String field;
        private String description;
        private String displayName;
        private String unit;
        private String panelType;
        private DisplayRow displayRow;

        private Field() {
        }
    }

    private static class Legend {
        private boolean asTable;
        private String placement;
        private String calculations;

        private Legend() {
        }
    }

    private static class PanelPosition {
        private int x;
        private int y;
        private int width;
        private int height;

        private PanelPosition() {
        }
    }
}

