/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.ConfigurationLifecycleDescriptor;
import de.iip_ecosphere.platform.configuration.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.EasySetup;
import de.iip_ecosphere.platform.configuration.ivml.IvmlUtils;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.ssehub.easy.instantiation.core.model.common.ITraceFilter;
import net.ssehub.easy.instantiation.core.model.common.NoTraceFilter;
import net.ssehub.easy.instantiation.core.model.common.TopLevelExecutionTraceFilter;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;

public class PlatformInstantiator {
    public static final String KEY_PROPERTY_TRACING = "iip.easy.tracing";
    public static final String KEY_PROPERTY_MVNARGS = "iip.easy.mvnArgs";
    public static final String KEY_PROPERTY_APPS = "iip.easy.apps";
    private static final String ARG_PROPS_START = "props>";
    private static final String ARG_PROPS_END = "<props";
    private static int exitCode = 0;
    private static ClassLoader classLoader;

    public static void setClassLoader(ClassLoader loader) {
        classLoader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void instantiate(InstantiationConfigurer configurer) throws ExecutionException {
        ConfigurationSetup setup = ConfigurationSetup.getSetup();
        configurer.configure(setup);
        ConfigurationLifecycleDescriptor lcd = configurer.obtainLifecycleDescriptor();
        lcd.setClassLoader(classLoader);
        lcd.startup(new String[0]);
        configurer.validateConfiguration(ConfigurationManager.getIvmlConfiguration());
        ReasoningResult rRes = ConfigurationManager.validateAndPropagate();
        if (null == rRes) {
            throw new ExecutionException("No valid IVML model loaded/found.", null);
        }
        configurer.validateReasoningResult(rRes);
        ConfigurationManager.setupContainerProperties();
        try {
            ConfigurationManager.instantiate(configurer.getStartRuleName());
        }
        catch (ExecutionException e) {
            configurer.handleExecutionException(e);
        }
        finally {
            lcd.shutdown();
            setup.getEasyProducer().reset();
        }
    }

    public static void main(String[] args) throws ExecutionException {
        if (args.length < 3) {
            System.out.println("oktoflow platform instantiator");
            System.out.println("Following arguments are required:");
            System.out.println(" - name of the model/configuration");
            System.out.println(" - folder the model is located in, src/main/easy is used for the metamodel");
            System.out.println(" - output folder where to place the generated artifacts");
            System.out.println(" - optional VIL start rule name (\"main\", \"generateApps\", \"generateInterfaces\"");
            System.out.println(" - optional IVML meta model folder");
            System.out.println("   - main: app interfaces, apps, platform components (default)");
            System.out.println("   - generateInterfaces: app interfaces, no apps");
            System.out.println("   - generateAppsNoDeps: app interfaces, apps without artifact dependencies");
            System.out.println("   - generateApps: app interfaces, apps with artifact dependencies");
            System.out.println("   - generateBroker: create a sample broker");
            System.out.println("   - generatePlatform: platform components only");
            System.out.println("Optional: Output filtering -Diip.easy.tracing=ALL|FUNC|TOP, default TOP=toplevel");
        } else {
            PlatformInstantiator.mainImpl(args);
            System.exit(exitCode);
        }
    }

    public static void setTraceFilter() {
        String tracing = System.getProperty(KEY_PROPERTY_TRACING, "TOP").toUpperCase();
        ITraceFilter filter = TopLevelExecutionTraceFilter.INSTANCE;
        if ("FUNC".equals(tracing)) {
            filter = new FunctionLevelTraceFilter();
        } else if ("ALL".equals(tracing)) {
            filter = NoTraceFilter.INSTANCE;
        }
        TracerFactory.setTraceFilter((ITraceFilter)filter);
    }

    public static int mainImpl(String[] args) throws ExecutionException {
        ConfigurationManager.setStandalone(true);
        PlatformInstantiator.setTraceFilter();
        InstantiationConfigurer c = new InstantiationConfigurer(args[0], new File(args[1]), new File(args[2]));
        if (args.length >= 4) {
            c.setStartRuleName(args[3]);
        }
        if (args.length >= 5) {
            c.setIvmlMetaModelFolder(new File(args[4]));
        }
        PlatformInstantiator.instantiate(c);
        return exitCode;
    }

    public static class InstantiationConfigurer {
        private String ivmlModelName;
        private File outputFolder;
        private File modelFolder;
        private File metaModelFolder;
        private String startRuleName = "mainCli";
        private Map<String, String> properties = new HashMap<String, String>();
        private boolean emitReasonerWarnings = false;

        public InstantiationConfigurer(String ivmlModelName, File modelFolder, File outputFolder) {
            this.ivmlModelName = ivmlModelName;
            this.modelFolder = modelFolder;
            this.outputFolder = outputFolder;
        }

        public InstantiationConfigurer(String[] args) {
            int pos = 0;
            this.ivmlModelName = args[pos++];
            this.modelFolder = this.fromArg(args[pos++]);
            this.outputFolder = this.fromArg(args[pos++]);
            this.metaModelFolder = this.fromArg(args[pos++]);
            this.startRuleName = args[pos++];
            if (args.length > 4 && PlatformInstantiator.ARG_PROPS_START.equals(args[pos])) {
                int startPos = ++pos;
                String lastKey = "";
                for (int p = pos; p < args.length && !PlatformInstantiator.ARG_PROPS_END.equals(args[p]); ++p) {
                    if (p - startPos % 2 == 0) {
                        lastKey = args[p];
                        this.properties.put(lastKey, null);
                        continue;
                    }
                    this.properties.put(lastKey, args[p]);
                }
            }
        }

        protected int getLastArgsIndex(String[] args) {
            int pos = 4;
            if (args.length > 4 && PlatformInstantiator.ARG_PROPS_START.equals(args[5])) {
                ++pos;
                while (pos < args.length && !PlatformInstantiator.ARG_PROPS_END.equals(args[pos])) {
                    ++pos;
                }
            }
            return pos;
        }

        protected File fromArg(String file) {
            return file == null || file.equals("-") ? null : new File(file);
        }

        protected String toArg(File file) {
            return null == file ? "-" : file.toString();
        }

        public String getMainClass() {
            return PlatformInstantiator.class.getName();
        }

        public boolean inTesting() {
            return false;
        }

        public String[] toArgs(boolean all) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.ivmlModelName);
            args.add(this.toArg(this.modelFolder));
            args.add(this.toArg(this.outputFolder));
            args.add(this.toArg(this.metaModelFolder));
            args.add(this.startRuleName);
            if (all && this.properties.size() > 0) {
                args.add(PlatformInstantiator.ARG_PROPS_START);
                for (String key : this.properties.keySet()) {
                    args.add(key);
                    args.add(this.properties.get(key));
                }
                args.add(PlatformInstantiator.ARG_PROPS_END);
            }
            return args.toArray(new String[args.size()]);
        }

        protected boolean isEmitReasonerWarnings() {
            return this.emitReasonerWarnings;
        }

        public InstantiationConfigurer emitReasonerWarnings() {
            this.emitReasonerWarnings = true;
            return this;
        }

        public InstantiationConfigurer setStartRuleName(String startRuleName) {
            this.startRuleName = null == startRuleName || startRuleName.length() == 0 ? "main" : startRuleName;
            return this;
        }

        public InstantiationConfigurer setIvmlMetaModelFolder(File metaModelFolder) {
            if (null != metaModelFolder && metaModelFolder.exists()) {
                this.metaModelFolder = metaModelFolder;
            }
            return this;
        }

        public void configure(ConfigurationSetup setup) {
            EasySetup easySetup = setup.getEasyProducer();
            easySetup.setIvmlModelName(this.ivmlModelName);
            if (null != this.modelFolder) {
                easySetup.setIvmlConfigFolder(this.modelFolder);
            }
            if (null != this.metaModelFolder) {
                easySetup.setIvmlMetaModelFolder(this.metaModelFolder);
            }
            if (this.cleanOutputFolder()) {
                FileUtils.deleteQuietly((File)this.outputFolder);
                this.outputFolder.mkdirs();
            }
            easySetup.setGenTarget(this.outputFolder);
        }

        public String getStartRuleName() {
            return this.startRuleName;
        }

        public String getIvmlModelName() {
            return this.ivmlModelName;
        }

        public File getOutputFolder() {
            return this.outputFolder;
        }

        public File getModelFolder() {
            return this.modelFolder;
        }

        public File getMetaModelFolder() {
            return this.metaModelFolder;
        }

        protected boolean cleanOutputFolder() {
            return true;
        }

        public ConfigurationLifecycleDescriptor obtainLifecycleDescriptor() {
            return new ConfigurationLifecycleDescriptor();
        }

        protected void validateConfiguration(Configuration conf) throws ExecutionException {
        }

        protected void validateReasoningResult(ReasoningResult res) throws ExecutionException {
            if (IvmlUtils.analyzeReasoningResult(res, this.isEmitReasonerWarnings(), true)) {
                System.exit(-1);
            }
        }

        protected void handleExecutionException(ExecutionException ex) throws ExecutionException {
            System.out.println(ex.getMessage());
            exitCode = 1;
        }

        public InstantiationConfigurer setProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Map<String, String> getProperties() {
            return new HashMap<String, String>(this.properties);
        }
    }

    private static class FunctionLevelTraceFilter
    implements ITraceFilter {
        private FunctionLevelTraceFilter() {
        }

        public boolean isEnabled(ITraceFilter.LanguageElementKind kind) {
            return kind == ITraceFilter.LanguageElementKind.FAILURE || kind == ITraceFilter.LanguageElementKind.LANGUAGE_UNIT || kind == ITraceFilter.LanguageElementKind.FUNCTION_EXECUTION;
        }

        public boolean isWarningEnabled() {
            return false;
        }
    }

    public static class NonCleaningInstantiationConfigurer
    extends InstantiationConfigurer {
        public NonCleaningInstantiationConfigurer(String ivmlModelName, File modelFolder, File outputFolder) {
            super(ivmlModelName, modelFolder, outputFolder);
        }

        @Override
        protected boolean cleanOutputFolder() {
            return false;
        }
    }
}

