/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.aas;

import de.iip_ecosphere.platform.configuration.aas.AasEnum;
import de.iip_ecosphere.platform.configuration.aas.AasField;
import de.iip_ecosphere.platform.configuration.aas.AasOperation;
import de.iip_ecosphere.platform.configuration.aas.AasSmeType;
import de.iip_ecosphere.platform.configuration.aas.AasSpecSummary;
import de.iip_ecosphere.platform.configuration.aas.AasType;
import de.iip_ecosphere.platform.configuration.aas.AbstractAasElement;
import de.iip_ecosphere.platform.configuration.aas.IvmlWriter;
import de.iip_ecosphere.platform.configuration.aas.ParsingUtils;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.SemanticIdRecognizer;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReadAasxFile {
    public static String getSpecNumber(File file) {
        String fileName = file.getName();
        if (fileName.endsWith(".aasx")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        return ReadAasxFile.getSpecNumber(file.getParentFile().getName() + "/" + fileName);
    }

    public static String getSpecNumber(String fileName) {
        int pos = fileName.indexOf("/");
        String specNumber = "0000";
        if (pos > 0) {
            specNumber = fileName.substring(0, pos);
        }
        return specNumber;
    }

    public static void readFile(String source, String target, String specNumber) throws IOException {
        ReadAasxFile.readFile(source, target, specNumber, null);
    }

    public static AasSpecSummary read(String source, String specNumber) throws IOException {
        AasSpecSummary result = null;
        ZipInputStream zin = new ZipInputStream(new FileInputStream(source));
        ZipEntry ze = null;
        Document document = null;
        while ((ze = zin.getNextEntry()) != null) {
            String name = ze.getName();
            if (!name.startsWith("aasx/") || !name.endsWith(".xml")) continue;
            ReadAasxFile.getLogger().info("Reading " + name);
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                document = docBuilder.parse(zin);
                break;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e);
            }
        }
        if (null != document) {
            XmlReader reader = new XmlReader();
            result = reader.readFromXml(document, specNumber);
        }
        return result;
    }

    public static void readFile(String source, String target, String specNumber, String idShortPrefix) throws IOException {
        AasSpecSummary result = ReadAasxFile.read(source, specNumber);
        if (null != result) {
            System.out.println(source);
            result.printStatistics(System.out);
            IvmlWriter writer = new IvmlWriter(target).setNamePrefix(idShortPrefix);
            writer.toIvml(result);
            writer.toIvmlText(result);
        }
    }

    private static void iterateChilds(Node node, Consumer<Node> function) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            function.accept(currentNode);
        }
    }

    private static int getIterableChildsCount(Node node, Predicate<Node> pred) {
        AtomicInteger result = new AtomicInteger(0);
        ReadAasxFile.iterateChilds(node, n -> {
            if (null == pred || pred.test((Node)n)) {
                result.incrementAndGet();
            }
        });
        return result.get();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ReadAasxFile.class);
    }

    public static void main(String ... args) throws IOException {
        if (args.length >= 3) {
            ReadAasxFile.readFile(args[0], args[1], args[2], args.length >= 4 ? args[3] : null);
        } else {
            String baseDir = "src/test/resources/idta/";
            ReadAasxFile.readFile(baseDir + "2023/IDTA 2023-0-9 _Template_CarbonFootprint.aasx", null, "02023");
        }
    }

    private static class XmlReader {
        private List<AasType> types = new ArrayList<AasType>();
        private Map<String, List<AasType>> semIdTypes = new HashMap<String, List<AasType>>();
        private Map<String, List<AasField>> semIdFields = new HashMap<String, List<AasField>>();
        private List<AasEnum> enums = new ArrayList<AasEnum>();
        private ParsingUtils.AasEnumResultHandler enumsHandler = new ParsingUtils.AasEnumResultHandler(this.enums);
        private Map<String, List<AasEnum>> semIdEnums = new HashMap<String, List<AasEnum>>();
        private List<ConceptDescription> concepts = new ArrayList<ConceptDescription>();

        private XmlReader() {
        }

        AasSpecSummary readFromXml(Document document, String specNumber) {
            AtomicReference<Object> version = new AtomicReference<Object>(null);
            ReadAasxFile.iterateChilds(document.getDocumentElement(), n -> {
                String name;
                switch (name = XmlReader.getName(n)) {
                    case "submodels": {
                        String ver = this.readSubmodels((Node)n);
                        if (version.get() != null) break;
                        version.set(ver);
                        break;
                    }
                    case "conceptDescriptions": {
                        this.readConceptDescriptions((Node)n);
                        break;
                    }
                }
            });
            for (AasEnum en : this.enums) {
                this.registerSemanticId(this.semIdEnums, en);
            }
            for (ConceptDescription cd : this.concepts) {
                List<AasEnum> list;
                List<AasField> fields;
                if (cd.identification == null) continue;
                List<AasType> types = this.semIdTypes.get(cd.identification);
                if (null != types) {
                    for (AasType aasType : types) {
                        ReadAasxFile.getLogger().info("Applying concept description to type " + aasType.getIdShort());
                        this.applyConceptDescription(aasType, cd);
                    }
                }
                if (null != (fields = this.semIdFields.get(cd.identification))) {
                    for (AasField f : fields) {
                        ReadAasxFile.getLogger().info("Applying concept description to field " + f.getIdShort());
                        this.applyConceptDescription(f, cd);
                    }
                }
                if (null == (list = this.semIdEnums.get(cd.identification))) continue;
                for (AasEnum e : list) {
                    ReadAasxFile.getLogger().info("Applying concept description to enum " + e.getIdShort());
                    this.applyConceptDescription(e, cd);
                }
            }
            AasSpecSummary result = new AasSpecSummary(this.types, this.enums);
            Version ver = null;
            if (null != version.get()) {
                ver = new Version((String)version.get());
            }
            result.setIdentifier(null, null, ver, null, specNumber);
            return result;
        }

        private static String getName(Node node) {
            String name = node.getNodeName();
            int pos = name.indexOf(":");
            if (pos > 0) {
                name = name.substring(pos + 1);
            }
            return name;
        }

        private <E extends AbstractAasElement> void registerSemanticId(Map<String, List<E>> map, E element) {
            String sId = element.getSemanticId();
            if (sId != null && sId.length() > 0) {
                List<E> elements = map.get(sId);
                if (null == elements) {
                    elements = new ArrayList();
                    map.put(sId, elements);
                }
                elements.add(element);
            }
        }

        private void applyConceptDescription(AbstractAasElement elt, ConceptDescription cd) {
            elt.setIsCaseOf(cd.isCaseOf);
            String desc = elt.getDescription();
            String cdDesc = cd.getDescription();
            if (cdDesc != null) {
                if (desc == null || desc.length() == 0) {
                    elt.setDescription(ParsingUtils.removeLinebreaks(cdDesc));
                } else if (!desc.equals(cdDesc) && !desc.contains(cdDesc) && (desc.startsWith("Note: ") || desc.startsWith("Recommendation: "))) {
                    elt.setDescription(ParsingUtils.removeLinebreaks(cdDesc + " " + desc));
                }
            }
        }

        private String readSubmodels(Node node) {
            AtomicReference<Object> version = new AtomicReference<Object>(null);
            ReadAasxFile.iterateChilds(node, submodel -> {
                AasTypeResult result = this.readAsAasType((Node)submodel, AasSmeType.SUBMODEL);
                if (version.get() == null) {
                    version.set(result.version);
                }
            });
            return version.get();
        }

        private AasTypeResult readAsAasType(Node node, AasSmeType smeType) {
            AtomicReference<String> idShort = new AtomicReference<String>("");
            AtomicReference<String> semanticId = new AtomicReference<String>("");
            AtomicReference<Object> identification = new AtomicReference<Object>(null);
            AtomicReference<Object> entityType = new AtomicReference<Object>(null);
            AtomicReference<String> description = new AtomicReference<String>("");
            AtomicReference<String> formInfoValue = new AtomicReference<String>("");
            AtomicReference<String> displayName = new AtomicReference<String>("");
            AtomicReference<String> exampleValue = new AtomicReference<String>("");
            AtomicReference<Object> version = new AtomicReference<Object>(null);
            AtomicReference<Object> cardinality = new AtomicReference<Object>(null);
            AtomicBoolean fixedIdShort = new AtomicBoolean(false);
            AtomicBoolean ordered = new AtomicBoolean(false);
            AtomicBoolean allowDuplicates = new AtomicBoolean(false);
            AtomicBoolean isMultiValued = new AtomicBoolean(false);
            ReadAasxFile.iterateChilds(node, field -> {
                String name;
                switch (name = XmlReader.getName(field)) {
                    case "idShort": {
                        String tmp = field.getTextContent().trim();
                        if (tmp.endsWith("{00}")) {
                            tmp = tmp.substring(0, tmp.length() - 4);
                            isMultiValued.set(true);
                        }
                        ReadAasxFile.getLogger().info("Reading type {}", (Object)tmp);
                        idShort.set(tmp);
                        break;
                    }
                    case "semanticId": {
                        semanticId.set(this.getSemanticId((Node)field));
                        break;
                    }
                    case "description": {
                        description.set(this.getDescription((Node)field, null, false, false));
                        fixedIdShort.set(ParsingUtils.hasFixedIdShort((String)description.get()));
                        break;
                    }
                    case "ordered": {
                        ordered.set(this.getBoolean((Node)field));
                        break;
                    }
                    case "allowDuplicates": {
                        allowDuplicates.set(this.getBoolean((Node)field));
                        break;
                    }
                    case "qualifiers": 
                    case "qualifier": {
                        this.readQualifier((Node)field, c -> cardinality.set(c), ex -> exampleValue.set((String)ex), (t, v) -> {
                            if ("FormInfo".equals(t)) {
                                formInfoValue.set(v);
                            }
                        });
                        break;
                    }
                    case "administration": {
                        version.set(this.readAdministration((Node)field));
                        break;
                    }
                    case "id": 
                    case "identification": {
                        identification.set(this.readSemanticId((Node)field));
                        break;
                    }
                    case "entityType": {
                        entityType.set(node.getTextContent().trim());
                        break;
                    }
                    case "supplementalSemanticIds": 
                    case "category": 
                    case "value": 
                    case "typeValueListElement": 
                    case "submodelElements": 
                    case "statements": 
                    case "kind": 
                    case "embeddedDataSpecifications": 
                    case "displayName": {
                        String dpn = this.readDisplayName((Node)field);
                        if (dpn.length() <= 0) break;
                        displayName.set(dpn);
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Not reading submodel element/entity property: " + name);
                    }
                }
            });
            AasType type = new AasType(idShort.get(), false, isMultiValued.get());
            type.setAllowDuplicates(allowDuplicates.get());
            type.setOrdered(ordered.get());
            type.setSemanticId(semanticId.get() != null && semanticId.get().length() > 0 ? semanticId.get() : (String)identification.get());
            String desc = description.get();
            if (desc.length() == 0 && (desc = formInfoValue.get()).length() == 0) {
                desc = displayName.get();
            }
            type.setDescription(ParsingUtils.removeLinebreaks(desc));
            type.setSmeType(smeType);
            type.setEntityType(AasType.EntityType.valueOfSafe(entityType.get()));
            this.addType(type);
            ReadAasxFile.iterateChilds(node, field -> {
                String name;
                switch (name = XmlReader.getName(field)) {
                    case "typeValueListElement": 
                    case "submodelElements": 
                    case "value": 
                    case "statements": {
                        this.readSubmodelElement((Node)field, type);
                        break;
                    }
                }
            });
            return new AasTypeResult(type, cardinality.get(), exampleValue.get(), version.get());
        }

        private String readDisplayName(Node node) {
            String result = null;
            HashMap desc = new HashMap();
            ReadAasxFile.iterateChilds(node, field -> {
                String name;
                switch (name = XmlReader.getName(field)) {
                    case "langStringNameType": {
                        this.readLangStringTextType((Node)field, desc);
                        break;
                    }
                }
            });
            if (desc.size() > 0 && null == (result = (String)desc.get("en"))) {
                result = (String)desc.values().iterator().next();
            }
            return result == null ? "" : result;
        }

        private void addType(AasType type) {
            if (!this.types.stream().anyMatch(t -> t.getIdShort().equals(type.getIdShort()))) {
                this.types.add(type);
                this.registerSemanticId(this.semIdTypes, type);
            }
        }

        private String readAdministration(Node node) {
            AtomicReference<Object> version = new AtomicReference<Object>(null);
            AtomicReference<Object> revision = new AtomicReference<Object>(null);
            ReadAasxFile.iterateChilds(node, e -> {
                String name;
                switch (name = XmlReader.getName(e)) {
                    case "version": {
                        version.set(e.getTextContent().trim());
                        break;
                    }
                    case "revision": {
                        revision.set(e.getTextContent().trim());
                        break;
                    }
                    case "templateId": {
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unknown administration element: " + name);
                    }
                }
            });
            Object result = null;
            if (version.get() != null) {
                result = version.get();
            }
            if (result != null && revision.get() != null) {
                result = (String)result + "." + (String)revision.get();
            }
            return result;
        }

        private void readQualifier(Node node, Consumer<int[]> cardinalitySetter, Consumer<String> exampleValueSetter, QualifierConsumer fallbackConsumer) {
            AtomicReference<String> type = new AtomicReference<String>("");
            AtomicReference<String> value = new AtomicReference<String>("");
            ReadAasxFile.iterateChilds(node, sme -> {
                String name = XmlReader.getName(sme);
                if ("qualifier".equals(name)) {
                    ReadAasxFile.iterateChilds(sme, q -> {
                        String qName;
                        switch (qName = XmlReader.getName(q)) {
                            case "type": {
                                type.set(q.getTextContent().trim());
                                break;
                            }
                            case "value": {
                                value.set(q.getTextContent().trim());
                                break;
                            }
                            case "valueId": 
                            case "valueType": 
                            case "semanticId": 
                            case "kind": {
                                break;
                            }
                            default: {
                                ReadAasxFile.getLogger().warn("Unconsidered cardinality entry: " + qName);
                            }
                        }
                    });
                    if ("Cardinality".equals(type.get()) || "Multiplicity".equals(type.get())) {
                        switch ((String)value.get()) {
                            case "OneToMany": {
                                cardinalitySetter.accept(new int[]{1, -1});
                                break;
                            }
                            case "ZeroToMany": {
                                cardinalitySetter.accept(new int[]{0, -1});
                                break;
                            }
                            case "ZeroToOne": {
                                cardinalitySetter.accept(new int[]{0, 1});
                                break;
                            }
                            case "One": {
                                cardinalitySetter.accept(new int[]{1, 1});
                                break;
                            }
                            default: {
                                ReadAasxFile.getLogger().warn("Unconsidered cardinality: " + (String)value.get());
                                break;
                            }
                        }
                    } else if ("ExampleValue".equals(type.get())) {
                        exampleValueSetter.accept((String)value.get());
                    } else if (null != fallbackConsumer) {
                        fallbackConsumer.consume((String)type.get(), (String)value.get());
                    }
                } else {
                    ReadAasxFile.getLogger().warn("Unconsidered qualifier entry: " + name);
                }
            });
        }

        private void readSubmodelElement(Node node, AasType type) {
            ReadAasxFile.iterateChilds(node, field -> {
                String name;
                switch (name = XmlReader.getName(field)) {
                    case "submodelElement": {
                        this.readSubmodelElement((Node)field, type);
                        break;
                    }
                    case "submodelElementCollection": {
                        this.readFieldAsNewType((Node)field, type, AasSmeType.SUBMODEL_ELEMENT_COLLECTION);
                        break;
                    }
                    case "submodelElementList": {
                        this.readFieldAsNewType((Node)field, type, AasSmeType.SUBMODEL_ELEMENT_LIST);
                        break;
                    }
                    case "entity": {
                        this.readFieldAsNewType((Node)field, type, AasSmeType.ENTITY);
                        break;
                    }
                    case "property": {
                        this.addField(type, this.readAasProperty((Node)field, null, AasSmeType.PROPERTY, null));
                        break;
                    }
                    case "file": {
                        this.addField(type, this.readAasProperty((Node)field, "AasFileResourceType", AasSmeType.FILE, (fi, no, na) -> {
                            boolean done = false;
                            if (na.equals("mimeType")) {
                                fi.setExampleExplanation(no.getTextContent().trim());
                                done = true;
                            }
                            return done;
                        }));
                        break;
                    }
                    case "multiLanguageProperty": {
                        this.addField(type, this.readAasProperty((Node)field, "AasMultiLangStringType", AasSmeType.MULTI_LANGUAGE_PROPERTY, null));
                        break;
                    }
                    case "blob": {
                        this.addField(type, this.readAasProperty((Node)field, "AasBlobType", AasSmeType.BLOB, null));
                        break;
                    }
                    case "operation": {
                        AasField fld = this.readAasProperty((Node)field, null, AasSmeType.OPERATION, null);
                        this.addField(type, new AasOperation(fld));
                        break;
                    }
                    case "range": {
                        this.addField(type, this.readAasProperty((Node)field, "AasRangeType", AasSmeType.RANGE, null));
                        break;
                    }
                    case "relationshipElement": {
                        this.addField(type, this.readAasProperty((Node)field, "AasRelationType", AasSmeType.RELATION, (fi, no, na) -> {
                            boolean done = false;
                            if (na.equals("first") || na.equals("second")) {
                                done = true;
                            }
                            return done;
                        }));
                        break;
                    }
                    case "referenceElement": {
                        this.addField(type, this.readAasProperty((Node)field, "AasReferenceType", AasSmeType.REFERENCE, null));
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered submodel element type: " + name);
                    }
                }
            });
        }

        private void readFieldAsNewType(Node field, AasType parentType, AasSmeType smeType) {
            AasField fld = new AasField();
            AasTypeResult eltTypeResult = this.readAsAasType(field, smeType);
            AasType eltType = eltTypeResult.type;
            fld.setSmeType(AasSmeType.PROPERTY);
            fld.setIdShort(eltType.getIdShort(), eltType.isMultiValued());
            fld.setValueType(eltType.getIdShort());
            fld.setSemanticId(eltType.getSemanticId());
            fld.setDescription(ParsingUtils.removeLinebreaks(eltType.getDescription()));
            if (null != eltTypeResult.cardinality) {
                fld.setCardinality(eltTypeResult.cardinality[0], eltTypeResult.cardinality[1]);
            }
            if (null != eltTypeResult.exampleValue && eltTypeResult.exampleValue.length() > 0) {
                this.setExampleValues(eltTypeResult.exampleValue, fld);
            }
            this.addField(parentType, fld);
        }

        private void addField(AasType type, AasField field) {
            if (null != field) {
                type.addField(field);
                this.registerSemanticId(this.semIdFields, field);
            }
        }

        private void setExampleValues(String data, AasField field) {
            if (null != data && data.trim().length() > 0) {
                int pos;
                ArrayList<String> tokens = new ArrayList<String>();
                int lastPos = 0;
                do {
                    if ((pos = data.indexOf("|", lastPos)) <= 0) continue;
                    tokens.add(data.substring(lastPos, pos).trim());
                    lastPos = pos + 1;
                } while (pos > 0);
                tokens.add(data.substring(lastPos, data.length()).trim());
                field.setExampleValues(tokens.toArray(new String[tokens.size()]));
            }
        }

        private void readConceptDescriptions(Node node) {
            ReadAasxFile.iterateChilds(node, cd -> {
                String name = XmlReader.getName(cd);
                if ("conceptDescription".equals(name)) {
                    this.readConceptDescription((Node)cd);
                }
            });
        }

        private void readConceptDescription(Node node) {
            ConceptDescription result = new ConceptDescription();
            ReadAasxFile.iterateChilds(node, field -> {
                String name;
                switch (name = XmlReader.getName(field)) {
                    case "idShort": {
                        result.idShort = field.getTextContent().trim();
                        break;
                    }
                    case "id": 
                    case "identification": {
                        result.identification = this.readSemanticId((Node)field);
                        break;
                    }
                    case "description": {
                        result.description = this.getDescription((Node)field, null, false, false);
                        break;
                    }
                    case "embeddedDataSpecification": {
                        this.readEmbeddedDataSpecification((Node)field, result);
                        break;
                    }
                    case "embeddedDataSpecifications": {
                        this.readEmbeddedDataSpecifications((Node)field, result);
                        break;
                    }
                    case "isCaseOf": {
                        result.isCaseOf = this.getSemanticId((Node)field);
                        break;
                    }
                    case "displayName": 
                    case "category": 
                    case "administration": {
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered concept description field: " + name);
                    }
                }
            });
            this.concepts.add(result);
        }

        private void readEmbeddedDataSpecifications(Node node, ConceptDescription cd) {
            ReadAasxFile.iterateChilds(node, spec -> {
                String name;
                switch (name = XmlReader.getName(spec)) {
                    case "embeddedDataSpecification": {
                        this.readEmbeddedDataSpecification((Node)spec, cd);
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered embedded data specifications entry: " + name);
                    }
                }
            });
        }

        private void readEmbeddedDataSpecification(Node node, ConceptDescription cd) {
            ReadAasxFile.iterateChilds(node, spec -> {
                String name;
                switch (name = XmlReader.getName(spec)) {
                    case "dataSpecificationContent": {
                        this.readDataSpecificationContent((Node)spec, cd);
                        break;
                    }
                    case "dataSpecification": {
                        cd.dataSpecId = this.getSemanticId((Node)spec);
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered embedded data specification field: " + name);
                    }
                }
            });
        }

        private void readDataSpecificationContent(Node node, ConceptDescription cd) {
            ReadAasxFile.iterateChilds(node, c -> {
                String name;
                switch (name = XmlReader.getName(c)) {
                    case "dataSpecificationIec61360": 
                    case "dataSpecificationIEC61360": {
                        this.readDataSpecificationIEC61360((Node)c, cd);
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered data specification content field: " + name);
                    }
                }
            });
        }

        private void readDataSpecificationIEC61360(Node node, ConceptDescription cd) {
            ReadAasxFile.iterateChilds(node, c -> {
                String name;
                switch (name = XmlReader.getName(c)) {
                    case "definition": {
                        this.readIECdefinition((Node)c, cd);
                        break;
                    }
                    case "preferredName": 
                    case "symbol": 
                    case "shortName": 
                    case "unit": 
                    case "unitId": 
                    case "value": 
                    case "valueFormat": 
                    case "valueList": 
                    case "dataType": {
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered IEC61360 data specification content field: " + name);
                    }
                }
            });
        }

        private void readIECdefinition(Node node, ConceptDescription cd) {
            ReadAasxFile.iterateChilds(node, d -> {
                String dName = XmlReader.getName(d);
                if ("langString".equals(dName) || "langStringDefinitionTypeIec61360".equals(dName)) {
                    String description;
                    String lang;
                    if (ReadAasxFile.getIterableChildsCount(d, null) > 0) {
                        AtomicReference cLang = new AtomicReference();
                        AtomicReference cDesc = new AtomicReference();
                        ReadAasxFile.iterateChilds(d, c -> {
                            String cName;
                            switch (cName = XmlReader.getName(c)) {
                                case "language": {
                                    cLang.set(c.getTextContent().trim());
                                    break;
                                }
                                case "text": {
                                    cDesc.set(c.getTextContent().trim());
                                    break;
                                }
                            }
                        });
                        lang = (String)cLang.get();
                        description = (String)cDesc.get();
                    } else {
                        lang = this.getAttributeValue((Node)d, "lang", "").toLowerCase();
                        description = d.getTextContent().trim();
                    }
                    if (null != lang && null != description) {
                        lang = lang.toLowerCase();
                        description = ParsingUtils.removeLinebreaks(description).replaceAll(" +", " ").replace(". .", ".");
                        cd.iecDefinition.put(lang, description);
                    }
                } else {
                    ReadAasxFile.getLogger().warn("Unconsidered IEC description entry: " + dName);
                }
            });
        }

        private AasField readAasProperty(Node node, String type, AasSmeType smeType, FieldHandler handler) {
            AtomicReference<Object> descriptionField = new AtomicReference<Object>(null);
            AasField result = new AasField();
            result.setValueType(type);
            result.setSmeType(smeType);
            ReadAasxFile.iterateChilds(node, field -> {
                String name;
                switch (name = XmlReader.getName(field)) {
                    case "idShort": {
                        String tmp = field.getTextContent().trim();
                        boolean isMultiValued = false;
                        if (tmp.endsWith("{00}")) {
                            tmp = tmp.substring(0, tmp.length() - 4);
                            isMultiValued = true;
                        }
                        ReadAasxFile.getLogger().info("Reading property {}", (Object)tmp);
                        result.setIdShort(tmp, isMultiValued);
                        break;
                    }
                    case "semanticId": {
                        result.setSemanticId(this.getSemanticId((Node)field));
                        break;
                    }
                    case "description": {
                        descriptionField.set(field);
                        break;
                    }
                    case "qualifier": 
                    case "qualifiers": {
                        this.readQualifier((Node)field, c -> result.setCardinality(c[0], c[1]), e -> this.setExampleValues((String)e, result), null);
                        break;
                    }
                    case "valueType": {
                        if (type != null) break;
                        result.setValueType(field.getTextContent().trim());
                        break;
                    }
                    case "value": {
                        if (ReadAasxFile.getIterableChildsCount(field, null) > 0) {
                            this.setExampleValues(this.getDescription((Node)field, result, false, true), result);
                            break;
                        }
                        if (field.getTextContent().trim().length() <= 0) break;
                        this.setExampleValues(field.getTextContent().trim(), result);
                        break;
                    }
                    case "inputVariable": 
                    case "outputVariable": 
                    case "supplementalSemanticIds": 
                    case "embeddedDataSpecification": 
                    case "embeddedDataSpecifications": 
                    case "valueId": 
                    case "kind": 
                    case "category": 
                    case "displayName": {
                        break;
                    }
                    default: {
                        boolean done = false;
                        if (null != handler) {
                            done = handler.handle(result, (Node)field, name);
                        }
                        if (done) break;
                        ReadAasxFile.getLogger().warn("Unconsidered property entry: " + name);
                    }
                }
            });
            if (descriptionField.get() != null) {
                result.setDescription(this.getDescription(descriptionField.get(), result, true, false));
            }
            result.setGeneric(ParsingUtils.isGenericIdShort(result.getIdShort()));
            return result;
        }

        private boolean getBoolean(Node node) {
            return Boolean.valueOf(node.getTextContent().trim());
        }

        private String getDescription(Node node, AasField field, boolean inferEnum, boolean addMissingLang) {
            Object result = "";
            HashMap desc = new HashMap();
            ReadAasxFile.iterateChilds(node, s -> {
                String name;
                switch (name = XmlReader.getName(s)) {
                    case "langString": {
                        String lang = this.getAttributeValue((Node)s, "lang", "");
                        String description = ParsingUtils.removeLinebreaks(s.getTextContent().trim()).replaceAll(" +", " ").replace(". .", ".");
                        desc.put(lang, description);
                        break;
                    }
                    case "langStringTextType": {
                        this.readLangStringTextType((Node)s, desc);
                        break;
                    }
                    case "keys": {
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered description entry: " + name);
                    }
                }
            });
            String selLang = null;
            if (desc.size() > 0) {
                selLang = "en";
                result = (String)desc.get("en");
                if (null == result) {
                    Map.Entry ent = desc.entrySet().iterator().next();
                    selLang = (String)ent.getKey();
                    result = (String)ent.getValue();
                }
            }
            if (field != null) {
                if (inferEnum) {
                    result = ParsingUtils.inferEnum((String)result, (String)result, field, this.enumsHandler, true);
                }
                if (addMissingLang && AasSmeType.MULTI_LANGUAGE_PROPERTY == field.getSmeType() && result != null && ((String)result).trim().length() > 0 && selLang.length() > 0 && !((String)result).trim().toUpperCase().endsWith("@" + selLang.toUpperCase())) {
                    result = ((String)result).trim() + "@" + selLang;
                }
            }
            return ParsingUtils.removeLinebreaks((String)result);
        }

        private void readLangStringTextType(Node node, Map<String, String> desc) {
            AtomicReference<Object> lang = new AtomicReference<Object>(null);
            AtomicReference<Object> text = new AtomicReference<Object>(null);
            ReadAasxFile.iterateChilds(node, l -> {
                String name;
                switch (name = XmlReader.getName(l)) {
                    case "language": {
                        lang.set(l.getTextContent().trim().toLowerCase());
                        break;
                    }
                    case "text": {
                        text.set(l.getTextContent().trim());
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered LangStringTextType entry: " + name);
                    }
                }
            });
            if (lang.get() != null && text.get() != null) {
                desc.put(lang.get(), text.get());
            }
        }

        private String getSemanticId(Node node) {
            AtomicReference<String> result = new AtomicReference<String>("");
            ReadAasxFile.iterateChilds(node, child -> {
                String name = XmlReader.getName(child);
                if ("keys".equals(name)) {
                    ReadAasxFile.iterateChilds(child, cd -> {
                        if (ReadAasxFile.getIterableChildsCount(cd, null) > 0) {
                            result.set(this.readKeyAsSemanticId((Node)cd));
                        } else {
                            String type = this.getAttributeValue((Node)cd, "type", "");
                            if (this.isSemanticIdValidKey(type)) {
                                result.set(this.readSemanticId((Node)cd));
                            }
                        }
                    });
                }
            });
            return result.get();
        }

        private boolean isSemanticIdValidKey(String type) {
            boolean result;
            if ("Submodel".equals(type) || "ConceptDescription".equals(type) || "GlobalReference".equals(type) || "ConceptDictionary".equals(type)) {
                result = true;
            } else {
                result = false;
                ReadAasxFile.getLogger().warn("Unconsidered semanticId key type '{}'", (Object)type);
            }
            return result;
        }

        private String readKeyAsSemanticId(Node node) {
            AtomicReference type = new AtomicReference();
            AtomicReference value = new AtomicReference();
            ReadAasxFile.iterateChilds(node, child -> {
                String name;
                switch (name = XmlReader.getName(child)) {
                    case "type": {
                        type.set(child.getTextContent().trim());
                        break;
                    }
                    case "value": {
                        value.set(child.getTextContent().trim());
                        break;
                    }
                    default: {
                        ReadAasxFile.getLogger().warn("Unconsidered key element '{}'", (Object)name);
                    }
                }
            });
            String result = "";
            if (type.get() != null && value.get() != null && this.isSemanticIdValidKey((String)type.get())) {
                result = this.getSemanticId(null, (String)value.get());
            }
            return result;
        }

        private String readSemanticId(Node node) {
            String idType = this.getAttributeValue(node, "idType", "");
            String tmp = node.getTextContent().trim();
            return this.getSemanticId(idType, tmp);
        }

        private String getSemanticId(String idType, String id) {
            String result = id;
            if (null == idType || idType.length() == 0) {
                result = SemanticIdRecognizer.getSemanticIdFrom((String)id, (boolean)true);
                if (null == result) {
                    result = SemanticIdRecognizer.getSemanticIdFrom((String)id, (boolean)true, (boolean)true);
                }
            } else if ("IRI".equals(idType)) {
                result = IdentifierType.compose((String)"iri:", (String)id);
            } else if ("IRDI".equals(idType)) {
                result = IdentifierType.compose((String)"irdi:", (String)id);
            } else {
                ReadAasxFile.getLogger().warn("Unconsidered semanticId idType " + idType + " at " + id);
            }
            return result;
        }

        private String getAttributeValue(Node node, String attribute, String dflt) {
            String result = dflt;
            Node attr = node.getAttributes().getNamedItem(attribute);
            if (null != attr) {
                result = attr.getTextContent().trim();
            }
            return result;
        }

        private class ConceptDescription {
            private String idShort;
            private String identification;
            private String description;
            private String dataSpecId;
            private String isCaseOf;
            private Map<String, String> iecDefinition = new HashMap<String, String>();

            private ConceptDescription() {
            }

            public String getDescription() {
                String result = this.iecDefinition.get("en");
                if (null == result && this.iecDefinition.size() > 0) {
                    result = this.iecDefinition.values().iterator().next();
                }
                if (null == result) {
                    result = this.description;
                }
                return result;
            }
        }

        private static interface QualifierConsumer {
            public void consume(String var1, String var2);
        }

        private static interface FieldHandler {
            public boolean handle(AasField var1, Node var2, String var3);
        }
    }

    private static class AasTypeResult {
        private AasType type;
        private int[] cardinality;
        private String exampleValue;
        private String version;

        private AasTypeResult(AasType type, int[] cardinality, String exampleValue, String version) {
            this.type = type;
            this.cardinality = cardinality;
            this.exampleValue = exampleValue;
            this.version = version;
        }
    }
}

