/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.AasChanges;
import de.iip_ecosphere.platform.configuration.ConfigurationFactoryDescriptor;
import de.iip_ecosphere.platform.configuration.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.PlatformInstantiation;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static ConfigurationFactoryDescriptor desc;
    private static ConfigurationSetup setup;
    private static AasChanges aasChanges;

    private static void init() {
        if (null == desc) {
            Plugin plugin = PluginManager.getPlugin(ConfigurationFactoryDescriptor.class);
            if (null != plugin) {
                desc = (ConfigurationFactoryDescriptor)plugin.getInstance();
            } else {
                ServiceLoader loader = ServiceLoaderUtils.load(ConfigurationFactoryDescriptor.class);
                Optional first = ServiceLoaderUtils.findFirst((ServiceLoader)loader);
                if (first.isPresent()) {
                    desc = (ConfigurationFactoryDescriptor)first.get();
                } else {
                    LOGGER.error("No configuration factory available.");
                }
            }
        }
    }

    public static ConfigurationSetup getSetup() {
        ConfigurationFactory.init();
        ConfigurationSetup result = setup;
        if (null == result) {
            if (null != desc) {
                result = desc.getSetup();
            }
            if (null == result) {
                try {
                    result = (ConfigurationSetup)((Object)ConfigurationSetup.readFromYaml(ConfigurationSetup.class));
                }
                catch (IOException e) {
                    result = new ConfigurationSetup();
                }
            }
        }
        return result;
    }

    public static AasChanges getAasChanges() {
        ConfigurationFactory.init();
        AasChanges result = aasChanges;
        if (null == result && null != desc) {
            result = desc.createAasChanges();
        }
        return result;
    }

    public static PlatformInstantiation createInstantiator(File localRepo, Consumer<String> warn, Consumer<String> info, Consumer<Long> executionTimeConsumer) {
        ConfigurationFactory.init();
        PlatformInstantiation result = null;
        if (null != desc) {
            result = desc.createInstantiator(localRepo, warn, info, executionTimeConsumer);
        }
        return result;
    }

    public static void hintAppsToInstantiate(String apps) {
        if (null != desc) {
            desc.hintAppsToInstantiate(apps);
        }
    }
}

