/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.eclipse.EASyUtils;
import net.ssehub.easy.producer.eclipse.PLPWorkspaceListener;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.observer.EclipseProgressObserver;
import net.ssehub.easy.producer.eclipse.persistency.EASyPersistencer;
import net.ssehub.easy.producer.eclipse.persistency.PersistencerFactory;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.NatureUtils;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.IEASyProjectConfigurator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.InvalidProjectnameException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ProjectAlreadyExistsException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ProjectCreator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ResourcesMgmt {
    public static final ResourcesMgmt INSTANCE = new ResourcesMgmt();
    private boolean enableBackgroundTasks = true;

    private ResourcesMgmt() {
    }

    public void enableBackgroundTasks(boolean enable) {
        this.enableBackgroundTasks = enable;
    }

    public boolean isPLPInWorkspace(String name) {
        boolean available = false;
        try {
            IProject project = this.getProject(name);
            if (project != null) {
                available = project.isOpen() && project.hasNature("de.uni_hildesheim.sse.EASy-Producer");
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return available;
    }

    public IProject getProject(String projectname) {
        return this.getWorkspace().getRoot().getProject(projectname);
    }

    public IWorkspace getWorkspace() {
        IWorkspace ws = null;
        try {
            ws = ResourcesPlugin.getWorkspace();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return ws;
    }

    public File getWorspaceFolder() {
        File wsFolder = null;
        IWorkspace ws = this.getWorkspace();
        if (ws != null) {
            wsFolder = ws.getRoot().getLocation().toFile();
        }
        return wsFolder;
    }

    public IProject[] getAllProjects() {
        return this.getWorkspace().getRoot().getProjects();
    }

    private ArrayList<IProject> getAllPLProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = this.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("de.uni_hildesheim.sse.EASy-Producer")) {
                    projects.add(project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return projects;
    }

    public void findPLProjects(EclipseProgressObserver obs) {
        ArrayList<IProject> plProjects = this.getAllPLProjects();
        if (this.enableBackgroundTasks && plProjects.size() > 0) {
            SPLsManager splsMngr = SPLsManager.INSTANCE;
            for (IProject plProject : plProjects) {
                File projectPath = plProject.getLocation().toFile();
                EASyPersistencer persistency = new EASyPersistencer(projectPath, obs, plProject);
                String projectID = persistency.getProjectID();
                PLPInfo plp = splsMngr.getPLP(projectID);
                if (plp != null && !plp.isPreliminary()) continue;
                try {
                    plp = persistency.load();
                }
                catch (PersistenceException pExc) {
                    pExc.printStackTrace();
                }
            }
        }
    }

    public void refreshProject(String projectname) {
        if (this.getWorkspace() != null && !this.getWorkspace().isTreeLocked()) {
            try {
                IProject project = this.getProject(projectname);
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public File getProjectLocation(String projectname) {
        File projectLocation = null;
        if (this.getProject(projectname).getLocation() != null) {
            projectLocation = this.getProject(projectname).getLocation().toFile();
        } else {
            File workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            projectLocation = new File(workspace, projectname);
        }
        return projectLocation;
    }

    public char getSeperator() {
        return '/';
    }

    public String getIDfromResource(IResource theResource, IProject project) {
        EASyPersistencer persistencer2;
        String theID = null;
        QualifiedName qname = new QualifiedName("de.uni-hildesheim.sse.easy_producer.projectuuid", "projectid");
        try {
            if (theResource.getPersistentProperty(qname) == null) {
                persistencer2 = new EASyPersistencer(theResource.getProject().getLocation().toFile(), null, project);
                theID = persistencer2.getProjectID();
                if (theID != null) {
                    theResource.setPersistentProperty(qname, theID.toString());
                }
            } else {
                theID = theResource.getPersistentProperty(qname);
            }
        }
        catch (CoreException persistencer2) {
            // empty catch block
        }
        if (theID == null) {
            persistencer2 = new EASyPersistencer(theResource.getProject().getLocation().toFile(), null, project);
            theID = persistencer2.getProjectID();
        }
        return theID;
    }

    public void addEASyNatures(IProject project, String ... natures) throws CoreException, InvalidProjectnameException, IOException {
        IOException exc = null;
        PLPWorkspaceListener.disableFor(project);
        if (natures != null) {
            int i = 0;
            while (i < natures.length) {
                if (!NatureUtils.hasNature(project, natures[i])) {
                    NatureUtils.addNature(project, natures[i], null);
                }
                NatureUtils.ensureBuilder(project, "de.uni_hildesheim.sse.EASy-Producer.Builder", "org.eclipse.xtext.ui.shared.xtextBuilder", null);
                ++i;
            }
        }
        try {
            this.loadAndInitialize(project);
        }
        catch (IOException e) {
            exc = e;
        }
        PLPWorkspaceListener.reenableFor(project);
        project.refreshLocal(2, null);
        if (exc != null) {
            throw exc;
        }
        PLPWorkspaceListener.addProject(project);
    }

    private void loadAndInitialize(IProject project) throws IOException, InvalidProjectnameException {
        try {
            EASyUtils.loadProject(project);
        }
        catch (PersistenceException e) {
            EASyUtils.determineConfigurationPaths(project);
            try {
                ProjectCreator creator = new ProjectCreator(project.getName(), true);
                ProductLineProject plp = creator.newPLP(new IEASyProjectConfigurator[]{null});
                EASyUtils.initialize(project, (PLPInfo)plp);
                plp.save();
                PersistencerFactory.getPersistencer(plp.getProjectLocation(), null, project).update();
            }
            catch (ProjectAlreadyExistsException ae) {
                throw new IOException(ae.getMessage());
            }
            catch (PersistenceException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(ResourcesMgmt.class, "net.ssehub.easy.producer.eclipse").exception((Exception)((Object)exc));
            }
        }
    }
}

